
/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/

/* search.h -- binary search framework.

	Program by:  Mark Maimone   10/15/87    CMU Computer Science

	This framework provides two macros for performing a binary search
   on an array of arbitrary type.  The first,
   bin_search_function_declaration   requires the name of the function as a
   parameter, and generates a type declaration to indicate that the return
   value is an integer.

	The second, bin_search_function_definition, requires four
   parameters; the name of the function, the type of object contained in
   the array, a less than function (or macro) and an equal to function (or
   macro).  It is to be invoked at most once per program for each name.
   Otherwise, multiple function definitions would result.

	Once expanded, the named function will search through its array
   parameter, assuming that indicies between 0 and the given maximum are
   allowed.

	The function definition macro requires that the follow parameters
   be given:

	name -- the name of the function being defined.
	lt   -- macro or function which is true iff the first parameter is
		less than the second (with respect to an arbitrary total
		ordering)
	eq   -- macro or function which is true iff the two parameters have
		the same value
	type -- typedef or #define for the type of the elements in the
		array
	vtype-- typedef or #define for the type of the key value
	key_of- access function or macro to determine the key of the array
		element

	Once it has been defined, the search function itself will require
   three parameters:

	value -- value to search for in the array
	array -- array of data values, presumed to be sorted in increasing
		 order (with respect to the   lt   function defined above),
		 and low index value of 0
	count -- the number of elements in the sorted array
*/

/* search -- returns the index of the member of   array   which has the
   same value.  If   value   is not contained in    array,   the index
   value returned will point to a next lower value in the array.  For
   example:

	[10, 20, 30, 40]
      ^  ^     ^ ^       ^_____	search (45) ==> 3
      |  |     | |_____________	search (30) ==> 2
      |  |     |_______________	search (25) ==> 1
      |  |_____________________	search (10) ==> 0
      |________________________	search (5)  ==> -1
*/

#define bin_search_function_declaration(name) int name ()
#define bin_search_function_definition(name,type,vtype,key_of,lt,eq) \
int name (value, array, count) \
vtype value; \
type array[]; \
int count; \
{ \
    register int counter, minimum, maximum; \
\
    minimum = -1; \
    maximum = count; \
    counter = (maximum - 1) / 2; \
\
    do { \
	if (lt (value, key_of (array[counter]))) \
	    maximum = counter; \
	else if (eq (value, key_of (array[counter]))) { \
\
/* Ensure that the loop will be exited after the next counter update */ \
\
	    minimum = counter; \
	    maximum = minimum + 1; \
	} else \
	    minimum = counter; \
\
/* Give counter the floor of (min + max) / 2, accounting for negative \
   numbers */ \
\
	counter = (minimum + maximum) < 0 ? ((minimum + maximum - 1) / 2) : \
		((minimum + maximum) / 2); \
\
    } while (maximum - minimum > 1); \
\
    return counter; \
} /* name */
