
/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/

/* CONVERT.H -- Declarations for types/functions related to module for
                converting parse-tree values to variables.

   $Header: convert.h,v 1.4 91/05/22 13:21:24 heydon Exp $

   Written by Allan Heydon for the Miro project at Carnegie Mellon

   OVERVIEW OF THIS MODULE

   This module provides conversion functions for the 3 basic types
   IntPValType, IdPValType, and StringPValType. The conversion functions are
   used by the routines MatchPNames() and MatchNextListElement() in extract.c.
   They are passed to the function AddPNameDesignator() in extract.c.

   You can write your own conversion functions for any non-basic types you
   desire. Each conversion function should take the form:

      void ConvertFunc(p_val_ptr,val_ptr,line_no)
        PropVal *p_val_ptr;
	Generic *val_ptr;
	int line_no;

   where 'p_val_ptr' will be a pointer to the PropVal pointed to by the
   AttrEntry, 'val_ptr' will be a pointer to the variable which should be
   changed, and 'line_no' will be the line number on which the property name
   occurred in the input (this should be used when reporting errors). The
   conversion function should know what type of data 'val_ptr' is actually
   pointing to and can therefore cast that pointer accordingly.

   WHAT THIS MODULE PROVIDES

   This module defines the following TYPES:
     ConvertFunc - the type of the conversion functions appearing here, and
                   the type of your personal conversion functions

   It provides the following FUNCTIONS:
     ConvertInt()     - convert integer entries to type (int)
     ConvertId()      - convert identifier entries to type (String)
     ConvertString()  - convert string entries to type (String)
     ConvertBoolean() - convert 'true' or 'false' entries to type (Boolean)
*/

#ifndef CONVERT_H
#define CONVERT_H

/* TYPES ================================================================== */

/* ConvertFunc is a pointer to a function returning void */
typedef void (*ConvertFunc)();

/* GLOBAL FUNCTION DECLARATIONS =========================================== */

void ConvertInt( /* PropVal *p_val_ptr, Generic *val_ptr, int line_no */ );
/* Assumes 'p_val_ptr' points to a PropVal with a PropValTypeOf IntPValType
   and sets *((int *)val_ptr) to the integer IntValOf(p_val_ptr).
*/

void ConvertId( /* PropVal *p_val_ptr, Generic *val_ptr, int line_no */ );
/* Assumes 'p_val_ptr' points to a PropVal with a PropValTypeOf IdPValType
   and sets *((String *)val_ptr) to the string IdValOf(p_val_ptr).
*/

void ConvertString( /* PropVal *p_val_ptr, Generic *val_ptr, int line_no */ );
/* Assumes 'p_val_ptr' points to a PropVal with a PropValTypeOf StringPValType
   and sets *((String *)val_ptr) to the string StringValOf(p_val_ptr).
*/

void ConvertBoolean( /* PropVal *p_val_ptr, Generic *val_ptr, int line_no */ );
/* Assumes 'p_val_ptr' points to a PropVal with a PropValType of IdPValType
   and sets *((Boolean *)val_ptr) to True if the identifier is "true" and
   False if the identifier is "false". Otherwise, an error is reported on line
   'line_no'.
*/

#endif CONVERT_H
