
/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/

/* ERROR.H -- Declarations for types/functions for error-reporting.

   $Header: error.h,v 1.4 91/06/21 16:16:58 heydon Exp $

   Written by Allan Heydon for the Miro project at Carnegie Mellon

   OVERVIEW OF THIS MODULE

   This module provides a standard mechanism for error-reporting. All errors
   should be reported via calls to this module. They will then all have the
   same format, and in addition, the global variable 'parse_error_cnt' defined
   in parser.g will always contain the total number of errors reported.

   All of the functions in the module take an integer line number and a
   template string. The line number should be the line in the source file on
   which the error being reported occurs. The template string is the same as
   the template used by the printf() family of functions. Additionally, most
   of the functions in this module take extra arguments which are passed to
   the printf() routine after the template. So, for example, if an extra
   String argument is passed, the template should contain "%s".

   WHAT THIS MODULE PROVIDES

   This module defines the following FUNCTIONS:
     ParseError   - report an error (no extra arguments)
     ParseErrorI  - report an error using 1 extra int argument
     ParseErrorS  - report an error using 1 extra String argument
     ParseErrorSS - report an error using 2 extra String arguments
     yyerror      - yacc-related error reporting function
*/

#ifndef ERROR_H
#define ERROR_H

#include <my-types.h>

/* GLOBAL FUNCTION DECLARATIONS =========================================== */

void ParseError( /* int line_no, char *template */ );
/* Report an error on line number 'line_no' using string 'template'; template
   should be a string constant containing no "%" directives.
*/

void ParseErrorI( /* int line_no, char *template, int int_val */ );
/* Report an error on line number 'line_no' using string 'template'; template
   should be a string constant containing exactly one "%d" (or "%x", "%o",
   etc.) directive. The integer 'int_val' will be printed in place of the "%d"
   in 'template'.
*/

void ParseErrorS( /* int line_no, char *template, String string_val */ );
/* Report an error on line number 'line_no' using string 'template'; template
   should be a string constant containing exactly one "%s" directive. The
   String 'string_val' will be printed in place of the "%s" in 'template'.
*/

void ParseErrorSS( /* int line_no, char *template, String sval_1,
		      String sval_2 */ );
/* Report an error on line number 'line_no' using string 'template'; template
   should be a string constant containing exactly two "%s" directives. The
   Strings 'sval_1' and 'sval_2' will be printed in place of the "%s"'s in
   'template'.
*/

void yyerror( /* String error_msg */ );
/* Called by yacc to report the error message 'error_msg'. The line number of
   the error is also reported as that contained in the global variable
   'curr_line_no' declared in parser.g.
*/

void ProgrammerErrorI( /* String filename, char *template, int int_val */ );
/* Prints out an error caused by a buggy program. The error message takes the
   form:
      programmer error: 'filename'
              'template'
   where 'template' must contain a single "%d" directive. The value of
   'int_val' is printed in place of the "%d" in 'template'.

   A call to this function causes an immediate exit() from the program, with
   status value -2.
*/

#endif ERROR_H
