/* ============================================================
  IFF2PS.H -- declarations for types, functions and variables used 
  by the Miro IFF to PostScript translator.

  $Header: iff2ps.h,v 1.4 91/06/21 16:14:32 heydon Exp $

  Written by Amy Moormann Zaremski for the Miro project at 
  Carnegie Mellon 
============================================================*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


/* set debugging flag for lots of feedback.. */
/* #define IFF2PS_DEBUG */
/* #define E_DEBUG */

/* need stdio for file processing */
#include <stdio.h>

/* need math for string -> number conversions */
#include <math.h>

/* need my-defs for Next and StepLinkedList -- used in the show* functions */
#include "my-defs.h"

/* parser declarations */
#include "parser.h"
#include "parser.g" 

/* extract declarations */
#include "extract.h"


/* ========================= TYPES ========================= */
/* Boolean */
#define	    FALSE   0
#define	    TRUE    1
#define	    Bool    int

/* Coordinates */
typedef struct cd {
    int     x,
            y;
}                   Coord;

/* Integer node */
typedef struct int_tag {
  struct int_tag *next;
  int value;
} IntNode;


/* Box nodes -- only keep info needed by PostScript printing routines */
typedef struct node_box_tag {
  struct node_box_tag *next;	/* next box in box list */
  int sysname;			/* system id of this box */
  String name;			/* name of this box */
  Coord loc;			/* location of this box */
  Coord size;			/* size of box */
  Coord labelloc;		/* location of label (not required) */
  Bool    thick;		/* true iff box is thick */
  Bool    starred;		/* whether the box is starred */
  Bool highlighted;		/* true iff box is highlighted */
}            BoxNode;
  

/* Arrow nodes -- only keep info needed by PostScript printing routines */
typedef struct node_arrow_tag {
  struct node_arrow_tag *next;	/* next arrow in arrow list */
  int sysname;			/* system id of this arrow */
  String type;			/* type(s) (label(s)) of this arrow  */
  String kind;			/* kind (syn/sem/con) of this arrow */
  Coord tailloc;		/* location of arrow's tail */
  Coord headloc;		/* location of arrow's head */
  Coord labelloc;		/* location of label (not required) */
  Bool parity;			/* parity of the arrow */
  Bool thick;			/* true iff arrow is thick */
  Bool starred;			/* whether the arrow is starred */
  Bool highlighted;		/* true iff arrow is highlighted */
}           ArrowNode;
  

/* Editor nodes -- only keep info needed by PostScript printing routines */
typedef struct node_editor_tag {
  struct node_editor_tag *next;	/* next editor in editor list */
  IntNode *highlightedboxes;	/* list of boxes to highlight (ordered) */
  IntNode *highlightedarrows;	/* list of arrows to highlight (ordered) */
}           EditorNode;
  

/* ==================== GLOBAL CONSTANTS ===================== */

/* maximum number of property names associated with any entry */
#define MaxNumPNames 9

/* maximum value of a coordinate */
#define CoordLimit 10000

/* ================== GLOBAL VARIABLES ===================== */
char *progname;

/* lists of processed entries */
BoxNode *boxes;			/* list of boxes */
ArrowNode *arrows;		/* list of arrows */
EditorNode *ed_entries;		/* list of editor entries */

int max_x, max_y;		/* max x and y values of picture */
int min_x, min_y;		/* min x and y values of picture */

/* Command line parameters */
Bool best_fit;			/* true iff -b flag specified */
Bool in_text;			/* true iff picture will be inserted in text */
Bool rotate;			/* true iff picture should be rotated */
Bool center;			/* true iff picture should be centered */
float scale_factor;		/* scale factor */
int fontsize;			/* font size (default = 10) */


/* ==================== GLOBAL FUNCTIONS ======================= */
/* in iff2ps.c */
FILE *Initialize();
void halt();

/* in process.c */
void ExtractLists();
void ProcessHighlighting();

/* in print.c */
void PrintPostscript();

/* in convert.c */
void myConvertInt();
void ConvertStr();
void ConvertThick();
void ConvertBool();
void myConvertParity();

/* in nodes.c */
GenericEntry *InitNode();
void InsertNode();
void SetBoxSlots();
void SetArrowSlots();
Bool HighlightedP();

/* debugging functions */
void myShowParseTree();
static void ShowPropVal();
static void ShowAttr();
static void ShowEntry();

