
/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/

/* MEM.H - Declarations for types/functions related to the memory allocation
           module.

   $Header: mem.h,v 1.6 91/06/21 15:32:49 heydon Exp $

   Written by Allan Heydon for the Miro project at Carnegie Mellon

   OVERVIEW OF THIS MODULE

   This module allows memory allocation in blocks.

   The module is initialized by a call to InitMem(). The primary allocation
   functon is AllocBlock(), although macros AllocOne(), AllocArray(), and
   AllocPtrArray() are provided for allocating one item of a particular type,
   an array of some number of items of a particular type, and an array of some
   number of pointers to items of some type. The FreeBlock() function allows
   memory de-allocation. Finally, ShutDownMem() is called to end use of this
   module.

   This module should be included after "my-defs.h".

   WHAT THIS MODULE PROVIDES

   This module provides the following FUNCTIONS:
      InitMem()       - Initialize this module; must be called before any
                        other routines in this module.
      AllocBlock()    - Allocate a block of memory of some number of bytes.
      FreeBlock()     - De-allocate a previously allocated block.
      ShutDownMem()   - End the use of this module.
*/

#ifndef MEM_H
#define MEM_H

#include <my-types.h>
/* This will break with a "redefined" error if my-defs.h was included first. */
#define MALLOC AllocBlock
#define FREE FreeBlock
#include <my-defs.h>


/* GLOBAL FUNCTION DECLARATIONS =========================================== */

void InitMem();
/* Initialize this module. This routine must be called before any other
   routines in this module.
*/

Generic *AllocBlock( /* unsigned size */ );
/* Allocate a block of 'size' bytes, and RETURN a pointer to this block.
*/

void FreeBlock( /* Generic *ptr */ );
/* De-allocate the block of memory pointed to by 'ptr' that was previously
   allocated by one of the allocation functions above.
*/

void ShutDownMem( /* void */ );
/* Shut down this module. Call this routine after all allocated memory is no
   longer required for use.
*/

#endif
