
/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/

#ifndef MWM_INCLUDE
#   define MWM_INCLUDE

/*

FIND CURRENT DIRECTORY
	-- loads the current directory's full pathname into global variable
	   cwd; there will be *no* trailing slash ('/') in the pathname.
	-- initialize the variable by calling   init_cwd(),   with no
	   parameters.

CURRENT DATE
	-- char *whats_today()   returns a readable static string with the
	   current date and time.

HOSTNAME
	-- char *what_host ()   returns the name of the machine on which
	   the program is being run

GUARANTEED MEMORY
	-- char *must_malloc (bytes, desc)   will either successfully
	   allocate   bytes   bytes of memory, or issue an error containing
	   desc   and exit(1).


STACK MEMORY ADT
	-- Sometimes it's useful to keep extra information around in a
	   depth-first search.  For instance, when scanning a filesystem
	   you might want to remember the names of all files or
	   directories in an ancestor's directory.  This Abstract Data
	   Type provides an easy way to remember lots of extra information
	   in a stack.  It's also quite simple to free up space; just free
	   up the single element nearest the new top of stack (where you
	   want to be after popping old, useless data), and all of the
	   memory in between will automatically free up.
	-- StackMemoryT *st_init (block_len)   -- initializes an object of
	   StackMemoryT.  You simply specify the longest block length that
	   you ever expect to allocate (but you're not bound to it, the
	   routines can increase this limit if usage demands it).  Returns
	   NULL on failure.
	-- char *st_alloc (memptr, bytes)   -- what you call instead of
	   malloc.  memptr is the address of a valid StackMemoryT pointer;
	   the value of that pointer will change if another block of
	   memory gets allocated.  Returns a pointer to a word-aligned
	   free section of memory if successful, NULL on failure.
	-- int st_free (memptr, loc)   -- free up all stack frames above
	   the given memory   loc.   No memory is actually deallocated, we
	   just adjust some pointers (this helps prevent thrashing on
	   malloc calls).  Returns 1 if successful, 0 otherwise.
	-- int st_in (memptr, loc)   -- see if   loc   lies somewhere on
	   the stack.  Returns 0 on error or if   loc   is not in the stack,
	   1 otherwise.

PERMANENT STRING STORAGE
	-- char *new_string (str) -- allocate a copy of   str   in
	   permanent storage (i.e. storage which need never be reclaimed).
	   Doesn't return if no memory is available.

WRITE C STRING
	-- int fwrstr (fp, str), fwrstrn (fp, str, n), wrstr (str), wrstrn
	   (str, n), char *swrstr (s, str), char *swrstrn (s, str, n) --
	   These functions write a copy of their input string, modified to
	   conform to the syntax of C strings.  E.g.,
		wrstr ("\042\115\141\162\153\042\010") ==> "\"Mark\"\n"
*/


#ifndef boolean
#  define boolean int

#  ifndef TRUE
#    define TRUE 1
#  endif TRUE

#  ifndef FALSE
#    define FALSE 0
#  endif FALSE
#endif boolean

#define NOT_IN_VECTOR -1	/* cannot be a valid array index */

/* macros for the   parse_args   routine */

#define P_STRING 1		/* Macros for the result_type attribute */
#define P_CHAR 2
#define P_SHORT 3
#define P_LONG 4
#define P_INT P_LONG
#define P_FILE 5
#define P_OLD_FILE 6
#define P_NEW_FILE 7
#define P_FLOAT 8
#define P_DOUBLE 9

#define P_CASE_INSENSITIVE 01	/* Macros for the   flags   attribute */
#define P_REQUIRED_PREFIX 02

#define P_NO_ARGS 0		/* Macros for the   arg_count   attribute */
#define P_ONE_ARG 1
#define P_INFINITE_ARGS 2

#define p_entry(pref,swit,flag,count,type,store,size) \
    { (pref), (swit), (flag), (count), (type), (int *) (store), (size) }

typedef struct {
    char *prefix;
    char *string;
    int flags;
    int count;
    int result_type;
    int *result_ptr;
    int table_size;
} arg_info;

/* in_range -- returns TRUE iff

   Algebraic:   min (bound1, bound2) <= num <= max (bound1, bound2)

   English:     num   lies between   bound1 and bound2
*/

#define in_range(num,bound1,bound2) ((_r_b1 = (bound1)) > (_r_b2 = (bound2)) ?\
	((_r_n = (num)) > _r_b1 ? FALSE : (_r_n < _r_b2 ? FALSE : TRUE)) : \
	((_r_n = (num)) < _r_b1 ? FALSE : (_r_n > _r_b2 ? FALSE : TRUE)))

#ifndef NO_MWM_VARS
#  ifndef mklow
#    define mklow(c) (((_2lo = (c)) >= 'A' && _2lo <= 'Z') ? _2lo + 32 : _2lo)

     static char _2lo;
#  endif mklow
#  ifndef mkupp
#    define mkupp(c) (((_2up = (c)) >= 'a' && _2up <= 'z') ? _2up - 32 : _2up)

     static char _2up;
#  endif mkupp

#  ifndef int_min
#    define int_min(a,b) (_int_m_a = (a), _int_m_b = (b), _int_m_a < \
	_int_m_b ? _int_m_a : _int_m_b)
#    define int_max(a,b) (_int_m_a = (a), _int_m_b = (b), \
	(_int_m_a < _int_m_b) ? _int_m_b : _int_m_a)

     static int _int_m_a, _int_m_b;
#  endif int_min

#  ifndef ordinal_suffix
#    define ordinal_suffix(x) \
		(_o_s_x = (x), _o_s_x = int_max (_o_s_x, -_o_s_x), \
		((_o_s_x % 10 == 1 && _o_s_x != 11) ? "st" : \
		((_o_s_x % 10 == 2 && _o_s_x != 12) ? "nd" : \
		((_o_s_x % 10 == 3 && _o_s_x != 13) ? "rd" : "th"))))
     static int _o_s_x;
#  endif ordinal_suffix
#endif NO_MWM_VARS

#define wrstr(s)		fwrstr (stdout, (s))
#define wrstrn(s,n)		fwrstrn (stdout, (s), (n))


/* StackMemoryT definition. */

typedef struct SMT {
    struct SMT *prev;	/* pointer to previous memory block */
    struct SMT *next;	/* pointer to next (already allocated) block */
    int block_len;	/* length (in bytes) of each block for strings */
    char *start;	/* pointer to start of actual storage */
    char *top;		/* pointer to next available position */
} StackMemoryT;

#ifndef ibmrt
   extern char cwd[];
#endif

void fmultout (/* FILE *fp, int number, char ch */);
char *c2s (/* char ch, int ws2text, char *buff */);
char *itoa (/* int num, char *buff */);
char *my_strncpy (/* char *dest, *source, int max_length */);
boolean in_vector (/* char *str, *vector[] */);
boolean parse_args (/* argc, argv, table, table_size, others,
				others_count */);
char *build_usage (/* table, table_size, result, result_len */);
char *basename (/* char *pathname */);
void set_costs (/* int ins, del, change, swap */);
void view_costs (/* int *ins, *del, *ch, *swap */);
int edit_dist (/* char *from, char *to */);
int cistrcmp (/* char *s1, *s2 */);
int cistrncmp (/* char *s1, *s2; int n */);

init_cwd ();
char *squish (/* pathname */);
char *whats_today ();
char *what_host ();
char *must_malloc (/* int bytes, char *desc */);
StackMemoryT *st_init (/* int block_len */);
char *st_alloc (/* StackMemoryT **mem, int bytes */);
int st_in (/* StackMemoryT **mem, char *loc */);
int st_free (/* StackMemoryT **memptr, char *loc */);
char *new_string (/* char *str */);

int fwrstr (/* FILE *fp, char *str */);
int fwrstrn (/* FILE *fp, char *str, int n */);
char *swrstr (/* char *s, *str */);
char *swrstrn (/* char *s, *str, int n */);

#endif MWM_INCLUDE
