/* MY-TYPES.H -- generic typedefs that may be useful in many programs

   $Header: my-types.h,v 1.3 91/06/21 15:40:31 heydon Exp $

   Written by Allan Heydon
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#ifndef MY_TYPES_H
#define MY_TYPES_H

/* Uint, ULint */
typedef unsigned int Uint;
typedef unsigned short int USint;
typedef unsigned long int ULint;

/* Generic */
typedef char Generic;

/* String */
typedef char *String;
#define SameString(_s1,_s2) (strcmp((_s1),(_s2)) == 0)

/* Boolean */
typedef enum {
    False=0,
    True=1
} Boolean;
#define NotOf(_expr)           ((Boolean)(!(_expr)))
#define MakeBoolean(_expr)     ((Boolean)(_expr))
#define BooleanToString(_expr) ((_expr) ? "True" : "False")

/* ErrReturn */
typedef enum {
    Okay=0,
    Error=1
} ErrReturn;

#endif MY_TYPES_H
