/* CONVERT.C -- functions for converting property values to variable values.

   $Header: convert.c,v 1.5 91/05/22 13:29:47 heydon Exp $

   Written by Allan Heydon for the Miro project at Carnegie Mellon
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#include <my-types.h>
#include <my-defs.h>

#include "error.h"
#include "parser.h"
#include "convert.h"

/* GLOBAL FUNCTIONS ======================================================= */

/* ARGSUSED -- keep lint from complaining that 'line_no' is unused */
void ConvertInt(p_val_ptr,val_ptr,line_no)
  PropVal *p_val_ptr;
  Generic *val_ptr;
  int line_no;
{
#ifdef DEBUG
    if (PropValTypeOf(p_val_ptr) != IntPValType) {
	ProgrammerErrorI("convert.c",
			 "prop_val_type should be IntValType instead of 0x%x",
			 PropValTypeOf(p_val_ptr));
    }
#endif
    *((int *)val_ptr) = IntValOf(p_val_ptr);
}

/* ARGSUSED -- keep lint from complaining that 'line_no' is unused */
void ConvertId(p_val_ptr,val_ptr,line_no)
  PropVal *p_val_ptr;
  Generic *val_ptr;
  int line_no;
{
#ifdef DEBUG
    if (PropValTypeOf(p_val_ptr) != IdPValType) {
	ProgrammerErrorI("convert.c",
			 "prop_val_type should be IdValType instead of 0x%x",
			 PropValTypeOf(p_val_ptr));
    }
#endif
    *((String *)val_ptr) = IdValOf(p_val_ptr);
}

/* ARGSUSED -- keep lint from complaining that 'line_no' is unused */
void ConvertString(p_val_ptr,val_ptr,line_no)
  PropVal *p_val_ptr;
  Generic *val_ptr;
  int line_no;
{
#ifdef DEBUG
    if (PropValTypeOf(p_val_ptr) != StringPValType) {
	ProgrammerErrorI("convert.c",
		"prop_val_type should be StringPValType instead of 0x%x",
			 PropValTypeOf(p_val_ptr));
    }
#endif
    *((String *)val_ptr) = StringValOf(p_val_ptr);
}

/* ARGSUSED -- keep lint from complaining that 'line_no' is unused */
void ConvertBoolean(p_val_ptr,val_ptr,line_no)
  PropVal *p_val_ptr;
  Generic *val_ptr;
  int line_no;
{
#ifdef DEBUG
    if (PropValTypeOf(p_val_ptr) != IdPValType) {
	ProgrammerErrorI("convert.c",
			 "prop_val_type should be IdPValType instead of 0x%x",
			 PropValTypeOf(p_val_ptr));
    }
#endif DEBUG
    if (SameString("true",IdValOf(p_val_ptr))) {
	*((Boolean *)val_ptr) = True;
    } else if (SameString("false",IdValOf(p_val_ptr))) {
	*((Boolean *)val_ptr) = False;
    } else {
	ParseErrorS(line_no,
		    "Boolean value '%s' should be either 'true' or 'false'",
		    IdValOf(p_val_ptr));
	*((Boolean *)val_ptr) = False;
    }
}
