
/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/

/* c2s -- character to string

	The input character is converted to a printable representation and
   written to the buffer   string.   Newlines and spaces are unchanged.

   EXAMPLES:
decimal ASCII code	string		decimal ASCII code	string
	0		^@			128		M-^@
	1		^A			129		M-^A
	9		TAB			137		M-TAB
	10		<newline>		138		M-\n
	13		RETURN			141		M-RETURN
	26		^Z			154		M-^Z
	32		<space>			160		M-<space>
	65		A			193		M-A
	97		a			225		M-a
	127		DEL			255		M-DEL
*/
#include <stdio.h>

char *c2s (ch, ws2text, buff)
char ch, *buff;
int ws2text;			/* white space -> text? y/n */
{
    static char store[10];
    int force_print = ws2text;

    if (!buff)
	buff = store;	 	/* If NULL, use a static buffer area */

    if (ch > 127 || ch < 0) {	/* The eighth bit is set, char is
				   non-ASCII */
	*buff++ = 'M';
	*buff++ = '-';
	force_print = 1;
	ch &= 127;
    } /* if ch > 127 || ch < 0 */

    if (force_print && ch < 32)
	switch (ch) {
	    case '\n':
	        strcpy (buff, "\\n");
	        break;
	    case '\r':
	        strcpy (buff, "RETURN");
	        break;
	    case '\t':
	        strcpy (buff, "TAB");
	        break;
	    default:
	        sprintf (buff, "^%c", ch + 64);
	        break;
	} /* switch */
    else if (ch < 127)
	sprintf (buff, "%c", ch);
    else if (ch == 127)
	strcpy (buff, "DEL");
    else {
	fprintf (stderr, "c2s:  Impossible case\n");
	*buff = '\0';
    } /* else */

    return buff;
} /* c2s */
