/* etest.c -- 

	Program by:  Mark Maimone   13/Nov/89   CMU Computer Science
	Last modified:  15/Nov/89

*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#include <stdio.h>
#include <mwm.h>

#define my_entry(swit,count,type,store,size) p_entry \
	("-", (swit), P_CASE_INSENSITIVE, (count), (type), (store), (size))
#define MAX_WORDS 2
#define INS_DEFAULT 1
#define DEL_DEFAULT 1
#define CH_DEFAULT 1
#define SW_DEFAULT 1

/* INCLUDE PARSE STATE VARIABLES HERE */

int show_help = 0;
int verbose = 0;
int insert = INS_DEFAULT;
int delete = DEL_DEFAULT;
int change = CH_DEFAULT;
int swap = SW_DEFAULT;

char *this_program;

arg_info table[] = {
    my_entry ("i", P_ONE_ARG, P_INT, &insert, 0),
    my_entry ("d", P_ONE_ARG, P_INT, &delete, 0),
    my_entry ("c", P_ONE_ARG, P_INT, &change, 0),
    my_entry ("s", P_ONE_ARG, P_INT, &swap, 0),
    my_entry ("t", P_ONE_ARG, P_INT, &swap, 0),
    my_entry ("v", P_NO_ARGS, P_INT, &verbose, 1),
    my_entry ("h", P_NO_ARGS, P_INT, &show_help, 1),
    my_entry ("?", P_NO_ARGS, P_INT, &show_help, 1),

/* INCLUDE ADDITIONAL COMMAND LINE ARGUMENTS HERE */

}; /* table */
#define table_size (sizeof (table) / sizeof (arg_info))


main (argc, argv)
int argc;
char *argv[];
{
    extern char *this_program;
    char *words[MAX_WORDS + 1];
    int d;

    einit ();
    if (argv[0])
	this_program = argv[0];
    else
	this_program = "";

    if (!parse_args (argc, argv, table, table_size, words, MAX_WORDS)) {
	fprintf (stderr, "%s:  Illegal arguments, quitting\n", this_program);
	exit (1);
    } /* if (!parse_args) */

    if (show_help) {
	do_show_help ();
	exit (0);
    } /* if (show_help) */

    if (verbose)
	printf ("COSTS: Insert %d, Delete %d, Change %d, Swap %d\n",
		insert, delete, change, swap);

    if (words[0] == NULL || words[1] == NULL) {
	fprintf (stderr,
		"%s:  Sorry, must have two words on the command line\n",
		this_program);
	exit (1);
    } /* if words == NULL */

    set_costs (insert, delete, change, swap);
    d = edit_dist (words[0], words[1]);
    printf ("\n Edit distance is %d\n", d);

} /* main */


do_show_help ()
{
    fprintf (stderr, "%s:  Edit Distance Finder\n\n", this_program);
    fprintf (stderr, "   This program compares two strings given on the ");
    fprintf (stderr, "command line, and returns\nthe edit distance between ");
    fprintf (stderr, "them.  This is defined to be the least cost in terms\n");
    fprintf (stderr, "of four operations:  INSERT, DELETE, CHANGE, and ");
    fprintf (stderr, "SWAP.  These integer costs\nmay be set by command ");
    fprintf (stderr, "line switches, given below.\n\n");
    fprintf (stderr, "SWITCHES:\n");
    fprintf (stderr, "\t-i#\tSet INSERT cost (default %d)\n", INS_DEFAULT);
    fprintf (stderr, "\t-d#\tSet DELETE cost (default %d)\n", DEL_DEFAULT);
    fprintf (stderr, "\t-c#\tSet CHANGE cost (default %d)\n", CH_DEFAULT);
    fprintf (stderr, "\t-s,t#\tSet SWAP cost (default %d)\n", SW_DEFAULT);
    fprintf (stderr, "\t-v\tEnable VERBOSE mode\n");
    fprintf (stderr, "\t-h,?\tShow this HELP message\n");
} /* show_help */
