/* fp2list.c

	Program by:  Mark Maimone 6/12/86
	Last Modified:  6/18/86
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#include <stdio.h>
#include <strings.h>
#include "errors.h"
#include "list_type.h"

#define strchr index

#define DIAGNOSTIC if (diagnostic_output) fprintf (diagnostic_output,

void skip_white_space ();
list_type parse_atom ();
int parse_list ();


int fp2list (fp, result, strbuf, white_space, open_chars, close_chars,
	diagnostic_output)
FILE *fp;		/* File containing the text to be parsed */
list_type *result;	/* Pointer to the location in which the parse
			   value will be stored (i.e. a VAR parameter) */
char **strbuf;		/* Pointer to the buffer area; on exit, this will point
			   to the remaining free space in the buffer */
char *white_space;	/* String containing all white space characters */
char *open_chars;	/* String containing all list opening characters,
			   e.g. (, {, [, in 1-1 correspondence with .... */
char *close_chars;	/* String containing ll list closing characters,
			   e.g. ), }, ] */
FILE *diagnostic_output;
{
    char *ptr, c;
    int ret_val, my_index;

    skip_white_space (fp, white_space);
    if (feof (fp))
	return 0;

    c = getc (fp);

    if ((ptr = strchr (close_chars, c)) != NULL) {

	DIAGNOSTIC "Closing char '%c' read too soon\n", c);
	ret_val = -1;

    } else if ((ptr = strchr (open_chars, c)) == NULL) {

	ungetc (c, fp);
	*result = parse_atom (fp, strbuf, white_space, open_chars,
		close_chars);
	ret_val = 1;

    } else {	/* Must be an opening character */

	my_index = ptr - open_chars;
	skip_white_space (fp, white_space);
	ret_val = parse_list (fp, result, close_chars[my_index], strbuf,
		white_space, open_chars, close_chars, diagnostic_output);
    } /* else */

    return ret_val;
} /* fp2list */

/* parse_atom -- copy the string from   fp   into   strbuf,   updating
   strbuf   and stopping when a white space, opening or closing character
   is read.  ASSUMPTION:  the first character in   fp   will be contained
   in the atom. */

list_type parse_atom (fp, strbuf, white_space, open_chars, close_chars)
FILE *fp;
char **strbuf;
char *white_space, *open_chars, *close_chars;
{
    register char c;
    list_type ret_val = (list_type) *strbuf;

    while (!strchr (white_space, (c = getc (fp))) && !strchr (open_chars, c)
	    && !strchr (close_chars, c) && !feof (fp))
	*(*strbuf)++ = c;

    *(*strbuf)++ = '\0';
    ungetc (c, fp);
    return ret_val;
} /* parse_atom */

/* parse_list -- ASSUMPTION:  first char is not white space */

int parse_list (fp, result, end_char, strbuf, white_space, open_chars,
	close_chars, diagnostic_output)
FILE *fp;
list_type *result;
char end_char;		/* Character which will terminate this list */
char **strbuf;
char *white_space, *open_chars, *close_chars;
FILE *diagnostic_output;
{
    register char c;
    int ret_val;
    list_type temp;

    c = getc (fp);
    if (c == end_char) {
	*result = nil;
	ret_val = 1;
    } else if (strchr (close_chars, c)) {
	*result = nil;		/* The logic behind this assignment is not
				   well planned, so beware */
	DIAGNOSTIC "Mismatched delimeters; expected '%c', got '%c'\n",
		end_char, c);
	ret_val = -1;
    } else {
	ungetc (c, fp);
	if ((ret_val = fp2list (fp, result, strbuf, white_space, open_chars,
		close_chars, diagnostic_output)) > 0) {
	    skip_white_space (fp, white_space);
	    ret_val = parse_list (fp, &temp, end_char, strbuf, white_space,
		    open_chars, close_chars, diagnostic_output);
	    if (ret_val > 0)
		*result = cons (*result, temp);
	} /* if */
    } /* else */

    return ret_val;
} /* parse_list */

void skip_white_space (fp, white_space)
FILE *fp;
char *white_space;
{
    register char c;

    while (!feof (fp) && strchr (white_space, (c = getc (fp))));

    ungetc (c, fp);
} /* skip_white_space */
