
/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/

#include <mwm.h>

/* in_vector -- verifies whether   str   can satisfy one of the strings in
   vector.   If so, the index is returned else   NOT_IN_VECTOR   is returned.
   str   "satisfies" one of the vectored strings if its first few
   characters exactly match those of a string in   vector.   Only an exact
   match will be accepted.
*/

boolean in_vector (str, vector)
char *str, *vector[];
{
    register int index;			/* current index */
    register int best_index = NOT_IN_VECTOR;
					/* index of the best match so far */
    register int length;		/* length of current vector pattern */
    register int best_length = -1;	/* length of best match so far */

    extern int strncmp (), strlen ();

    for (index = 0; vector && vector[index]; index++)
	if (!strncmp (str, vector[index], (length = strlen (vector[index]))))

    /* If the strings match, save the index:  should two copies of a
       string exist in a vector, the index of the first will be returned */

	    if (length > best_length) {
		best_index = index;
		best_length = length;
	    } /* if */

    return best_index;
} /* in_vector */
