/* itoa -- int to ascii string

	The input integer will be converted to a printable representation
   and stored in   buffer.
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#ifndef NULL
# define NULL ((char *) 0)
#endif NULL

char *itoa (num, buffer)
int num;
char *buffer;
{
    int i, sign;
    static char my_buf[50];
    extern void itoa_rev ();

/* Use a static buffer if none was given */

    if (buffer == NULL)
	buffer = my_buf;

    sign = num;		/* record sign */

    i = 0;

/* Generate the digits in reverse order */

    do {
        buffer[i++] = num % 10 + '0';	/* Store the next digit */
    } while ((num /= 10) != 0);		/* Remove the digit from   num   */

    if (sign < 0)
	buffer[i++] = '-';

    buffer[i] = '\0';
    itoa_rev (buffer);

    return buffer;
} /* itoa */

void itoa_rev (str)
char *str;
{
    int temp, i, j;

    for (i = 0, j = strlen (str) - 1; i < j; i++, j--) {
	temp = str[i];
	str[i] = str[j];
	str[j] = temp;
    } /* for */
}/* itoa_rev */
