
/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/

#include <stdio.h>
#include <mwm.h>
#include <errors.h>

int data;
char *files[10];
char *file;

/* This table is bad.  In particular:
	0: no storage for integer (i.e. boolean) value
	1: no storage for integer (i.e. boolean) value
	5: flags are invalid
	5: count is invalid
	5: type is invalid
	5: no storage
	6: no storage for table
	6: invalid upper bound for table
*/

arg_info table[] = {

    p_entry ("-", "l", 0, P_NO_ARGS, P_INT, NULL, 0),
    p_entry ("-", "a", 0, P_NO_ARGS, P_INT, NULL, 0),
    p_entry ("-", "data", 0, P_ONE_ARG, P_INT, &data, 0),
    p_entry ("-", "o", 0, P_INFINITE_ARGS, P_FILE, files, 10),
    p_entry ("-", "c", P_CASE_INSENSITIVE, P_ONE_ARG, P_OLD_FILE, &file, 0),
    p_entry ("-", "test", 4, 3, 110, NULL, -1),
    p_entry ("-", "test2", 1, P_INFINITE_ARGS, P_INT, NULL, -1)

}; /* table */

#define table_size sizeof (table) / sizeof (arg_info)

main (argc, argv)
int argc;
char *argv[];
{
    char *others[10];

    einit ();
    parse_args (argc, argv, table, table_size, others, 10);

    printf ("Data is %d\n", data);
    printf ("C file is %s\n", file);
    printf ("O files are");
    show_table (files, 10);
    printf ("\nOthers are");
    show_table (others, 10);
    putchar ('\n');

} /* main */


show_table (list, count)
char **list;
int count;
{
    while (count--) {
	if (*list)
	    printf (" %s", *list);
	list++;
    } /* while */
} /* show_table */
