/*

	zle.h - header file for line editor

	This file is part of zsh, the Z shell.

	zsh is free software; no one can prevent you from reading the source
   code, or giving it to someone else.

   This file is copyrighted under the GNU General Public License, which
   can be found in the file called COPYING.

   Copyright (C) 1990, 1991 Paul Falstad

   zsh is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  No author or distributor accepts
   responsibility to anyone for the consequences of using it or for
   whether it serves any particular purpose or works at all, unless he
   says so in writing.  Refer to the GNU General Public License
   for full details.

   Everyone is granted permission to copy, modify and redistribute
   zsh, but only under the conditions described in the GNU General Public
   License.   A copy of this license is supposed to have been given to you
   along with zsh so you can know your rights and responsibilities.
   It should be in a file named COPYING.

   Among other things, the copyright notice and this notice must be
   preserved on all copies.

*/

#ifdef ZLEGLOBALS
#define ZLEXTERN
#else
#define ZLEXTERN extern
#endif

#ifdef ZLE

/* cursor position */
ZLEXTERN int cs;

/* line length */
ZLEXTERN int ll;

/* size of line buffer */
ZLEXTERN int linesz;

/* location of mark */
ZLEXTERN int mark;

/* last character pressed */
ZLEXTERN int c;

/* forgot what this does */
ZLEXTERN int bindk;

/* command argument */
ZLEXTERN int mult;

/* insert mode flag */
ZLEXTERN int insmode;

/* cost of last update */
ZLEXTERN int cost;

/* flags associated with last command */
ZLEXTERN int lastcmd;

/* column position before last movement */
ZLEXTERN int lastcol;

#endif

/* last named command done */
ZLEXTERN int lastnamed;

/* != 0 if we're done */
ZLEXTERN int done;

/* length of prompt on screen */
ZLEXTERN int pptlen;

/* current history line number */
ZLEXTERN int histline;

ZLEXTERN int eofsent;

/* != 0 if we need to call resetvideo() */
ZLEXTERN int resetneeded;

/* != 0 if the line editor is active */
ZLEXTERN int zleactive;

/* the line buffer */
ZLEXTERN char *line;

/* the cut buffer */
ZLEXTERN char *cutbuf;

/* prompt and rprompt */
ZLEXTERN char *pmpt, *pmpt2;

/* the last line in the history (the current one) */
ZLEXTERN char *curhistline;

/* the status line */
ZLEXTERN char *statusline;

/*
	the current history line and cursor position for the top line
	on the buffer stack
*/

ZLEXTERN int stackhist,stackcs;

/* != 0 if we are in the middle of a menu completion */
ZLEXTERN int menucmp;

typedef void bindfunc DCLPROTO((void));
typedef bindfunc *F;

struct key {
	int func;			/* function code for this key */
	char *str;			/* string corresponding to this key,
								if func = z_sequenceleadin				 */
	int len;				/* length of string */
	};
struct zlecmd {
	char *name;			/* name of function */
	F func;				/* handler function */
	int flags;
	};

/* undo event */

struct undoent {
	int pref;		/* number of initial chars unchanged */
	int suff;		/* number of trailing chars unchanged */
	int len;			/* length of changed chars */
	int cs;			/* cursor pos before change */
	char *change;	/* NOT null terminated */
	};

#define UNDOCT 64

struct undoent undos[UNDOCT];

/* the line before last mod */
ZLEXTERN char *lastline;

ZLEXTERN int undoct,lastcs;

ZLEXTERN char *visrchstr;
ZLEXTERN int visrchsense;

#define ZLE_ABORT		1					/* abort cmd */
#define ZLE_MOVE		2					/* movement */
#define ZLE_MOD		4					/* text modification */
#define ZLE_LINEMOVE (8|ZLE_MOD)		/* movement or modification */
#define ZLE_INSMOD	16					/* character insertion */
#define ZLE_UNDO		32					/* undo */
#define ZLE_LINEMOVE2 (64|ZLE_LINEMOVE)	/* movement or mod */
#define ZLE_ARG      128				/* argument */
#define ZLE_KILL     256				/* killing text */
#define ZLE_MENUCMP	512				/* menu completion */
#define ZLE_YANK		1024

typedef struct key *Key;

ZLEXTERN int *bindtab;
extern int emacsbind[256];
ZLEXTERN int altbindtab[256],mainbindtab[256];
extern int viinsbind[],vicmdbind[];

#define KRINGCT 8
ZLEXTERN char *kring[KRINGCT];
ZLEXTERN int kringnum;

#define z_acceptandhold 0
#define z_acceptandinfernexthistory 1
#define z_acceptandmenucomplete 2
#define z_acceptline 3
#define z_acceptlineanddownhistory 4
#define z_backwardchar 5
#define z_backwarddeletechar 6
#define z_backwarddeleteword 7
#define z_backwardkillline 8
#define z_backwardkillword 9
#define z_backwardword 10
#define z_beginningofbufferorhistory 11
#define z_beginningofhistory 12
#define z_beginningofline 13
#define z_beginningoflinehist 14
#define z_capitalizeword 15
#define z_clearscreen 16
#define z_completeword 17
#define z_copyprevword 18
#define z_copyregionaskill 19
#define z_deletechar 20
#define z_deletecharorlist 21
#define z_deleteword 22
#define z_digitargument 23
#define z_downcaseword 24
#define z_downhistory 25
#define z_downlineorhistory 26
#define z_endofbufferorhistory 27
#define z_endofhistory 28
#define z_endofline 29
#define z_endoflinehist 30
#define z_exchangepointandmark 31
#define z_executelastnamedcmd 32
#define z_executenamedcmd 33
#define z_expandhistory 34
#define z_expandorcomplete 35
#define z_expandword 36
#define z_forwardchar 37
#define z_forwardword 38
#define z_getline 39
#define z_gosmacstransposechars 40
#define z_historyincrementalsearchbackward 41
#define z_historyincrementalsearchforward 42
#define z_historysearchbackward 43
#define z_historysearchforward 44
#define z_infernexthistory 45
#define z_insertlastword 46
#define z_killbuffer 47
#define z_killline 48
#define z_killregion 49
#define z_killwholeline 50
#define z_listchoices 51
#define z_listexpand 52
#define z_magicspace 53
#define z_menucompleteword 54
#define z_menuexpandorcomplete 55
#define z_overwritemode 56
#define z_pushline 57
#define z_quotedinsert 58
#define z_quoteline 59
#define z_quoteregion 60
#define z_redisplay 61
#define z_reversemenucomplete 62
#define z_runhelp 63
#define z_selfinsert 64
#define z_selfinsertunmeta 65
#define z_sendbreak 66
#define z_sendstring 67
#define z_sequenceleadin 68
#define z_setmarkcommand 69
#define z_spellword 70
#define z_toggleliteralhistory 71
#define z_transposechars 72
#define z_transposewords 73
#define z_undefinedkey 74
#define z_undo 75
#define z_universalargument 76
#define z_upcaseword 77
#define z_uphistory 78
#define z_uplineorhistory 79
#define z_viaddeol 80
#define z_viaddnext 81
#define z_vicapslockpanic 82
#define z_vichange 83
#define z_vichangeeol 84
#define z_vichangewholeline 85
#define z_vicmdmode 86
#define z_videlete 87
#define z_vidigitorbeginningofline 88
#define z_vifetchhistory 89
#define z_vifindnextchar 90
#define z_vifindnextcharskip 91
#define z_vifindprevchar 92
#define z_vifindprevcharskip 93
#define z_vifirstnonblank 94
#define z_viforwardwordend 95
#define z_vigotocolumn 96
#define z_vihistorysearchbackward 97
#define z_vihistorysearchforward 98
#define z_viinsert 99
#define z_viinsertbol 100
#define z_vijoin 101
#define z_vimatchbracket 102
#define z_viopenlineabove 103
#define z_viopenlinebelow 104
#define z_vioperswapcases 105
#define z_viputafter 106
#define z_virepeatfind 107
#define z_virepeatsearch 108
#define z_vireplace 109
#define z_vireplacechars 110
#define z_virevrepeatfind 111
#define z_virevrepeatsearch 112
#define z_viswapcase 113
#define z_viundo 114
#define z_viyank 115
#define z_viyankeol 116
#define z_whichcommand 117
#define z_yank 118
#define z_yankpop 119
#define ZLECMDCOUNT 120

extern struct zlecmd zlecmds[];

