/*
 * $Id: hashtable.h,v 1.9 1995/10/30 07:46:36 coleman Exp coleman $
 *
 * hashtable.h - header file for hash table handling code
 *
 * This file is part of zsh, the Z shell.
 *
 * Copyright (c) 1992-1995 Paul Falstad
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * In no event shall Paul Falstad or the Zsh Development Group be liable
 * to any party for direct, indirect, special, incidental, or consequential
 * damages arising out of the use of this software and its documentation,
 * even if Paul Falstad and the Zsh Development Group have been advised of
 * the possibility of such damage.
 *
 * Paul Falstad and the Zsh Development Group specifically disclaim any
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose.  The software
 * provided hereunder is on an "as is" basis, and Paul Falstad and the
 * Zsh Development Group have no obligation to provide maintenance,
 * support, updates, enhancements, or modifications.
 *
 */

/* Nodes for reserved word hash table */

#ifdef GLOBALS
struct reswd reswds[] =
{
    {NULL, "-", 0, DASH},
    {NULL, "case", 0, CASE},
    {NULL, "command", 0, COMMAND},
    {NULL, "coproc", 0, COPROC},
    {NULL, "do", 0, DO},
    {NULL, "done", 0, DONE},
    {NULL, "elif", 0, ELIF},
    {NULL, "else", 0, ELSE},
    {NULL, "end", 0, ZEND},
    {NULL, "esac", 0, ESAC},
    {NULL, "exec", 0, EXEC},
    {NULL, "fi", 0, FI},
    {NULL, "for", 0, FOR},
    {NULL, "foreach", 0, FOREACH},
    {NULL, "function", 0, FUNC},
    {NULL, "if", 0, IF},
    {NULL, "nocorrect", 0, NOCORRECT},
    {NULL, "noglob", 0, NOGLOB},
    {NULL, "repeat", 0, REPEAT},
    {NULL, "select", 0, SELECT},
    {NULL, "then", 0, THEN},
    {NULL, "time", 0, TIME},
    {NULL, "until", 0, UNTIL},
    {NULL, "while", 0, WHILE},
    {NULL, NULL}
};
#else
extern struct reswd reswds[];
#endif


struct iparam {
    struct hashnode *next;
    char *nam;			/* hash data                             */
    int flags;			/* PM_* flags (defined in zsh.h)         */
    void *value;
    int (*func1) ();		/* set func                              */
    int (*func2) ();		/* get func                              */
    int ct;			/* output base or field width            */
    void *data;			/* used by getfns                        */
    char *env;			/* location in environment, if exported  */
    char *ename;		/* name of corresponding environment var */
    Param old;			/* old struct for use with local         */
    int level;			/* if (old != NULL), level of localness  */
};

#define IFN(X) ((int (*)())(X))

/* Nodes for special parameters for parameter hash table */

#ifdef GLOBALS
struct iparam special_params[] =
{
#define IPDEF1(A,B,C,D) {NULL,A,PM_INTEGER|PM_SPECIAL|D,NULL,IFN(C),IFN(B),10,NULL,NULL,NULL,NULL,0}
IPDEF1("#", poundgetfn, IFN(nullsetfn), PM_READONLY),
IPDEF1("ARGC", poundgetfn, IFN(nullsetfn), PM_READONLY),
IPDEF1("ERRNO", errnogetfn, IFN(nullsetfn), PM_READONLY),
IPDEF1("GID", gidgetfn, gidsetfn, 0),
IPDEF1("EGID", egidgetfn, egidsetfn, 0),
IPDEF1("HISTSIZE", histsizegetfn, histsizesetfn, 0),
IPDEF1("LITHISTSIZE", lithistsizegetfn, lithistsizesetfn, 0),
IPDEF1("RANDOM", randomgetfn, randomsetfn, 0),
IPDEF1("SECONDS", secondsgetfn, secondssetfn, 0),
IPDEF1("UID", uidgetfn, uidsetfn, 0),
IPDEF1("EUID", euidgetfn, euidsetfn, 0),

#define IPDEF2(A,B,C,D) {NULL,A,PM_SCALAR|PM_SPECIAL|D,NULL,IFN(C),IFN(B),0,NULL,NULL,NULL,NULL,0}
IPDEF2("USERNAME", usernamegetfn, usernamesetfn, 0),
IPDEF2("-", dashgetfn, IFN(nullsetfn), PM_READONLY),
IPDEF2("histchars", histcharsgetfn, histcharssetfn, 0),
IPDEF2("HOME", homegetfn, homesetfn, 0),
IPDEF2("TERM", termgetfn, termsetfn, 0),
IPDEF2("WORDCHARS", wordcharsgetfn, wordcharssetfn, 0),
IPDEF2("IFS", ifsgetfn, ifssetfn, 0),
IPDEF2("_", underscoregetfn, IFN(nullsetfn), PM_READONLY),
#ifdef LC_ALL
IPDEF2("LANG", strgetfn, langsetfn, 0),
#endif

#define IPDEF4(A,B) {NULL,A,PM_INTEGER|PM_READONLY|PM_SPECIAL,NULL,IFN(nullsetfn),IFN(intvargetfn),10,(void *)B,NULL,NULL,NULL,0}
IPDEF4("!", &lastpid),
IPDEF4("$", &mypid),
IPDEF4("?", &lastval),
IPDEF4("status", &lastval),
IPDEF4("LINENO", &lineno),
IPDEF4("PPID", &ppid),

#define IPDEF5(A,B) {NULL,A,PM_INTEGER|PM_SPECIAL,NULL,IFN(intvarsetfn),IFN(intvargetfn),10,(void *)B,NULL,NULL,NULL,0}
IPDEF5("BAUD", &baud),
IPDEF5("COLUMNS", &columns),
IPDEF5("DIRSTACKSIZE", &dirstacksize),
IPDEF5("KEYTIMEOUT", &keytimeout),
IPDEF5("LINES", &lines),
IPDEF5("LISTMAX", &listmax),
IPDEF5("LOGCHECK", &logcheck),
IPDEF5("MAILCHECK", &mailcheck),
IPDEF5("OPTIND", &zoptind),
IPDEF5("PERIOD", &period),
IPDEF5("REPORTTIME", &reporttime),
IPDEF5("SAVEHIST", &savehist),
IPDEF5("SHLVL", &shlvl),
IPDEF5("TMOUT", &tmout),

#define IPDEF6(A,B) {NULL,A,PM_SCALAR|PM_READONLY|PM_SPECIAL,NULL,IFN(nullsetfn),IFN(strvargetfn),0,(void *)B,NULL,NULL,NULL,0}
IPDEF6("LOGNAME", &login_name),
IPDEF6("PWD", &pwd),
IPDEF6("TTY", &ttystrname),

#define IPDEF7(A,B) {NULL,A,PM_SCALAR|PM_SPECIAL,NULL,IFN(strvarsetfn),IFN(strvargetfn),0,(void *)B,NULL,NULL,NULL,0}
IPDEF7("FCEDIT", &fceditparam),
IPDEF7("HOST", &hostvar),
IPDEF7("OLDPWD", &oldpwd),
IPDEF7("OPTARG", &zoptarg),
IPDEF7("MAIL", &mailfile),
IPDEF7("NULLCMD", &nullcmd),
IPDEF7("POSTEDIT", &postedit),
IPDEF7("prompt", &prompt),
IPDEF7("PROMPT", &prompt),
IPDEF7("PROMPT2", &prompt2),
IPDEF7("PROMPT3", &prompt3),
IPDEF7("PROMPT4", &prompt4),
IPDEF7("READNULLCMD", &readnullcmd),
IPDEF7("RPROMPT", &rprompt),
IPDEF7("PS1", &prompt),
IPDEF7("PS2", &prompt2),
IPDEF7("PS3", &prompt3),
IPDEF7("PS4", &prompt4),
IPDEF7("RPS1", &rprompt),
IPDEF7("SPROMPT", &sprompt),
IPDEF7("TIMEFMT", &timefmt),
IPDEF7("TMPPREFIX", &tmpprefix),
IPDEF7("WATCHFMT", &watchfmt),
IPDEF7("0", &argzero),

#define IPDEF8(A,B,C) {NULL,A,PM_SCALAR|PM_SPECIAL,NULL,IFN(colonarrsetfn),IFN(colonarrgetfn),0,(void *)B,NULL,C,NULL,0}
IPDEF8("CDPATH", &cdpath, "cdpath"),
IPDEF8("FIGNORE", &fignore, "fignore"),
IPDEF8("FPATH", &fpath, "fpath"),
IPDEF8("MAILPATH", &mailpath, "mailpath"),
IPDEF8("MANPATH", &manpath, "manpath"),
IPDEF8("WATCH", &watch, "watch"),
IPDEF8("PSVAR", &psvar, "psvar"),

{NULL, "PATH", PM_SPECIAL,NULL, IFN(colonpathsetfn), IFN(colonpathgetfn), 0, (void *) NULL, NULL, "path", NULL, 0},

#define IPDEF9(A,B,C,D) {NULL,A,PM_ARRAY|PM_SPECIAL|B,NULL,IFN(arrvarsetfn),IFN(arrvargetfn),0,(void *)C,NULL,D,NULL,0}
IPDEF9("cdpath", 0, &cdpath, "CDPATH"),
IPDEF9("fignore", 0, &fignore, "FIGNORE"),
IPDEF9("fpath", 0, &fpath, "FPATH"),
IPDEF9("mailpath", 0, &mailpath, "MAILPATH"),
IPDEF9("manpath", 0, &manpath, "MANPATH"),
IPDEF9("watch", 0, &watch, "WATCH"),
IPDEF9("psvar", 0, &psvar, "PSVAR"),
IPDEF9("signals", PM_READONLY, &sigptr, NULL),
IPDEF9("argv", 0, &pparams, NULL),
IPDEF9("*", 0, &pparams, NULL),
IPDEF9("@", 0, &pparams, NULL),

{NULL, "path", PM_ARRAY | PM_SPECIAL,NULL, IFN(pathsetfn), IFN(pathgetfn), 0, NULL, NULL, "PATH", NULL, 0},
{NULL, NULL}
};
#else
extern struct iparam special_params[];
#endif


/* Builtin function numbers; used by handler functions that handle more *
 * than one builtin.  Note that builtins such as compctl, that are not  *
 * overloaded, don't get a number.                                      */

#define BIN_TYPESET   0
#define BIN_BG        1
#define BIN_FG        2
#define BIN_JOBS      3
#define BIN_WAIT      4
#define BIN_DISOWN    5
#define BIN_BREAK     6
#define BIN_CONTINUE  7
#define BIN_EXIT      8
#define BIN_RETURN    9
#define BIN_CD       10
#define BIN_POPD     11
#define BIN_PUSHD    12
#define BIN_PRINT    13
#define BIN_EVAL     14
#define BIN_SCHED    15
#define BIN_FC       16
#define BIN_PUSHLINE 17
#define BIN_LOGOUT   18
#define BIN_BUILTIN  19
#define BIN_TEST     20
#define BIN_BRACKET  21
#define BIN_EXPORT   22
#define BIN_ECHO     23
#define BIN_DISABLE  24
#define BIN_ENABLE   25

/* These currently depend on being 0 and 1. */
#define BIN_SETOPT    0
#define BIN_UNSETOPT  1

#define NULLBINCMD ((int (*) _((char *,char **,char *,int))) 0)

/* Nodes for builtin function hash table */

#ifdef GLOBALS
struct builtin builtins[] =
{
    {NULL, "[", 0, bin_test, 0, -1, BIN_BRACKET, NULL, NULL},
    {NULL, ".", 0, bin_dot, 1, -1, 0, NULL, NULL},
    {NULL, ":", 0, bin_true, 0, -1, 0, NULL, NULL},
    {NULL, "alias", BINF_MAGICEQUALS, bin_alias, 0, -1, 0, "Lgmr", NULL},
    {NULL, "autoload", BINF_TYPEOPTS, bin_functions, 0, -1, 0, "t", "u"},
    {NULL, "bg", 0, bin_fg, 0, -1, BIN_BG, NULL, NULL},
    {NULL, "bindkey", 0, bin_bindkey, 0, -1, 0, "asvemdr", NULL},
    {NULL, "break", 0, bin_break, 0, 1, BIN_BREAK, NULL, NULL},
    {NULL, "builtin", 0, NULLBINCMD, 0, 0, BIN_BUILTIN, NULL, NULL},
    {NULL, "bye", 0, bin_break, 0, 1, BIN_EXIT, NULL, NULL},
    {NULL, "cd", 0, bin_cd, 0, 2, BIN_CD, NULL, NULL},
    {NULL, "chdir", 0, bin_cd, 0, 2, BIN_CD, NULL, NULL},
    {NULL, "compctl", 0, bin_compctl, 0, -1, 0, NULL, NULL},
    {NULL, "continue", 0, bin_break, 0, 1, BIN_CONTINUE, NULL, NULL},
    {NULL, "declare", BINF_TYPEOPTS | BINF_MAGICEQUALS, bin_typeset, 0, -1, 0, "LRZfilrtux", NULL},
    {NULL, "dirs", 0, bin_dirs, 0, -1, 0, "v", NULL},
    {NULL, "disable", 0, bin_enable, 0, -1, BIN_DISABLE, "afmr", NULL},
    {NULL, "disown", 0, bin_fg, 0, -1, BIN_DISOWN, NULL, NULL},
    {NULL, "echo", BINF_PRINTOPTS | BINF_ECHOPTS, bin_print, 0, -1, BIN_ECHO, "neE", "-"},
    {NULL, "echotc", 0, bin_echotc, 1, -1, 0, NULL, NULL},
    {NULL, "enable", 0, bin_enable, 0, -1, BIN_ENABLE, "afmr", NULL},
    {NULL, "eval", 0, bin_eval, 0, -1, BIN_EVAL, NULL, NULL},
    {NULL, "exit", 0, bin_break, 0, 1, BIN_EXIT, NULL, NULL},
    {NULL, "export", BINF_TYPEOPTS | BINF_MAGICEQUALS, bin_typeset, 0, -1, BIN_EXPORT, "LRZfilrtu", "x"},
    {NULL, "false", 0, bin_false, 0, -1, 0, NULL, NULL},
    {NULL, "fc", BINF_FCOPTS, bin_fc, 0, -1, BIN_FC, "nlreIRWAdDfEim", NULL},
    {NULL, "fg", 0, bin_fg, 0, -1, BIN_FG, NULL, NULL},
    {NULL, "functions", BINF_TYPEOPTS, bin_functions, 0, -1, 0, "mtu", NULL},
    {NULL, "getln", 0, bin_read, 0, -1, 0, "ecnAlE", "zr"},
    {NULL, "getopts", 0, bin_getopts, 2, -1, 0, NULL, NULL},
    {NULL, "hash", BINF_MAGICEQUALS, bin_hash, 0, -1, 0, "dfmr", NULL},

#ifdef ZSH_HASH_DEBUG
    {NULL, "hashinfo", 0, bin_hashinfo, 0, 0, 0, NULL, NULL},
#endif

    {NULL, "history", 0, bin_fc, 0, -1, BIN_FC, "nrdDfEim", "l"},
    {NULL, "integer", BINF_TYPEOPTS | BINF_MAGICEQUALS, bin_typeset, 0, -1, 0, "lrtux", "i"},
    {NULL, "jobs", 0, bin_fg, 0, -1, BIN_JOBS, "lpZrs", NULL},
    {NULL, "kill", 0, bin_kill, 0, -1, 0, NULL, NULL},
    {NULL, "let", 0, bin_let, 1, -1, 0, NULL, NULL},
    {NULL, "limit", 0, bin_limit, 0, -1, 0, "sh", NULL},
    {NULL, "local", BINF_TYPEOPTS | BINF_MAGICEQUALS, bin_typeset, 0, -1, 0, "LRZilrtu", NULL},
    {NULL, "log", 0, bin_log, 0, 0, 0, NULL, NULL},
    {NULL, "logout", 0, bin_break, 0, 1, BIN_LOGOUT, NULL, NULL},

#if defined(ZSH_MEM) & defined(ZSH_MEM_DEBUG)
    {NULL, "mem", 0, bin_mem, 0, 0, 0, "v", NULL},
#endif

    {NULL, "popd", 0, bin_cd, 0, 2, BIN_POPD, NULL, NULL},
    {NULL, "print", BINF_PRINTOPTS, bin_print, 0, -1, BIN_PRINT, "RDPnrslzNu0123456789pioOc-", NULL},
    {NULL, "pushd", 0, bin_cd, 0, 2, BIN_PUSHD, NULL, NULL},
    {NULL, "pushln", BINF_PRINTOPTS, bin_print, 0, -1, BIN_PRINT, NULL, "-nz"},
    {NULL, "pwd", 0, bin_pwd, 0, 0, 0, NULL, NULL},
    {NULL, "r", BINF_R, bin_fc, 0, -1, BIN_FC, "nrl", NULL},
    {NULL, "read", 0, bin_read, 0, -1, 0, "rzu0123456789pkqecnAlE", NULL},
    {NULL, "readonly", BINF_TYPEOPTS | BINF_MAGICEQUALS, bin_typeset, 0, -1, 0, "LRZfiltux", "r"},
    {NULL, "rehash", 0, bin_hash, 0, 0, 0, "df", "r"},
    {NULL, "return", 0, bin_break, 0, 1, BIN_RETURN, NULL, NULL},
    {NULL, "sched", 0, bin_sched, 0, -1, 0, NULL, NULL},
    {NULL, "set", BINF_SETOPTS | BINF_PLUSOPTS, bin_set, 0, -1, 0, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZaefghjklmnopsuvwxy", NULL},
    {NULL, "setopt", BINF_PLUSOPTS, bin_setopt, 0, -1, BIN_SETOPT, "0123456789BCDEFGHIJKLMNOPQRSTUVWXYZaefghjklmnopsuvwxy", NULL},
    {NULL, "shift", 0, bin_shift, 0, -1, 0, NULL, NULL},
    {NULL, "source", 0, bin_dot, 1, -1, 0, NULL, NULL},
    {NULL, "suspend", 0, bin_suspend, 0, 0, 0, "f", NULL},
    {NULL, "test", 0, bin_test, 0, -1, BIN_TEST, NULL, NULL},
    {NULL, "ttyctl", 0, bin_ttyctl, 0, 0, 0, "fu", NULL},
    {NULL, "times", 0, bin_times, 0, 0, 0, NULL, NULL},
    {NULL, "trap", 0, bin_trap, 0, -1, 0, NULL, NULL},
    {NULL, "true", 0, bin_true, 0, -1, 0, NULL, NULL},
    {NULL, "type", 0, bin_whence, 0, -1, 0, "amp", "v"},
    {NULL, "typeset", BINF_TYPEOPTS | BINF_MAGICEQUALS, bin_typeset, 0, -1, 0, "LRZfilrtuxm", NULL},
    {NULL, "ulimit", 0, bin_ulimit, 0, 1, 0, "HSacdflmnopstv", NULL},
    {NULL, "umask", 0, bin_umask, 0, 1, 0, NULL, NULL},
    {NULL, "unalias", 0, bin_unhash, 1, -1, 0, "m", "a"},
    {NULL, "unfunction", 0, bin_unhash, 1, -1, 0, "m", "f"},
    {NULL, "unhash", 0, bin_unhash, 1, -1, 0, "adfm", NULL},
    {NULL, "unlimit", 0, bin_unlimit, 0, -1, 0, "h", NULL},
    {NULL, "unset", 0, bin_unset, 1, -1, 0, "m", NULL},
    {NULL, "unsetopt", BINF_PLUSOPTS, bin_setopt, 0, -1, BIN_UNSETOPT, "0123456789BCDEFGHIJKLMNOPQRSTUWXYZabefghjklmnopsuvwxy", NULL},
    {NULL, "vared", 0, bin_vared, 1, 6, 0, NULL, NULL},
    {NULL, "wait", 0, bin_fg, 0, -1, BIN_WAIT, NULL, NULL},
    {NULL, "whence", 0, bin_whence, 0, -1, 0, "acmpv", NULL},
    {NULL, "which", 0, bin_whence, 0, -1, 0, "amp", "c"},
    {NULL, NULL}
};
#else
extern struct builtin builtins[];
#endif

