.\"
.TH ZSHALL 1 "March 2, 1995" "zsh version 2.7"
.SH NAME
zshall \- the Z shell meta-man page
.SH SYNOPSIS
.\" \fBzsh\fP [ \(+-\fIoptions\fP ] [ \(+-\fBo\fP \fIoption\fP ] ...  [ \-\fBc\fP \fIstring\fP ] [ \fIarg\fP ... ]

.SH "DESCRIPTION"
Zsh is a UNIX command interpreter (shell) usable as an interactive
login shell and as a shell script command processor.  Of the standard shells,
zsh most closely resembles \fIksh\fR but includes many enhancements.  Zsh
has comand line editing, builtin spelling correction, programmable
command completion, shell functions (with autoloading), a history
mechanism, and a host of other features.
.sp
This manual page includes all the separate manual pages in the
following order:  zshmisc (general information), zshexpn (command and
parameter expansion), zshbuiltins (built-in functions), zshcompctl
(completion control via the \fBcompctl\fP built-in), zshparam
(shell parameters), zshzle (command line editing) and zshoptions
(shell options).
.so man-dir/zshmisc.x
.so man-dir/zshexpn.x
.so man-dir/zshbuiltins.x
.so man-dir/zshcompctl.x
.so man-dir/zshparam.x
.so man-dir/zshzle.x
.so man-dir/zshoptions.x
.SH "INVOCATION OPTIONS"
If the \-\fBs\fP flag is not present and an argument is given,
the first argument is taken to be the pathname of a script to
execute.  The remaining arguments are assigned to the positional
parameters.  The following flags are interpreted by the shell
when invoked:
.TP
.PD 0
\-\fBc\fP \fIstring\fP
Read commands from \fIstring\fP.
.TP
\-\fBi\fP
Force shell to be interactive.
.TP
\-\fBs\fP
Read command from the standard input.
.sp
.SH STARTUP/SHUTDOWN FILES
Commands are first read from /etc/zshenv.
If the \-\fBf\fP flag is present or if the \fBNO_RCS\fP option is set
within /etc/zshenv, all other
initialization files are skipped.
Otherwise, commands are read
from $ZDOTDIR/.zshenv.
(If \fBZDOTDIR\fP is unset, \fBHOME\fP is used instead).
If the first character of argument zero passed to the shell
is \-, or if the \-\fBl\fP flag is present, then the shell is
assumed to be a login shell, and commands
are read from /etc/zprofile and then $ZDOTDIR/.zprofile.
Then, if the shell is interactive,
commands are read from /etc/zshrc and then $ZDOTDIR/.zshrc.
Finally, if the shell is a login shell, /etc/zlogin and $ZDOTDIR/.zlogin
are read.
.sp
.SH FILES
$ZDOTDIR/.zshenv
.br
$ZDOTDIR/.zprofile
.br
$ZDOTDIR/.zshrc
.br
$ZDOTDIR/.zlogin
.br
$ZDOTDIR/.zlogout
.br
${TMPPREFIX}*   (default is /tmp/zsh*)
.br
/etc/zshenv
.br
/etc/zprofile
.br
/etc/zshrc
.br
/etc/zlogin
.br
/etc/zlogout
.SH AUTHOR
.sp
Zsh was originally written by Paul Falstad <pf@z-code.com>.
.br
Programmable completion was implemented by Sven
Wischnowsky <oberon@cs.tu-berlin.de> and Peter Stephenson
<P.Stephenson@swansea.ac.uk>.  Zsh is currently maintained by the
members of the zsh workers mailing list zsh-workers@math.gatech.edu and
coordinated by Richard Coleman <zsh@math.gatech.edu>.
.sp
.SH SEE ALSO
sh(1),
csh(1),
tcsh(1),
rc(1),
bash(1),
ksh(1),
