/*
 * ipcp.h - IP Control Protocol definitions.
 *
 * Copyright (c) 1989 Carnegie Mellon University.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Carnegie Mellon University.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/*
 * Options.
 */
#define CI_ADDRS	1	/* IP Addresses */
#define CI_COMPRESSTYPE	2	/* Compression Type */

#define MAX_STATES 16		/* from slcompress.h */

#define IPCP_VJMODE_OLD 1		/* "old" mode (option # = 0x0037) */
#define IPCP_VJMODE_CURRENT 2		/* "current"mode (option # = 0x002d) */
#define IPCP_VJMODE_DRAFT 3		/* "draft" mode (option # = 0x002d, */
                                        /*  maxslot and slot number */
				        /*  compression from Aug. 1991 */
					/*  ipcp draft RFC) */

#define IPCP_VJ_COMP 0x002d	/* current value for VJ compression option*/
#define IPCP_VJ_COMP_OLD 0x0037	/* "old" (i.e, broken) value for VJ */
				/* compression option*/ 

typedef struct ipcp_options {
    int neg_addrs : 1;		/* Negotiate IP Addresses? */
    u_long ouraddr, hisaddr;	/* Addresses in NETWORK BYTE ORDER */
    int neg_vj : 1;		/* Van Jacobson Compression? */
    u_char maxslotindex, cflag;	/* fields for Aug. 1991 Draft VJ */
				/* compression negotiation */
} ipcp_options;

extern fsm ipcp_fsm[];
extern ipcp_options ipcp_wantoptions[];
extern ipcp_options ipcp_gotoptions[];
extern ipcp_options ipcp_allowoptions[];
extern ipcp_options ipcp_hisoptions[];

void ipcp_init();
void ipcp_vj_setmode();
void ipcp_activeopen();
void ipcp_passiveopen();
void ipcp_close();
void ipcp_lowerup();
void ipcp_lowerdown();
void ipcp_input();
void ipcp_protrej();
