/*
 * ppp.h - PPP global declarations.
 *
 * Copyright (c) 1989 Carnegie Mellon University.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Carnegie Mellon University.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/*
 * TODO:
 */

#define NPPP	1		/* One PPP interface supported (per process) */
#ifdef	STREAMS
#include "ppp_str.h"
#endif
extern int debug;		/* Debug flag */
extern int fsm_debug;		/* FSM debug flag */
extern int lcp_debug;		/* LCP debug flag */
extern int ipcp_debug;		/* IPCP debug flag */
extern int upap_debug;		/* UPAP debug flag */
extern char ifname[];		/* Interface name */
extern int fd;			/* Device file descriptor */
extern int s;			/* Socket file descriptor */

void quit();			/* Cleanup and exit */
void timeout();			/* Look-alike of kernel's timeout() */
void untimeout();		/* Look-alike of kernel's untimeout() */
void output();			/* Output a PPP packet */
void demuxprotrej();		/* Demultiplex a Protocol-Reject */
u_char login();			/* Login user */
void logout();			/* Logout user */

extern int errno;


/*
 * Inline versions of get/put char/short/long.
 * Pointer is advanced; we assume that both arguments
 * are lvalues and will already be in registers.
 * cp MUST be u_char *.
 */
#define GETCHAR(c, cp) { \
	(c) = *(cp)++; \
}
#define PUTCHAR(c, cp) { \
	*(cp)++ = (c); \
}


#define GETSHORT(s, cp) { \
	(s) = *(cp)++ << 8; \
	(s) |= *(cp)++; \
}
#define PUTSHORT(s, cp) { \
	*(cp)++ = (s) >> 8; \
	*(cp)++ = (s); \
}

#define GETLONG(l, cp) { \
	(l) = *(cp)++ << 8; \
	(l) |= *(cp)++; (l) <<= 8; \
	(l) |= *(cp)++; (l) <<= 8; \
	(l) |= *(cp)++; \
}
#define PUTLONG(l, cp) { \
	*(cp)++ = (l) >> 24; \
	*(cp)++ = (l) >> 16; \
	*(cp)++ = (l) >> 8; \
	*(cp)++ = (l); \
}

#define INCPTR(n, cp)	((cp) += (n))
#define DECPTR(n, cp)	((cp) -= (n))


/*
 * Data Link Layer header = Address, Control, Protocol.
 */
#define ALLSTATIONS	0xff	/* All-Stations Address */
#define UI		0x03	/* Unnumbered Information */
#define LCP		0xc021	/* Link Control Protocol */
#define IPCP		0x8021	/* IP Control Protocol */
#define UPAP		0xc023	/* User/Password Authentication Protocol */
#define IP_VJ_COMP	0x002d	/* VJ TCP compressed IP packet */
#define DLLHEADERLEN	(sizeof (u_char) + sizeof (u_char) + sizeof (u_short))
#define MTU		1500	/* Default MTU */


/*
 * System dependent definitions for user-level 4.3BSD UNIX implementation.
 */
#define PACKET		u_char
#define PACKET_DATA(p)	(p)
#define PACKET_FREE(p)	(free((p) - DLLHEADERLEN))
#define PACKET_ALLOC(s)	((u_char *) malloc((s)+DLLHEADERLEN) + DLLHEADERLEN)

#define DEMUXPROTREJ(u, p) demuxprotrej(u, p)

#define TIMEOUT(r, f, t) timeout((r), (f), (t))
#define UNTIMEOUT(r, f)	untimeout((r), (f))

#define BCOPY(s, d, l)	bcopy(s, d, l)
#define EXIT(u)		quit()

#define GETUSERPASSWD(u)
#define LOGIN(n, u, ul, p, pl, m, ml) login(u, ul, p, pl, m, ml);
#define LOGOUT(n)	logout()

#define PRINTMSG(m, l)	{ m[l] = '\0'; printf("%s\n", m); }


/*
 * OUTPUT - Output a PACKET.
 */
#define OUTPUT(u, p, l, t) { \
    p -= DLLHEADERLEN; \
    PUTCHAR(ALLSTATIONS, p); \
    PUTCHAR(UI, p); \
    PUTSHORT(t, p); \
    output(u, p - DLLHEADERLEN, l + DLLHEADERLEN); }

/*
 * SIFUP - Config the interface up.
 */
#define SIFUP(u)	{ \
    struct ifreq ifr; \
    strncpy(ifr.ifr_name, ifname, sizeof (ifr.ifr_name)); \
    if (ioctl(s, SIOCGIFFLAGS, (caddr_t) &ifr) < 0) { \
	perror("ppp: ioctl (SIOCGIFFLAGS)"); \
	quit(); \
    } \
    ifr.ifr_flags |= IFF_UP; \
    if (ioctl(s, SIOCSIFFLAGS, (caddr_t) &ifr) < 0) { \
	perror("ppp: ioctl(SIOCSIFFLAGS)"); \
	quit(); \
    } }

/*
 * SIFDOWN - Config the interface down.
 */
#define SIFDOWN(u)	{ \
    struct ifreq ifr; \
    strncpy(ifr.ifr_name, ifname, sizeof (ifr.ifr_name)); \
    if (ioctl(s, SIOCGIFFLAGS, (caddr_t) &ifr) < 0) { \
	perror("ppp: ioctl (SIOCGIFFLAGS)"); \
	quit(); \
    } \
    ifr.ifr_flags &= ~IFF_UP; \
    if (ioctl(s, SIOCSIFFLAGS, (caddr_t) &ifr) < 0) { \
	perror("ppp: ioctl(SIOCSIFFLAGS)"); \
	quit(); \
    } }

/*
 * SIFMTU - Config the interface MTU.
 */
#define SIFMTU(u, m)	{ \
    struct ifreq ifr; \
    strncpy(ifr.ifr_name, ifname, sizeof (ifr.ifr_name)); \
    ifr.ifr_mtu = m; \
    if (ioctl(s, SIOCSIFMTU, (caddr_t) &ifr) < 0) { \
	perror("ppp: ioctl(SIOCSIFMTU)"); \
	quit(); \
    } }

/*
 * SIFASYNCMAP - Config the interface async map.
 */
#ifdef	STREAMS
#define	SIFVJCOMP(u, a) 	{ \
    char x = a;			\
	if(debug > 2) fprintf(stderr,"ppp:SIFVJCOMP unit %d to value %d\n",u,x); \
	if(ioctl(fd, SIOCSIFVJCOMP, (caddr_t) &x) < 0) { \
		perror("ppp: ioctl(SIOCSIFVJCOMP)"); \
		quit(); \
	} \
}
#define	SIFASYNCMAP(u, a)	{ \
     u_long x = a; \
     if(ioctl(fd, SIOCSIFASYNCMAP, (caddr_t) &x) < 0) { \
	perror("ppp: ioctl(SIOCSIFASYNCMAP)"); \
	quit(); \
    } }
#else
#define SIFASYNCMAP(u, a)	{ \
    struct ifreq ifr; \
    strncpy(ifr.ifr_name, ifname, sizeof (ifr.ifr_name)); \
    ifr.ifr_asyncmap = a; \
    if (ioctl(s, SIOCSIFASYNCMAP, (caddr_t) &ifr) < 0) { \
	perror("ppp: ioctl(SIOCSIFASYNCMAP)"); \
	quit(); \
    } }
#endif

/*
 * SIFPCOMPRESSION - Config the interface for protocol compression.
 */
#ifdef	STREAMS
#define SIFPCOMPRESSION(u)	{ \
    char c = 1; \
    if(ioctl(fd, SIOCSIFCOMPPROT, &c) < 0) { \
	perror("ppp: ioctl(SIOCSIFCOMPPROT)"); \
	quit(); \
    }}
#else
#define SIFPCOMPRESSION(u)	{ \
    struct ifreq ifr; \
    strncpy(ifr.ifr_name, ifname, sizeof (ifr.ifr_name)); \
    if (ioctl(s, SIOCGIFFLAGS, (caddr_t) &ifr) < 0) { \
	perror("ppp: ioctl (SIOCGIFFLAGS)"); \
	quit(); \
    } \
    ifr.ifr_flags |= IFF_COMPPROT; \
    if (ioctl(s, SIOCSIFFLAGS, (caddr_t) &ifr) < 0) { \
	perror("ppp: ioctl(SIOCSIFFLAGS)"); \
	quit(); \
    } }
#endif

/*
 * CIFPCOMPRESSION - Config the interface for no protocol compression.
 */
#ifdef	STREAMS
#define CIFPCOMPRESSION(u)	{ \
    char c = 0; \
    if(ioctl(fd, SIOCSIFCOMPPROT, &c) < 0) { \
	perror("ppp: ioctl(SIOCSIFCOMPPROT)"); \
	quit(); \
    }}
#else
#define CIFPCOMPRESSION(u)	{ \
    struct ifreq ifr; \
    strncpy(ifr.ifr_name, ifname, sizeof (ifr.ifr_name)); \
    if (ioctl(s, SIOCGIFFLAGS, (caddr_t) &ifr) < 0) { \
	perror("ppp: ioctl(SIOCGIFFLAGS)"); \
	quit(); \
    } \
    ifr.ifr_flags &= ~IFF_COMPPROT; \
    if (ioctl(s, SIOCSIFFLAGS, (caddr_t) &ifr) < 0) { \
	perror("ppp: ioctl(SIOCSIFFLAGS)"); \
	quit(); \
    } }
#endif
/*
 * SIFACCOMPRESSION - Config the interface for address/control compression.
 */
#ifdef	STREAMS
#define SIFACCOMPRESSION(u)	{ \
   char c = 1; \
    if(ioctl(fd, SIOCSIFCOMPAC, &c) < 0) { \
	perror("ppp: ioctl(SIOCSIFCOMPAC)"); \
	quit(); \
    }}
#else
#define SIFACCOMPRESSION(u)	{ \
    struct ifreq ifr; \
    strncpy(ifr.ifr_name, ifname, sizeof (ifr.ifr_name)); \
    if (ioctl(s, SIOCGIFFLAGS, (caddr_t) &ifr) < 0) { \
	perror("ppp: ioctl (SIOCGIFFLAGS)"); \
	quit(); \
    } \
    ifr.ifr_flags |= IFF_COMPAC; \
    if (ioctl(s, SIOCSIFFLAGS, (caddr_t) &ifr) < 0) { \
	perror("ppp: ioctl(SIOCSIFFLAGS)"); \
	quit(); \
    } }
#endif
/*
 * CIFACCOMPRESSION - Config the interface for no address/control compression.
 */
#ifdef	STREAMS
#define CIFACCOMPRESSION(u)	{ \
    char c = 0; \
    if(ioctl(fd, SIOCSIFCOMPAC, &c) < 0) { \
	perror("ppp: ioctl(SIOCSIFCOMPAC)"); \
	quit(); \
    }}
#else
#define CIFACCOMPRESSION(u)	{ \
    struct ifreq ifr; \
    strncpy(ifr.ifr_name, ifname, sizeof (ifr.ifr_name)); \
    if (ioctl(s, SIOCGIFFLAGS, (caddr_t) &ifr) < 0) { \
	perror("ppp: ioctl (SIOCGIFFLAGS)"); \
	quit(); \
    } \
    ifr.ifr_flags &= ~IFF_COMPAC; \
    if (ioctl(s, SIOCSIFFLAGS, (caddr_t) &ifr) < 0) { \
	perror("ppp: ioctl(SIOCSIFFLAGS)"); \
	quit(); \
    } }
#endif
/*
 * SIFADDR - Config the interface IP addresses.
 */
#define SIFADDR(u, o, h)	{ \
    struct ifreq ifr; \
    strncpy(ifr.ifr_name, ifname, sizeof (ifr.ifr_name)); \
    bzero((char *) &ifr.ifr_addr, sizeof(ifr.ifr_addr));  \
    ifr.ifr_addr.sa_family = AF_INET; \
    ((struct sockaddr_in *) &ifr.ifr_addr)->sin_addr.s_addr = o; \
    if (ioctl(s, SIOCSIFADDR, (caddr_t) &ifr) < 0) { \
	perror("ppp: ioctl(SIOCSIFADDR)"); \
    } \
    ((struct sockaddr_in *) &ifr.ifr_dstaddr)->sin_addr.s_addr = h; \
    if (ioctl(s, SIOCSIFDSTADDR, (caddr_t) &ifr) < 0) { \
	perror("ppp: ioctl(SIOCSIFDSTADDR)"); \
	quit(); \
    } }

/*
 * CIFADDR - Clear the interface IP addresses.
 */
#define CIFADDR(u, o, h)	{ \
    struct rtentry rt; \
    bzero((char *) &rt.rt_dst, sizeof(rt.rt_dst));  \
    rt.rt_dst.sa_family = AF_INET; \
    ((struct sockaddr_in *) &rt.rt_dst)->sin_addr.s_addr = h; \
    bzero((char *) &rt.rt_gateway, sizeof(rt.rt_gateway));  \
    rt.rt_gateway.sa_family = AF_INET; \
    ((struct sockaddr_in *) &rt.rt_gateway)->sin_addr.s_addr = o; \
    rt.rt_flags |= RTF_HOST; \
    if (ioctl(s, SIOCDELRT, (caddr_t) &rt) < 0) { \
	perror("ppp: ioctl(SIOCDELRT)"); \
	quit(); \
    } }


#ifdef DEBUGFSM
extern fsm_debug;
#define FSMDEBUG(x)	if (fsm_debug) fprintf x;
#else
#define FSMDEBUG(x)
#endif

#ifdef DEBUGLCP
extern lcp_debug;
#define LCPDEBUG(x)	if (lcp_debug) fprintf x;
#else
#define LCPDEBUG(x)
#endif

#ifdef DEBUGIPCP
extern ipcp_debug;
#define IPCPDEBUG(x)	if (ipcp_debug) fprintf x;
#else
#define IPCPDEBUG(x)
#endif

#ifdef DEBUGUPAP
extern upap_debug;
#define UPAPDEBUG(x)	if (upap_debug) fprintf x;
#else
#define UPAPDEBUG(x)
#endif
