/*

Copyright 1993, 1994, Cornell University

Cornell hereby grants permission to use, copy, modify, and distribute this program for any purpose 
and without fee, provided that these copyright and permission notices appear on all copies and 
supporting documentation, the name of Cornell not be used in advertising or publicity pertaining 
to distribution of the program without specific prior permission, notice be given in supporting 
documentation that copying and distribution is by permission of Cornell.  CORNELL MAKES NO 
REPRESENTATIONS OR WARRANTEES, EXPRESS OR IMPLIED.  By way of example, but not limitation, 
CORNELL MAKES NO REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR 
PURPOSE OR THAT THE USE OF THIS SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, 
TRADEMARKS, OR OTHER RIGHTS.  Cornell shall not be held liable for any liability with respect to 
any claim by the user or any other party arising from use of the program.

This material is partially based on work sponsored by the National Science Foundation under Cooperative 
Agreement No. NCR-9318337.  The government has certain rights in this material.

*/



#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "reflect.h"
#include "refmon.h"
#include "globals.h"

#ifdef SOLARIS
#include <sys/sockio.h>
#include "solaris.h"
#endif


unsigned short clincnt = 1;

FILE  *conf_fd;
short scan_str();

load_config(fname)
   char *fname;
{
   int            icnt;
   char           code[30],line[101],buf[100],*configfile = CONFIGFILE;
   int            cnt,hb,mh,ml,lb,id;
   char           *tmp;
   short          status;

   if (fname != NULL) 
      configfile = fname; 

   printf("\nVersion: %s\n",VERSION_STRING);

   if ((conf_fd = fopen (configfile, "r")) == NULL)
      return;

   tmp = conf_buf;

   while (!feof (conf_fd)) 
   {
      if ((code[0] = fgetc(conf_fd)) <= ' ') 
      {
         if (code[0] == '\n')
            ++clincnt;
         continue;
      }

      if ((icnt = fscanf (conf_fd, "%s", code + 1)) == EOF)
         break;

      if (icnt != 1)
      {
         printf("Unable to parse configuration code line %d\n",clincnt);
         exit(-1);
      }

      if (code[0] == ';')
      {
         fgets (line, 100, conf_fd);
         ++clincnt;
         continue;
      }

      printf("\n%d: ",clincnt);

      printf("%s ",code);


      if (strcasecmp (code, "DEBUG") == 0) 
      {
         strcpy(tmp,"debug\n ");
         tmp += strlen(tmp);
         debug = 1;
         continue;
      }

      if (strcasecmp(code, "NV-UC-PORT") == 0) 
      {
         strcpy(tmp,"nv-uc-port ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, " %i", &nv_ucast_port)) != 1)
         {
            printf ("NV-UC-PORT paramater count error\n");
            exit(-1);
         }

         printf("%d ",nv_ucast_port);
         sprintf(buf,"%d ",nv_ucast_port);

         sprintf(tmp,"%d\n",nv_ucast_port);
         tmp += strlen(tmp);

         continue;
      }


      if (strcasecmp(code, "NV-MC-PORT") == 0)
      {
#ifdef MULTI
         strcpy(tmp,"nv-mc-port ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, " %i", &nv_mcast_port)) != 1)
         {
            printf ("NV-PORT paramater count error\n");
            exit(-1);
         }

         printf("%d ",nv_mcast_port);
         sprintf(buf,"%d ",nv_mcast_port);

         sprintf(tmp,"%d\n",nv_mcast_port);
         tmp += strlen(tmp);

         nv_out_mcast.sin_port = htons(nv_mcast_port);
         nv_in_mcast.sin_port = htons(nv_mcast_port);
#else
         printf ("This copy of the reflector was not built with Multicast support\n");
         exit(-1);
#endif
         continue;
      }


      if (strcasecmp(code, "NV-MC-IN") == 0)
      {
#ifdef MULTI
         strcpy(tmp,"nv-mc-in ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, "%i.%i.%i.%i",&hb,&mh,&ml,&lb)) != 4)
         {
            printf ("NV-MC-IN paramater count error\n", cnt);
            exit(-1);
         }
         printf("%d.%d.%d.%d ",hb,mh,ml,lb);
         sprintf(buf,"%d.%d.%d.%d ",hb,mh,ml,lb);

         sprintf(tmp,"%d.%d.%d.%d\n",hb,mh,ml,lb);
         tmp += strlen(tmp);

         if ((nv_in_mcast.sin_addr.s_addr = inet_addr(buf)) == -1)
         {
            printf("inet_addr: bad NV-MC-IN multicast address\n");
            exit(-1);
         }
         nv_in_mcast.sin_family = AF_INET;
#else
         printf ("This copy of the reflector was not built with Multicast support\n");
         exit(-1);
#endif
         continue;
      }

      if (strcasecmp(code, "NV-MC-OUT") == 0)
      {
#ifdef MULTI
         strcpy(tmp,"nv-mc-out ");
         tmp += strlen(tmp);
         if ((cnt = fscanf(conf_fd, "%i %i.%i.%i.%i",&nv_ttl,&hb,&mh,&ml,&lb)) != 5)
         {
            printf ("NV-MC-OUT paramater count error\n");
            exit(-1);
         }
         printf("%d %d.%d.%d.%d ",nv_ttl,hb,mh,ml,lb);
         sprintf(buf,"%d.%d.%d.%d ",hb,mh,ml,lb);

         sprintf(tmp,"%d.%d.%d.%d\n",hb,mh,ml,lb);
         tmp += strlen(tmp);

         if ((nv_out_mcast.sin_addr.s_addr = inet_addr(buf)) == -1)
         {
            printf("inet_addr: bad NV-MC-OUT multicast address\n");
            exit(-1);
         }
         nv_out_mcast.sin_family = AF_INET;
#else
         printf ("This copy of the reflector was not built with Multicast support\n");
         exit(-1);
#endif
         continue;
      }

      if (strcasecmp(code, "MC-OUT") == 0) 
      {
#ifdef MULTI
         strcpy(tmp,"mc-out ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, "%i %i.%i.%i.%i",&rf_ttl,&hb,&mh,&ml,&lb)) != 5)
         {
            printf ("MC-OUT-out paramater count error\n");
            exit(-1);
         }
         printf("%d %d.%d.%d.%d ",rf_ttl,hb,mh,ml,lb);
         sprintf(buf,"%d.%d.%d.%d ",hb,mh,ml,lb);

         sprintf(tmp,"%d.%d.%d.%d\n",hb,mh,ml,lb);
         tmp += strlen(tmp);

         if ((rfout_mcast.sin_addr.s_addr = inet_addr(buf)) == -1)
         {
            printf("inet_addr: bad MC-OUT multicast address\n");
            exit(-1);
         }
         rfout_mcast.sin_family = AF_INET;
         rfout_mcast.sin_port = htons(RF_PORT);
#else
         printf ("This copy of the reflector was not built with Multicast support\n");
         exit(-1);
#endif
         continue;
      }

      if (strcasecmp(code, "MC-IN") == 0) 
      {
#ifdef MULTI
         strcpy(tmp,"mc-in ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, "%i.%i.%i.%i",&hb,&mh,&ml,&lb)) != 4)
         {
            printf ("MC-IN paramater count error\n", cnt);
            exit(-1);
         }
         printf("%d.%d.%d.%d ",hb,mh,ml,lb);
         sprintf(buf,"%d.%d.%d.%d ",hb,mh,ml,lb);

         sprintf(tmp,"%d.%d.%d.%d\n",hb,mh,ml,lb);
         tmp += strlen(tmp);

         if ((rfin_mcast.sin_addr.s_addr = inet_addr(buf)) == -1)
         {
            printf("inet_addr: bad MC-IN multicast address\n");
            exit(-1);
         }
         rfin_mcast.sin_family = AF_INET;
         rfin_mcast.sin_port = htons(RF_PORT);
#else
         printf ("This copy of the reflector was not built with Multicast support\n");
         exit(-1);
#endif
         continue;
      }

      if (strcasecmp(code, "MC-GROUP") == 0) 
      {
#ifdef MULTI
         strcpy(tmp,"mc-group ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, "%i %i.%i.%i.%i",&inout_ttl,&hb,&mh,&ml,&lb)) != 5)
         {
            printf ("MC-GROUP paramater count error\n");
            exit(-1);
         }
         printf("%d %d.%d.%d.%d ",inout_ttl,hb,mh,ml,lb);
         sprintf(buf,"%d.%d.%d.%d ",hb,mh,ml,lb);

         sprintf(tmp,"%d.%d.%d.%d\n",hb,mh,ml,lb);
         tmp += strlen(tmp);

         if ((inout_mcast.sin_addr.s_addr = inet_addr(buf)) == -1)
         {
            printf("inet_addr: bad MC-GROUP multicast address\n");
            exit(-1);
         }
         inout_mcast.sin_family = AF_INET;
         inout_mcast.sin_port = htons(RF_PORT);
#else
         printf ("This copy of the reflector was not built with Multicast support\n");
         exit(-1);
#endif
         continue;
      }

      if (strcasecmp(code, "MAX-PARTICIPANTS") == 0) 
      {
         strcpy(tmp,"max-participants ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, "%i",&maxallowed)) != 1)
         {
            printf ("MAX-PARTICIPANTS paramater count error\n");
            exit(-1);
         }
         printf("%d ",maxallowed);
         sprintf(buf,"%d ",maxallowed);

         sprintf(tmp,"%d",maxallowed);
         tmp += strlen(tmp);

         if (maxallowed > MAXCLIENT)
         {
            printf("Maximum number of clients allowed is %d\n",MAXCLIENT);
            maxallowed = MAXCLIENT;
         }

         status = scan_str(mp_buf,MSGBUF);

         if (status == -1)
         {
            printf ("max-participants message string does not end with // \n");
            exit(-1);
         }

         if (status == -2)
         {
            printf ("max-participants message length is greater then %d characters \n",MSGBUF);
            exit(-1);
         }

         sprintf(tmp,"%s\n",mp_buf);
         tmp += strlen(tmp);
         continue;

      }

      if (strcasecmp(code, "MAX-SENDERS") == 0) 
      {
         strcpy(tmp,"max-senders ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, "%i",&maxsenders)) != 1)
         {
            printf ("MAX-SENDERS paramater count error\n");
            exit(-1);
         }
         printf("%d ",maxsenders);
         sprintf(buf,"%d ",maxsenders);

         sprintf(tmp,"%d",maxsenders);
         tmp += strlen(tmp);

         if (maxsenders > MAXCLIENT)
         {
            printf("Maximum number of clients allowed is %d\n",MAXCLIENT);
	    exit(-1);
         }

         status = scan_str(ms_buf,MSGBUF);

         if (status == -1)
         {
            printf ("max-senders message string does not end with // \n");
            exit(-1);
         }

         if (status == -2)
         {
            printf ("max-senders message length is greater then %d characters \n",MSGBUF);
            exit(-1);
         }

         sprintf(tmp,"%s\n",ms_buf);
         tmp += strlen(tmp);
         continue;
      }

      if (strcasecmp(code, "MAX-LURKERS") == 0) 
      {
         strcpy(tmp,"max-lurkers ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, "%i",&maxlurkers)) != 1)
         {
            printf ("MAX-LURKERS paramater count error\n");
            exit(-1);
         }
         printf("%d ",maxlurkers);
         sprintf(buf,"%d ",maxlurkers);

         sprintf(tmp,"%d",maxlurkers);
         tmp += strlen(tmp);

         if (maxlurkers > MAXCLIENT)
         {
            printf("Maximum number of clients allowed is %d\n",MAXCLIENT);
	    exit(-1);
         }

         status = scan_str(ml_buf,MSGBUF);

         if (status == -1)
         {
            printf ("max-lurkers message string does not end with // \n");
            exit(-1);
         }

         if (status == -2)
         {
            printf ("max-lurkers message length is greater then %d characters \n",MSGBUF);
            exit(-1);
         }

         sprintf(tmp,"%s\n",ml_buf);
         tmp += strlen(tmp);
         continue;
      }

      if (strcasecmp(code, "MIN-MAC-VERSION") == 0) 
      {
         strcpy(tmp,"min-mac-version ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, "%i",&min_mac_version)) != 1)
         {
            printf ("MIN-MAC-VERSION paramater count error\n");
            exit(-1);
         }
         printf("%d ",min_mac_version);

         sprintf(buf,"%d ",min_mac_version);

         sprintf(tmp,"%d ",min_mac_version);
         tmp += strlen(tmp);

         status = scan_str(mv_mac_buf,MSGBUF);

         if (status == -1)
         {
            printf ("min-mac-version message string does not end with // \n");
            exit(-1);
         }

         if (status == -2)
         {
            printf ("min-mac-version message length is greater then %d characters \n",MSGBUF);
            exit(-1);
         }

         sprintf(tmp,"%s\n",mv_mac_buf);
         tmp += strlen(tmp);

         continue;
      }

      if (strcasecmp(code, "MIN-PC-VERSION") == 0) 
      {
         strcpy(tmp,"min-pc-version ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, "%i",&min_pc_version)) != 1)
         {
            printf ("MIN-PC-VERSION paramater count error\n");
            exit(-1);
         }
         printf("%d ",min_pc_version);

         sprintf(buf,"%d ",min_pc_version);

         sprintf(tmp,"%d ",min_pc_version);
         tmp += strlen(tmp);

         status = scan_str(mv_pc_buf,MSGBUF);

         if (status == -1)
         {
            printf ("min-pc-version message string does not end with // \n");
            exit(-1);
         }

         if (status == -2)
         {
            printf ("min-pc-version message length is greater then %d characters \n",MSGBUF);
            exit(-1);
         }

         sprintf(tmp,"%s\n",mv_pc_buf);
         tmp += strlen(tmp);

         continue;
      }

      if (strcasecmp(code, "REFMON") == 0) 
      {
         strcpy(tmp,"refmon ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, "%i.%i.%i.%i",&hb,&mh,&ml,&lb)) != 4)
         {
            printf ("REFMON paramater count error\n");
            exit(-1);
         }
         printf("%d.%d.%d.%d ",hb,mh,ml,lb);
         sprintf(buf,"%d.%d.%d.%d ",hb,mh,ml,lb);
         
         sprintf(tmp,"%d.%d.%d.%d\n",hb,mh,ml,lb);
         tmp += strlen(tmp);

         if ((control_ip = inet_addr(buf)) == -1)
         {
            printf("inet_addr: bad REFMON address\n");
            exit(-1);
         }
         continue;
      }

      if (strcasecmp(code, "ADMIT-GENERAL-BCC") == 0) 
      {
         strcpy(tmp,"admit-general-bcc ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, "%i %i",&gbcc_cnt,&gbcc_id)) != 2)
         {
            printf ("ADMIT-GENERAL-BCC paramater count error\n");
            exit(-1);
         }
         printf("%d %d ",gbcc_cnt,gbcc_id);

         sprintf(tmp,"%d %d ",gbcc_cnt,gbcc_id);
         tmp += strlen(tmp);

         continue;
      }

      if (strcasecmp(code, "CONF-ID") == 0) 
      {
         strcpy(tmp,"conf-id ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, "%i",&conference_id)) != 1)
         {
            printf ("CONF-ID paramater count error\n");
            exit(-1);
         }
         printf("%d ",conference_id);

         sprintf(tmp,"%d ",conference_id);
         tmp += strlen(tmp);

         status = scan_str(ci_buf,MSGBUF);

         if (status == -1)
         {
            printf ("conf-id message string does not end with // \n");
            exit(-1);
         }

         if (status == -2)
         {
            printf ("conf-id message length is greater then %d characters \n",MSGBUF);
            exit(-1);
         }

         sprintf(tmp,"%s\n",ci_buf);
         tmp += strlen(tmp);

         continue;

      }

      if (strcasecmp(code, "ADMIT-SENDER") == 0) 
      {
         strcpy(tmp,"admit-sender ");
         tmp += strlen(tmp);

         if (admit_cnt == maxallowed)
         {
            printf("%d is the maximum number of clients that can be added to the admit sender list\n",
		    maxallowed);
            exit(-1);
         }

         if ((cnt = fscanf(conf_fd, "%i.%i.%i.%i",&hb,&mh,&ml,&lb)) != 4)
         {
            printf ("ADMIT-SENDER paramater count error\n");
            exit(-1);
         }
         printf("%d.%d.%d.%d ",hb,mh,ml,lb);
         sprintf(buf,"%d.%d.%d.%d ",hb,mh,ml,lb);
         
         sprintf(tmp,"%d.%d.%d.%d ",hb,mh,ml,lb);
         tmp += strlen(tmp);

         if ((admit_senders[admit_cnt++] = inet_addr(buf)) == -1)
         {
            printf("inet_addr: bad ADMIT-SENDER address\n");
            exit(-1);
         }
         local_senders = 0;
	 continue;
      }

      if (strcasecmp(code, "ADMIT") == 0) 
      {
         strcpy(tmp,"admit ");
         tmp += strlen(tmp);

         if (restrict_cnt == maxallowed)
         {
            printf("%d is the maximum number of clients that can be added to the admit list\n",maxallowed);
            exit(-1);
         }

         if ((cnt = fscanf(conf_fd, "%i.%i.%i.%i",&hb,&mh,&ml,&lb)) != 4)
         {
            printf ("ADMIT paramater count error\n");
            exit(-1);
         }
         printf("%d.%d.%d.%d ",hb,mh,ml,lb);
         sprintf(buf,"%d.%d.%d.%d ",hb,mh,ml,lb);
         
         sprintf(tmp,"%d.%d.%d.%d ",hb,mh,ml,lb);
         tmp += strlen(tmp);

         status = scan_str(ad_buf,MSGBUF);

         if (status == -1)
         {
            printf ("admit message string does not end with // \n");
            exit(-1);
         }

         if (status == -2)
         {
            printf ("admit message length is greater then %d characters \n",MSGBUF);
            exit(-1);
         }

         sprintf(tmp,"%s\n",ad_buf);
         tmp += strlen(tmp);


         if ((restrict_list[restrict_cnt++] = inet_addr(buf)) == -1)
         {
            printf("inet_addr: bad ADMIT address\n");
            exit(-1);
         }
         continue;
      }

      if (strcasecmp(code, "CAP") == 0) 
      {
         strcpy(tmp,"cap ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, "%i %i",&cap,&hold_down)) != 2)
         {
            printf ("CAP paramater count error\n");
            exit(-1);
         }
         printf("%d ",cap);

         sprintf(buf,"%d ",cap);

         sprintf(tmp,"%d ",cap);
         tmp += strlen(tmp);

         if (hold_down < 1)
            hold_down = 1;

         printf("%d ",hold_down);

         sprintf(buf,"%d ",hold_down);

         sprintf(tmp,"%d ",hold_down);
         tmp += strlen(tmp);

         status = scan_str(cap_buf,MSGBUF);

         if (status == -1)
         {
            printf ("cap message string does not end with // \n");
            exit(-1);
         }

         if (status == -2)
         {
            printf ("cap message length is greater then %d characters \n",MSGBUF);
            exit(-1);
         }

         sprintf(tmp,"%s\n",cap_buf);
         tmp += strlen(tmp);

         /* change to bytes per second plus a 20% fudge factor */

         cap = ((1024 * cap) /8);
         cap += (cap * .2);

         /* change from minutes to seconds */
         hold_down *= 60;   

         continue;
      }

      if (strcasecmp(code, "DENY") == 0) 
      {
         strcpy(tmp,"deny ");
         tmp += strlen(tmp);

         if (deny_cnt == maxallowed)
         {
            printf("%d is the maximum number of clients that can be added to the deny list\n",maxallowed);
            exit(-1);
         }

         if ((cnt = fscanf(conf_fd, "%i.%i.%i.%i",&hb,&mh,&ml,&lb)) != 4)
         {
            printf ("DENY paramater count error\n");
            exit(-1);
         }
         printf("%d.%d.%d.%d ",hb,mh,ml,lb);
         sprintf(buf,"%d.%d.%d.%d ",hb,mh,ml,lb);
         
         sprintf(tmp,"%d.%d.%d.%d ",hb,mh,ml,lb);
         tmp += strlen(tmp);

         status = scan_str(dy_buf,MSGBUF);

         if (status == -1)
         {
            printf ("deny message string does not end with // \n");
            exit(-1);
         }

         if (status == -2)
         {
            printf ("deny message length is greater then %d characters \n",MSGBUF);
            exit(-1);
         }

         sprintf(tmp,"%s\n",dy_buf);
         tmp += strlen(tmp);

         if ((deny_list[deny_cnt++] = inet_addr(buf)) == -1)
         {
            printf("inet_addr: bad DENY address\n");
            exit(-1);
         }
         continue;
      }


      if (strcasecmp(code, "SELF-REFLECT") == 0) 
      {
         strcpy(tmp,"self-reflect\n ");
         tmp += strlen(tmp);
         self_reflect = 1;
         continue;
      }

      if (strcasecmp(code, "NO-LOCAL-SENDERS") == 0) 
      {
         strcpy(tmp,"no-local-senders\n");
         tmp += strlen(tmp);
         local_senders = 0;
         continue;
      }

      if (strcasecmp(code, "LOG") == 0) 
      {
         strcpy(tmp,"log ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, "%s",tracefile)) != 1)
         {
            printf ("LOG paramater count error\n");
            exit(-1);
         }
         printf("%s ",tracefile);

         sprintf(tmp,"%s\n",tracefile);
         tmp += strlen(tmp);

         continue;
      }

      if (strcasecmp(code, "OBTAIN-GENERAL-BCC") == 0) 
      {
         strcpy(tmp,"obtain-general-bcc ");
         tmp += strlen(tmp);

         if (bcc_srv_cnt == MAXSRCREF)
         {
            printf("%d is the maximum number of OBTAIN-BCC reflectors allowed\n",MAXSRCREF);
            exit(-1);
         }

         if ((cnt = fscanf(conf_fd, "%i.%i.%i.%i %i",&hb,&mh,&ml,&lb,&id)) != 5)
         {
            printf ("OBTAIN-GENERAL-BCC paramater count error\n");
            exit(-1);
         }

         printf("%d.%d.%d.%d %d ",hb,mh,ml,lb,id);
         sprintf(buf,"%d.%d.%d.%d %d",hb,mh,ml,lb,id);
         
         sprintf(tmp,"%d.%d.%d.%d %d\n",hb,mh,ml,lb,id);
         tmp += strlen(tmp);

         if ((bcc_server_list[bcc_srv_cnt] = inet_addr(buf)) == -1)
         {
            printf("inet_addr: bad OBTAIN-BCC address\n");
            exit(-1);
         }

         bcc_server_list_id[bcc_srv_cnt++] = id;

         continue;
      }

      if (strcasecmp(code, "OBTAIN-BCC") == 0) 
      {
         strcpy(tmp,"obtain-bcc ");
         tmp += strlen(tmp);

         if (bcc_srv_cnt == MAXSRCREF)
         {
            printf("%d is the maximum number of OBTAIN-BCC reflectors allowed\n",MAXSRCREF);
            exit(-1);
         }

         if ((cnt = fscanf(conf_fd, "%i.%i.%i.%i",&hb,&mh,&ml,&lb)) != 4)
         {
            printf ("OBTAIN-BCC paramater count error\n");
            exit(-1);
         }

         printf("%d.%d.%d.%d ",hb,mh,ml,lb);
         sprintf(buf,"%d.%d.%d.%d ",hb,mh,ml,lb);
         
         sprintf(tmp,"%d.%d.%d.%d\n",hb,mh,ml,lb);
         tmp += strlen(tmp);

         if ((bcc_server_list[bcc_srv_cnt++] = inet_addr(buf)) == -1)
         {
            printf("inet_addr: bad OBTAIN-BCC address\n");
            exit(-1);
         }

         continue;
      }

      if (strcasecmp(code, "ADMIT-BCC-CLIENT") == 0) 
      {
         strcpy(tmp,"admit-bcc-client ");
         tmp += strlen(tmp);

         if (bcc_clt_cnt == MAXSRCREF)
         {
            printf("%d is the maximum number of ADMIT-BCC-CLIENT reflectors allowed\n",MAXSRCREF);
            exit(-1);
         }

         if ((cnt = fscanf(conf_fd, "%i.%i.%i.%i",&hb,&mh,&ml,&lb)) != 4)
         {
            printf ("ADMIT-BCC-CLIENT paramater count error\n");
            exit(-1);
         }

         printf("%d.%d.%d.%d ",hb,mh,ml,lb);
         sprintf(buf,"%d.%d.%d.%d ",hb,mh,ml,lb);

         sprintf(tmp,"%d.%d.%d.%d\n",hb,mh,ml,lb);
         tmp += strlen(tmp);

         if ((bcc_client_list[bcc_clt_cnt++] = inet_addr(buf)) == -1)
         {
            printf("inet_addr: bad ADMIT-BCC-CLIENT address\n");
            exit(-1);
         }
         continue;
      }

      if (strcasecmp(code, "UNICAST-REF") == 0) 
      {
         strcpy(tmp,"unicast-ref ");
         tmp += strlen(tmp);

         if (ref_ucast_cnt == MAXSRCREF)
         {
            printf("%d is the maximum number of UNICAST-REF reflectors allowed\n",MAXSRCREF);
            exit(-1);
         }

         if ((cnt = fscanf(conf_fd, "%i.%i.%i.%i",&hb,&mh,&ml,&lb)) != 4)
         {
            printf ("UNICAST-REF paramater count error\n");
            exit(-1);
         }

         printf("%d.%d.%d.%d ",hb,mh,ml,lb);
         sprintf(buf,"%d.%d.%d.%d ",hb,mh,ml,lb);
         
         sprintf(tmp,"%d.%d.%d.%d\n",hb,mh,ml,lb);
         tmp += strlen(tmp);

         if ((ref_ucast_list[ref_ucast_cnt++] = inet_addr(buf)) == -1)
         {
            printf("inet_addr: bad UNICAST-REF address\n");
            exit(-1);
         }

         continue;
      }

      if (strcasecmp(code, "VAT-UC-PORT") == 0) 
      {
         strcpy(tmp,"vat-uc-port ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, " %i", &maven_port)) != 1)
         {
            printf ("VAT-UC-PORT paramater count error\n");
            exit(-1);
         }

         printf("%d ",maven_port);
         sprintf(buf,"%d ",maven_port);

         sprintf(tmp,"%d\n",maven_port);
         tmp += strlen(tmp);

         continue;
      }

      if (strcasecmp(code, "NV-STREAMS") == 0) 
      {
         strcpy(tmp,"nv-streams ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, " %i", &nv_streams)) != 1)
         {
            printf ("NV-STREAMS paramater count error\n");
            exit(-1);
         }

         printf("%d ",nv_streams);
         sprintf(buf,"%d ",nv_streams);

         sprintf(tmp,"%d\n",nv_streams);
         tmp += strlen(tmp);

         continue;
      }

      if (strcasecmp(code, "LOG-LIMIT") == 0) 
      {
         strcpy(tmp,"log-limit ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, " %i", &log_limit)) != 1)
         {
            printf ("LOG-LIMIT paramater count error\n");
            exit(-1);
         }

         printf("%d ",log_limit);
         sprintf(buf,"%d ",log_limit);

         sprintf(tmp,"%d\n",log_limit);
         tmp += strlen(tmp);

         continue;
      }

      if (strcasecmp(code, "CONF-MGR") == 0) 
      {
         strcpy(tmp, "conf-mgr ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, "%i.%i.%i.%i", &hb,&mh,&ml,&lb)) != 4)
         {
            printf("CONF-MGR parameter count error\n");
            exit(-1);
          }

          printf("%d.%d.%d.%d ",hb,mh,ml,lb);
          sprintf(buf, "%d.%d.%d.%d ",hb,mh,ml,lb);

          sprintf(tmp, "%d.%d.%d.%d\n",hb,mh,ml,lb);
          tmp += strlen(tmp);

          if ((god_ip = inet_addr(buf)) == -1)
          {
            printf("inet_addr: bad CONF-MGR address\n");
            exit(-1);
          }

          continue;
      }

      if (strcasecmp(code, "MOTD") == 0) 
      {
         strcpy(tmp,"motd \n");
         tmp += strlen(tmp);

         status = scan_str(motd_buf,MOTDBUF);

         if (status == -1)
         {
            printf ("MOTD message does not end with // \n");
            exit(-1);
         }

         if (status == -2)
         {
            printf ("maximum MOTD message length s %d\n",MOTDBUF);
            exit(-1);
         }

         sprintf(tmp,"%s\n",motd_buf);
         motd_len = strlen(motd_buf);
         tmp += motd_len;

         continue;
      }


      if (strcasecmp(code, "VAT-CONF-ID") == 0) 
      {
         strcpy(tmp,"vat-conf-id ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, "%i",&vat_confid)) != 1)
         {
             printf ("VAT-CONF-ID paramater count error\n");
             exit(-1);
           }

        printf("%d ",vat_confid);
        sprintf(buf,"%d ",vat_confid);
        sprintf(tmp,"%d\n",vat_confid);
        tmp += strlen(tmp);

        continue;
      }

      if (strcasecmp(code, "VAT-MC-PORT") == 0)
      {
#ifdef MULTI
         strcpy(tmp,"vat-mc-port ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, " %i", &vat_port)) != 1)
         {
            printf ("VAT-MC-PORT paramater count error\n");
            exit(-1);
         }

         printf("%d ",vat_port);
         sprintf(buf,"%d ",vat_port);

         sprintf(tmp,"%d\n",vat_port);
         tmp += strlen(tmp);

         /*assign the port numbers now...if we try this below and vat_port hasn't
           been set yet, then it will end up as 0 */
         vat_out_mcast.sin_port = htons(vat_port);
         vat_in_mcast.sin_port = htons(vat_port);
#else
         printf ("This copy of the reflector was not built with Multicast support\n");
         exit(-1);
#endif

         continue;
      }



      if (strcasecmp(code, "VAT-MC-OUT") == 0)
      {
#ifdef MULTI
         strcpy(tmp,"vat-mc-out ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, "%i %i.%i.%i.%i",&vat_ttl,&hb,&mh,&ml,&lb)) != 5)
         {
            printf ("VAT-MC-OUT paramater count error\n");
            exit(-1);
         }
         printf("%d %d.%d.%d.%d ",vat_ttl,hb,mh,ml,lb);
         sprintf(buf,"%d.%d.%d.%d ",hb,mh,ml,lb);

         sprintf(tmp,"%d.%d.%d.%d\n",hb,mh,ml,lb);
         tmp += strlen(tmp);

         if ((vat_out_mcast.sin_addr.s_addr = inet_addr(buf)) == -1)
         {
            printf("inet_addr: bad VAT-MC-OUT multicast address\n");
            exit(-1);
         }
         vat_out_mcast.sin_family = AF_INET;

#else
         printf ("This copy of the reflector was not built with Multicast support\n");
         exit(-1);
#endif
         continue;
      }


      if (strcasecmp(code, "VAT-MC-IN") == 0)
      {
#ifdef MULTI
         strcpy(tmp,"vat-mc-in ");
         tmp += strlen(tmp);

         if ((cnt = fscanf(conf_fd, "%i.%i.%i.%i",&hb,&mh,&ml,&lb)) != 4)
         {
            printf ("VAT-MC-IN paramater count error\n", cnt);
            exit(-1);
         }
         printf("%d.%d.%d.%d ",hb,mh,ml,lb);
         sprintf(buf,"%d.%d.%d.%d ",hb,mh,ml,lb);

         sprintf(tmp,"%d.%d.%d.%d\n",hb,mh,ml,lb);
         tmp += strlen(tmp);

         if ((vat_in_mcast.sin_addr.s_addr = inet_addr(buf)) == -1)
         {
            printf("inet_addr: bad vAT-MC-IN multicast address\n");
            exit(-1);
         }
         vat_in_mcast.sin_family = AF_INET;

#else
         printf ("This copy of the reflector was not built with Multicast support\n");
         exit(-1);
#endif
         continue;
      }


      printf ("Configuration file is damaged: Bad CODE value line %d\n",clincnt);
      exit(-1);
   }
   printf("\n");
   fflush(stdout);
   close(conf_fd);
}


short scan_str(buf,maxlen)
   char *buf;
   short maxlen;
{
   short          len;
   char           c,c1,c2;

   len = 0;

   while (1)
   {
      if ((c = fgetc(conf_fd)) == EOF)
         return(-1);

      if ((c == '\n') || (c == '\r'))
      {
         if ((c1 = fgetc(conf_fd)) == EOF)
            return(-1);

         if (c1 == '/')
         {
            if ((c2 = fgetc(conf_fd)) == EOF)
               return(-1);

            if (c2 == '/')
            {
               *buf++ = 0;
               return(0);
            }

            if ((len = len+3) >= maxlen)
               return(-2);

            *buf++ = c;
            printf("%c",c);
   
            *buf++ = c1;
            printf("%c",c1);

            *buf++ = c2;
            printf("%c",c2);
         }
         else
         {
            if ((len = len+2) >= maxlen)
               return(-2); 

            *buf++ = c;
            printf("%c",c);

            *buf++ = c1;
            printf("%c",c1);
         }
      }
      else
      {
         if ((len = len+1) >= maxlen)
            return(-2);

         *buf++ = c;
         printf("%c",c);
      }
   }
}
