(require 'quail)
;; # HANZI input table for cxterm
;; # To be used by cxterm, convert me to .cit format first
;; # .cit version 1
;; ENCODE:	GB
;; MULTICHOICE:	YES
;; PROMPT:	$A::WVJdHk!KAuN}OiJ=TARt!K(B
;; #
;; COMMENT $AAuN}OiJ=TASoW"Rt7=08(B
;; COMMENT Sidney Lau's Cantonese transcription scheme as described in his book
;; COMMENT "Elementary Cantonese", The Government Printer, Hong Kong, 1972.
;; COMMENT This file was prepared by Fung Fung Lee ($A@n7c7e(B).
;; COMMENT Originally converted from CTCPS3.tit
;; COMMENT Last modified: June 2, 1993.
;; COMMENT
;; COMMENT Some infrequent GB characters are accessed by typing \, followed by
;; COMMENT the Cantonese romanization of the respective radical ($A2?JW(B).
;; #
;; # define keys
;; VALIDINPUTKEY:	abcdefghijklmnopstuwy\\
;; SELECTKEY:	1\040
;; SELECTKEY:	2
;; SELECTKEY:	3
;; SELECTKEY:	4
;; SELECTKEY:	5
;; SELECTKEY:	6
;; SELECTKEY:	7
;; SELECTKEY:	8
;; SELECTKEY:	9
;; SELECTKEY:	0
;; BACKSPACE:	\010\177
;; DELETEALL:	\015\025
;; MOVERIGHT:	.>
;; MOVELEFT:	,<
;; # the following line must not be removed
;; BEGINDICTIONARY
(quail-define-package "ctlau" "$AAuN}OiJ=TARt(B"
 t
 "$A::WVJdHk!KAuN}OiJ=TARt!K(B
 $AAuN}OiJ=TASoW"Rt7=08(B
 Sidney Lau's Cantonese transcription scheme as described in his book
 \"Elementary Cantonese\", The Government Printer, Hong Kong, 1972.
 This file was prepared by Fung Fung Lee ($A@n7c7e(B).
 Originally converted from CTCPS3.tit
 Last modified: June 2, 1993.

 Some infrequent GB characters are accessed by typing \\, followed by
 the Cantonese romanization of the respective radical ($A2?JW(B)."
 '(
  ("." . quail-next-candidate-block)
  (">" . quail-next-candidate-block)
  ("," . quail-prev-candidate-block)
  ("<" . quail-prev-candidate-block)
  (" " . quail-select-current)
  )
 nil nil)

;; #
(qdv "a"	"$A0"0!Q;Q=Q>QFQG_9k2o9(B")
(qdv "aai"	"$A0#0$`I0%0&0/`H(B")
(qdv "aan"	"$AjL03(B")
(qd "aang"	"$As?(B")
(qd "aap"	"$AQ<(B")
(qdv "aat"	"$AQ9Q:(B")
(qd "aau"	"$A^V(B")
(qdv "ak"	"$ANU6s6rv;(B")
(qdv "am"	"$A05ZOwv(B")
(qd "ang"	"$A]:(B")
(qdv "au"	"$AE7E8E9E;E=(B")
(qdv "ba"	"$A0Q0M0E0H0I0J0L0P0S0T0U0V]bnYtN(B")
(qdv "baai"	"$AEH0Z0\0]0^_B(B")
(qdv "baak"	"$A0W0Y2.0[2/FH27(B")
(qdv "baan"	"$A0l0`0_0d0e0f0gZf[`c]t2(B")
(qdv "baang"	"$A1A1D(B")
(qdv "baat"	"$A0K0F(B")
(qdv "baau"	"$A0|0z0{1%1+1,v5(B")
(qdv "bai"	"$A1R1U1M1N1P1V1W1](B")
(qd "bak"	"$A11(B")
(qdv "bam"	"$A1CER(B")
(qdv "ban"	"$A1v1?1r1s1u1w1<F7YwYOfIikkwo<oY(B")
(qdv "bang"	"$A1@`T(B")
(qdv "bat"	"$A2;1O1J0N0O_YevnP(B")
(qd "be"	"$AF!(B")
(qdv "bei"	"$A1;1/181H1Gn/F"1.10191K1Q1S1T1[1\CXCZE~X0YB`N_Ae~n<(B")
(qdv "beng"	"$A1z1}2!(B")
(qdv "bik"	"$A1F1L1ZtEh5(B")
(qdv "bin"	"$AXR1b1c1d1_1a1e1f1g1h1^cjq9(B")
(qdv "bing"	"$A2"1x1y1{1|1~1E(B")
(qdv "bit"	"$A1p1n1o1q1Xni(B")
(qdv "biu"	"$A1m1j1kf;opoZ(B")
(qdv "bo"	"$A281#2?2<1(292=1)0}262>2@1$1&FRFXlRp1(B")
(qdv "boh"	"$A2#2$2%2(FB[6`#(B")
(qdv "bok"	"$A252+2)2,2-2022241]1"8?(B")
(qdv "bong"	"$A0n0o0p0q0s0u0w(B")
(qdv "booi"	"$A131-121415171:(B")
(qdv "boon"	"$A0k1>0cEO0a0i0m1=EQEV(B")
(qdv "boot"	"$A2'c#212&2*23XC(B")
(qdv "buk"	"$A27FY_2nGFM(B")
(qd "bung"	"$A1B(B")
(qdv "cha"	"$Aoo2i2n2f2g2h2k2m2oNNT{w~(B")
(qdv "chaai"	"$A2B2H2q2rY-nN(B")
(qdv "chaak"	"$A2b2_2a2pTtb|(B")
(qdv "chaam"	"$A2N2O2Q2R2s2t2v2wI<wu(B")
(qdv "chaan"	"$A2y2z2M2P2StS(B")
(qdv "chaang"	"$A3E3H(B")
(qd "chaap"	"$A2e(B")
(qdv "chaat"	"$A2l2AL!K"`'`j(B")
(qdv "chaau"	"$A3-3.323334qi(B")
(qdv "chai"	"$AF`FkF\F^FvYQ]B_b(B")
(qdv "cham"	"$AQ03AGVG^G_Z__Dd1v`(B")
(qdv "chan"	"$A3B3>3C3DGWUnUo_Sv3n3or(B")
(qdv "chang"	"$A2cTx(B")
(qdv "chap"	"$A<)<-(B")
(qdv "chat"	"$AF_FaFb(B")
(qdv "chau"	"$AGo3i3j3k3l3m3o3q3r3s3t4UGtGvGBPaY1t\(B")
(qdv "che"	"$A35GR366_I]P0P1(B")
(qd "chek"	"$A3_(B")
(qd "cheng"	"$AGk(B")
(qdv "cheuk"	"$A4A4BIVIWW?W@WFY>ey(B")
(qdv "cheung"	"$AG=Oj403$3!Oi2}2~3&3)3*3+G9G:G>G@Ohc^f=(B")
(qdv "chi"	"$A3U3X4J4L4NKFJ<2^4K3YJA3a3]3c4C4D4E4F4G4H4I4M3V3W3Z3[3\3^FjJ8JQVD_j`4`M_Zekf&ltr?tYuXot(B")
(qdv "chik"	"$AF]3`3b`R_3k7(B")
(qdv "chim"	"$AG)G1G5YTe_o7Y](B")
(qdv "chin"	"$AG'G.OK=&G0G32x2{2|<_G$G%G(G*Zd(B")
(qdv "ching"	"$A3N3FGi3LGk3J3M3Q3S5IG`GeGgGhU|r_(B")
(qd "chip"	"$Af*(B")
(qdv "chit"	"$AGP37393:FcIhU^(B")
(qdv "chiu"	"$A3/3,31=8GDGFGMGNLvP$UQnH(B")
(qdv "cho"	"$A2]2Y2Z2[2\4V4W4kThTjTkTo`Pa^ick}t=(B")
(qdv "choh"	"$Ao14l3u3z3{3~4!4h4j4m[;os(B")
(qdv "choi"	"$A2G2J2E2F2C2D2I2K2LH|TTH{(B")
(qdv "chong"	"$A42442X2V2T2U2W4/433'3(Xw(B")
(qdv "chue"	"$A4&3w3x3y4"JoJpVyV|Xyui(B")
(qdv "chuen"	"$A4e4f4+H+4'4(4)4-4.4Z4\4gH)H*H,K(K)MD\uk0nKn}oiY`(B")
(qdv "chuet"	"$A4iW>6^W:WB`(`\_M(B")
(qdv "chui"	"$AH!45KeKf3}3|4647484]4^4_4`4dGwH"H$Pl_}(B")
(qdv "chuk"	"$A4Y4#4$JxKYPnPsX!v:(B")
(qdv "chun"	"$A4:4;4@GXQ-Q.Q2(B")
(qdv "chung"	"$AVX3d4S3e3f3h4O4P4Q4R4TKIVTZ#o%(B")
(qdv "chut"	"$A3vwmwq(B")
(qd "da"	"$A4r(B")
(qdv "daai"	"$A4s4x4u4w4t(B")
(qdv "daam"	"$A`"5"5#5(5*5-YYqu(B")
(qdv "daan"	"$A5+5%5$5&5'5)5,5.5/50ncw0(B")
(qdv "daap"	"$A4pL$4n4qm3(B")
(qdv "daat"	"$A4oL"`*sNw2(B")
(qdv "dai"	"$A5]5ZA%5W4~5M5V5[5\X5tF(B")
(qdv "dak"	"$A5B5CLXo=(B")
(qdv "dang"	"$A5H5E5F5G5J5K`bj-ok(B")
(qdv "dat"	"$AM9M;(B")
(qdv "dau"	"$A69676665686:6;>@nWr=q<(B")
(qdv "de"	"$A5y`G(B")
(qd "dei"	"$A5X(B")
(qdv "dek"	"$A5QYa(B")
(qdv "deng"	"$A6"6$p[(B")
(qd "deuh"	"$A6d(B")
(qdv "deuk"	"$AWAWD(B")
(qdv "dik"	"$A5D5N5O5P5R5S5U`Voa(B")
(qdv "dim"	"$A5c5`5j(B")
(qdv "din"	"$A5g5d5b5e5f5i5l5m5n5_a[ndq2(B")
(qdv "ding"	"$A6&6(6)6!6#6%6'M]Xjqttz(B")
(qdv "dip"	"$A5z5{5}5~`)k:(B")
(qdv "dit"	"$A5x5|VHisp,(B")
(qdv "diu"	"$A5u5q5t5w5o5p5r5s5v6*nvn{uu(B")
(qdv "do"	"$A565@5=6H6<6B6C6D6E6F6I6J57595:5<5>5?5A`=k.(B")
(qdv "doh"	"$A6`6b6c6d6e6g6h6i_a(B")
(qdv "doi"	"$A4z4}4|a7wl(B")
(qdv "dok"	"$Anlub(B")
(qdv "dong"	"$A5451525355nu(B")
(qdv "duen"	"$A6L6M6N6O6K6P(B")
(qd "duet"	"$A6a(B")
(qdv "dui"	"$A6T6Q6R6S(B")
(qdv "duk"	"$A6@6=6>6?6Ak9sFwr(B")
(qdv "dun"	"$A6X6Y6U6V6[6](B")
(qdv "dung"	"$A6/6+6.416,6-6061626364_Kk1(B")
(qdv "fa"	"$A;(;/(B")
(qdv "faai"	"$A?l?i?j?~_`(B")
(qdv "faan"	"$A7:7174hs7672787*0j7+7,7-7.7/7073757779^,n2(B")
(qdv "faat"	"$A7"7(7)(B")
(qdv "fai"	"$A;S;U7Q7M7N7O7P;TjMoP(B")
(qdv "fan"	"$A7]7V7\7`7R7S7T7U7W7X7Y7Z7[7^7_;g;h;iQ,Q5YG^9ww(B")
(qdv "fat"	"$A7p:v7w7z8%7#7$7%7&7'_|eulp(B")
(qdv "fau"	"$A7q2:8!8"87FJs>n7(B")
(qd "fe"	"$A7H(B")
(qdv "fei"	"$A7I7Gkh7F7J7K7LdGezl3rctdv-li(B")
(qdv "foh"	"$A?F;u;p;o?NnXrr(B")
(qdv "fok"	"$A;t>p(B")
(qdv "fong"	"$A7B?v7=7E7;7<7>7?7@7A7C7D;D;E;N;O;P;Qa]hJkAnUt3(B")
(qdv "foo"	"$A7r:tfZ888;8(7{8*7t817s7u7v7}8&8'8)8+8-8.8/808385868:8<8=8>8@:u;";#?`?b?c?]XZ\=\^_;fbw<jglf(B")
(qdv "fooi"	"$A;Z;e;R;V;^?|?}Z6`-`9(B")
(qdv "foon"	"$A;6?m?n(B")
(qd "foot"	"$A@+(B")
(qdv "fuk"	"$A847~8#7x7y7|8$8289Ykp%rp(B")
(qdv "fung"	"$A7g7l7a7b7c7d7e7f7h7i7j7k7m7n7oY:_t(B")
(qdv "ga"	"$A<\<Y<[<S<^8A8B<N<O<R<V<Z<]oXtB(B")
(qdv "gaai"	"$A=b=i=W=g=V<Q=d=f=j=k=l=T=UYI^N`.(B")
(qdv "gaak"	"$A8o8q8l8tX*`CkuoSw@(B")
(qdv "gaam"	"$A<u<`<x^OvN(B")
(qdv "gaan"	"$A<i<d<r<h<k<m<n<o<p<q='ZIo5(B")
(qd "gaang"	"$A8{(B")
(qdv "gaap"	"$A<W<P<T<U<XkNnr(B")
(qdv "gaau"	"$A=L=O=;8c=:=<=A=B=F=H=J=QY.p(rTuS(B")
(qdv "gai"	"$A<F<L<&<;YJ(B")
(qdv "gam"	"$A=p=q8P8J8L8R<j=u={`d(B")
(qdv "gan"	"$A=|=t8z8y=m=n=o=v=w=y]@_gt^(B")
(qdv "gang"	"$A9#8|8}8~9]9">,_l(B")
(qdv "gap"	"$A8k8r<1(B")
(qdv "gat"	"$A8m<*=[Y%(B")
(qdv "gau"	"$A>?>I>E9;969798>A>B>C>D>G>H>L>N?Yw|(B")
(qdv "gei"	"$A<8<G;z;y<H<M<<;~<!<"<%<'<:<?<D<I<KX^_4h=g\wdn?(B")
(qdv "geng"	"$A>5>1(B")
(qd "geuk"	"$A=E(B")
(qdv "geung"	"$A=)=*=.G<t](B")
(qdv "gik"	"$A<,<$<+;wX=ijj*(B")
(qdv "gim"	"$A=#<l<f<s(B")
(qdv "gin"	"$A=!<{<~=(<a<g<|=]kl(B")
(qdv "ging"	"$A>6>9>#>->)>3>0>">$>%>*>/>4>7>:XYYSqf(B")
(qd "gip"	"$A=Y(B")
(qdv "git"	"$A=a=`=\hn(B")
(qdv "giu"	"$A=>=P=?=C=Ik8(B")
(qdv "go"	"$A8_8e8f8]8^8`8a8b8dR$X:Z>(B")
(qdv "goh"	"$A8h8v8g(B")
(qdv "goi"	"$A8C8D(B")
(qdv "gok"	"$A>u8w8i8s=Gge(B")
(qdv "gon"	"$A8I8K8M8N8O8QG,(B")
(qdv "gong"	"$A=-8[8T8U8V8W8X8Y8Z8\=2=5?8qpn8(B")
(qdv "goo"	"$A9E9A9L9I9B9J9<9=9>9@9C9D9F9K9Mn\p3o@n9(B")
(qdv "goon"	"$A9\9Z9[9Y9`9a9W9]9^NSYD]8pY(B")
(qdv "got"	"$A8n8p:V(B")
(qdv "guen"	"$A>h>i>j>k>l>m>nH/Q+d8(B")
(qdv "gui"	"$A>_>]>d>Y>e>S>X>^>a>b>fYFe}l+q@(B")
(qdv "guk"	"$A>V>U9H>O`7o8(B")
(qdv "gung"	"$A9&9$9+929'8S9%9(9)9*9,9-9.9091r<(B")
(qdv "gwa"	"$A9O9R9P9QXT_I(B")
(qdv "gwaai"	"$A9T9U9V(B")
(qdv "gwaan"	"$A9X9_(B")
(qd "gwaang"	"$A9d(B")
(qdv "gwaat"	"$A9N@((B")
(qdv "gwai"	"$A9q<>9e9g9h9i9j9k9l9m9n9p9r9s<B?y@!XPXQX[p'(B")
(qdv "gwan"	"$A>}>|>y9v9w>{?$Yrs^(B")
(qd "gwang"	"$A:d(B")
(qdv "gwat"	"$A9G>r?_w;(B")
(qdv "gwing"	"$A><lg(B")
(qdv "gwoh"	"$A9}9{8j9|?C?Eo>(B")
(qdv "gwok"	"$A9y9z@*(B")
(qdv "gwong"	"$A9c9b(B")
(qdv "ha"	"$AODOB9~O:O<O>OCeZh&n~(B")
(qdv "haai"	"$AP3:!:"?+P,P5P7P8eb(B")
(qdv "haak"	"$A?MOE(B")
(qdv "haam"	"$AONOL:-:/:0OZ(B")
(qdv "haan"	"$AO^OPf5(B")
(qdv "haang"	"$A:;?SPP(B")
(qdv "haap"	"$AF~O?OA`>_H(B")
(qdv "haau"	"$AP'GCP#?<:p=M?=?>GIOxP"f/(B")
(qdv "hai"	"$AO5Yb^Ilyw{(B")
(qdv "hak"	"$A?L:U:Z?&?Kk4(B")
(qdv "ham"	"$A:6:,:(:):3?0?1?2?3G6O]r%(B")
(qdv "han"	"$A:\:[:]:^?Q?R(B")
(qdv "hang"	"$APRPP:_:`:b:c?O?PPSo,(B")
(qdv "hap"	"$AO@:O:PG]G"O;qkr"(B")
(qdv "hat"	"$A:KFrO9O=[@(B")
(qdv "hau"	"$A?Z:saa:r:m:n:o:qeKtWvW(B")
(qdv "hei"	"$AFxFp_qO#O2F{:YF[FqFwFzNuN{N~O]O)O7YRfRjXldl{tK(B")
(qd "hek"	"$A3T(B")
(qd "heuh"	"$AQ%(B")
(qdv "heung"	"$AOrOlOmOcINOgbC(B")
(qdv "him"	"$AOUG+G7(B")
(qdv "hin"	"$AG#OWOTG2G4PyOFOGO\Q\llr9OK(B")
(qdv "hing"	"$APKGaGbGdGlPV\0s@(B")
(qdv "hip"	"$AG8GSP-P.P2(B")
(qd "hit"	"$AP*(B")
(qdv "hiu"	"$A===DGAGOOyO~_Xfg(B")
(qdv "ho"	"$A:E:F:C:>:?:@:A:D`F`cj;p)r+wR(B")
(qdv "hoh"	"$A:N:I?I:S:G:J:X?@`@t4(B")
(qdv "hoi"	"$A:&?*:#:$:%:'?-X\`Knxo4r$(B")
(qdv "hok"	"$AQ':W?G(B")
(qdv "hon"	"$A:.::?4:9?/:*:+:1:2:4:5:7:8Y)e+q|w}(B")
(qdv "hong"	"$A?5:=PP:<?o?p?t?6?7?TG;OnOo_Qq~(B")
(qdv "hot"	"$A?J:H(B")
(qdv "huen"	"$APzH&H.H0Q$]fn0(B")
(qd "huet"	"$AQ*(B")
(qdv "hui"	"$APiPmH%PjPfZ<hrlcq4(B")
(qdv "huk"	"$A?a?^(B")
(qdv "hung"	"$APZ:lP[?U?V:e:f:g:h:i9/?W?XPWPXPYP\PoYE(B")
(qdv "ja"	"$A2jT[T|U%U&U'U(U)^j_e_8rF(B")
(qdv "jaai"	"$AU+U.U/(B")
(qdv "jaak"	"$ATpU,5TTqTsV@U*U-ZX_ut7(B")
(qdv "jaam"	"$AU>T]U6U8U:U?tX(B")
(qdv "jaan"	"$AT^U5U;U@WkW+W,(B")
(qdv "jaang"	"$AUuUvUxUy(B")
(qdv "jaap"	"$AO0TS</O.U"U#_Fl*(B")
(qdv "jaat"	"$ATzT}T~_n(B")
(qdv "jaau"	"$AUR30VbVhUVW%W&(B")
(qdv "jai"	"$AVF<C<7<@<A<JVMWPv+38(B")
(qdv "jak"	"$ATr2`XF(B")
(qdv "jam"	"$AUm=~TuUeUkZZp2(B")
(qdv "jan"	"$AUrUfUqUdUpUs[Z`Ajb(B")
(qdv "jang"	"$ATv2dI.TwTxTy`aa?o#o-s]n@(B")
(qdv "jap"	"$AV-V4(B")
(qdv "jat"	"$A<2<5V6VJVO(B")
(qdv "jau"	"$AV^>FVg>MV[V]W_>>PdV\V_VcVdVeVfW`WaW^YV_z`1f{kP(B")
(qdv "je"	"$AUbU_=h=cP;U`UaUZ`5i?pQ(B")
(qdv "jek"	"$AV;<9VK_s(B")
(qdv "jeng"	"$A>.>;V#Ze(B")
(qdv "jeuk"	"$AWCWEH8>t=@H5lz(B")
(qdv "jeung"	"$AUEOs=+=/UF3$=,=0=1=3=4OpOqUAUBUCUDUGUHUIUJUKULUMUNUOXvbjoOs/Xk(B")
(qdv "ji"	"$AWSWTWOWVV*VGV>V.WKWMWJVNV9V;V=VAKBKCKEKGKHV%V&V'V(V)V+V,V7V8V:V<V?VBVCVIVLWHWIWLWNWQZQY9\Ff"lklmlsoEqhqjtRv7(B")
(qdv "jik"	"$A<(V0V/V1<.<4;}<#<E=eNyO&O+O/V2V3V5WUq6vjU](B")
(qdv "jim"	"$A<b=%IDUhU0U2U3U4U<Z^(B")
(qdv "jin"	"$AU9=&<c<e<t<v<y<z<}=$DhDkL:U1U7U=j'te(B")
(qdv "jing"	"$AagU}>2V$U~U{>&>'>+>8UjUlUtUwUzV!V"lun[(B")
(qdv "jip"	"$A=S`?_](B")
(qdv "jit"	"$A=ZU[=X=]=^UcU\U](B")
(qdv "jiu"	"$A=6=7=9=KUPUSUTUUUYXdZ/YU`]3/(B")
(qdv "jo"	"$ATgWiTlWvWfTbTcTeTfTiTmTnWb_plq(B")
(qdv "joh"	"$AWxVzWhWsWtWyY^_r(B")
(qdv "joi"	"$ATZTYTUTVTWTXWRg^(B")
(qdv "jok"	"$AWwTdWrWu(B")
(qdv "jong"	"$AW42XT_T`TaW.W/W0W1W2W3j0(B")
(qdv "jue"	"$AVwW!W"VxVnVmVjViVkVlVoVsVtV{V}W]W$Y*\of-nywf(B")
(qdv "juen"	"$A4+W(W*6WT\WjWpWqW)_yr'(B")
(qdv "juet"	"$A>x6^W:`(`\(B")
(qdv "jui"	"$AWnWmPr>W>Q>R>Z>[GyPpWgWlWoW5W6W7W8W9v4vBSl(B")
(qdv "juk"	"$AWcWePxKW4%4XV`VaVpVqVrVuVvV~W#W=WG`Uf(omo_t6sC(B")
(qdv "jun"	"$A=x>!W<=r=z=}>~?]?"?#?%UiiWoTq8(B")
(qdv "jung"	"$AVPVVVZW]WZW\VUKLKOKPVQVRVSVWVYWWWXWYW[YLoqt)t1tU(B")
(qd "jut"	"$AWd(B")
(qdv "ka"	"$A?(?'X{_G(B")
(qd "kaai"	"$A?,(B")
(qd "kaat"	"$A_R(B")
(qdv "kaau"	"$A??nm(B")
(qdv "kai"	"$AFu;|FtF}O*(B")
(qdv "kam"	"$At@=sGYG\G]`_f!(B")
(qdv "kan"	"$AGZG[(B")
(qdv "kap"	"$A<0N|8x<3<6sE(B")
(qd "kat"	"$A?H(B")
(qdv "kau"	"$A?[tC99Gs959:>J>K?\GrY4_5fEp/r0(B")
(qdv "ke"	"$AFoH3GQY$(B")
(qdv "kei"	"$AFeFdFZFmFlFs;{<=FfFgFiFna*gwlwq}whw"(B")
(qd "kek"	"$A>g(B")
(qdv "keuk"	"$AH4`e(B")
(qdv "keung"	"$AG?ojtG(B")
(qdv "kim"	"$AG-G/(B")
(qd "kin"	"$Ar/(B")
(qdv "king"	"$AGc>(GfGjGmwt(B")
(qdv "kit"	"$Ar!>o=R=_P+f]tIwo(B")
(qdv "kiu"	"$A=NGEGGGHGKGLO-(B")
(qd "koh"	"$An](B")
(qdv "koi"	"$A8E8G8F8H?.?DX$n'(B")
(qdv "kok"	"$AH7:B:TH6[V(B")
(qdv "kong"	"$A?9@)?q?s?:?;XxnV?u(B")
(qd "koo"	"$A9?(B")
(qdv "kooi"	"$A9t;b;f;_?k@#kZqy(B")
(qdv "koot"	"$A@(;mqx(B")
(qdv "kuen"	"$AH(;?H'H-(B")
(qdv "kuet"	"$A>w>v>qH1H2XJXcZ\`Yf^oc(B")
(qdv "kui"	"$AGx>P>T>\>`>cG{G}G~X~aia+lnvD(B")
(qd "kuk"	"$AGz(B")
(qdv "kung"	"$AGnq7(B")
(qdv "kwa"	"$A?d9S?e?f?g?hY((B")
(qd "kwaang"	"$A?r(B")
(qdv "kwai"	"$A9f9o?w?x?z?{@"P/X8aMeS(B")
(qdv "kwan"	"$A@'9u>=>z@$@%@&H9H:o?(B")
(qdv "kwik"	"$AO6k=(B")
(qdv "kwong"	"$A?s?u(B")
(qdv "la"	"$AsA@.@2X](B")
(qdv "laai"	"$A@-@5(B")
(qdv "laam"	"$A@6<w="@7@:@?@@@B@Dq\n=(B")
(qdv "laan"	"$A@<@8@9@;@=@>@A@Cog(B")
(qd "laang"	"$A@d(B")
(qdv "laap"	"$A@0@,@/(B")
(qdv "laat"	"$A@1eepx(B")
(qdv "lai"	"$A@}@v@g@h@q@s@w@xY3fjtOws(B")
(qdv "lak"	"$A@U@_Xl`O(B")
(qdv "lam"	"$AA]AUAVAXAYA\_x(B")
(qdv "lap"	"$AA"0<A#sR(B")
(qd "lat"	"$AK&(B")
(qdv "lau"	"$AB)B%AtAwAoApAqArAsAuAvAxB&B'B(B*YM`6froNoVqowC(B")
(qd "le"	"$A_V(B")
(qdv "lei"	"$A@n@{@mA'@~@e@f@i@j@k@l@o@p@r@tBDA]A(Y5`,f2o.n>(B")
(qd "lek"	"$A_7(B")
(qdv "leng"	"$Av&vl(B")
(qdv "leuk"	"$ABTBS(B")
(qdv "leung"	"$AA:A=A?A)A8A9A;A<A>AAAB(B")
(qdv "lik"	"$AA&@zA$_?(B")
(qdv "lim"	"$AA-A.A1A2A3ig(B")
(qdv "lin"	"$AA,A/A6A7A+A0A4Dl(B")
(qdv "ling"	"$AAbAlAmAiAc@b@cA`AaAdAeAfAgAhAjAkAn_Jqv(B")
(qdv "lip"	"$AAT^[(B")
(qdv "lit"	"$AAPAQARY}(B")
(qdv "liu"	"$AAHAKACADAEAFAGAIALAMANAO`ZnI(B")
(qdv "lo"	"$AB7B6B,@O@L@M@N@P@Q@TB+B-B.B/B0B1B2B3B8B:B?_k``a@iVnnoepXplo)qlt5vT(B")
(qdv "loh"	"$AB^?)B\B]B_B`BaBcAJY@o](B")
(qdv "loi"	"$A@4@3abqgmy(B")
(qdv "lok"	"$A@VBd8u:Q@R@SBeBfBgK8@V(B")
(qdv "long"	"$A@E@F@G@H@I@J@KA@`%rk(B")
(qdv "luen"	"$AA*BMBNBOBPBRA5f.(B")
(qd "luet"	"$AAS(B")
(qdv "lui"	"$ABB@o@`@[@a@Z@W@X@Y@\@]@^B@BABCBEBFBGBKBbYz`&le(B")
(qdv "luk"	"$AB<B9AyB=B4B5B;B>BHBL(B")
(qdv "lun"	"$ABXBQBUBVBWBYBZB[AWAZA[A_j%wk(B")
(qdv "lung"	"$AkJAzA{A|A}A~B!B"B#B$E*gg(B")
(qdv "lut"	"$A@uBI@|BJm2(B")
(qd "m"	"$A_m(B")
(qdv "ma"	"$ABiBhBmBkBjBlBnBoBp(B")
(qdv "maai"	"$ABtBqBrBu(B")
(qdv "maan"	"$AMrB}MmBxByB{B|B~C]w)(B")
(qdv "maang"	"$AC$CLCMCOrlt;(B")
(qdv "maau"	"$AD5C(C)C,C-C.C2jD(B")
(qdv "mai"	"$ACPCQCTCUCW_d(B")
(qdv "mak"	"$ABsBvD+D,D0]k_i(B")
(qdv "man"	"$ANDNECqNJCrCtCuCvC%NCNFNGNIXXc}v)h7(B")
(qdv "mang"	"$ACHCK(B")
(qdv "mat"	"$ANoC[C\M`NpX?ZW(B")
(qdv "mau"	"$AD3C3C}D1D2D6C/Y0mx(B")
(qd "me"	"$A_c(B")
(qdv "mei"	"$AC@N4N2C<C>CBCDCRCSN"N6^1aRetf8pLoQt:tMv2wcwg(B")
(qd "mi"	"$A_d(B")
(qdv "mik"	"$ACYci(B")
(qdv "min"	"$ACfCbC`CaCcCdCeC^C_(B")
(qdv "ming"	"$AC{CwC|CsCxCyCzZ$\xu$(B")
(qdv "mit"	"$ACoCpsz(B")
(qdv "miu"	"$ACnChCgCiCjCkClCmC*_wechCm5q:(B")
(qdv "mo"	"$ANdN^D8NqD!D#D4D7D9D:D<D=C+C0C1NWN\N_NcNhNjNlNm_h_<e|pD(B")
(qdv "moh"	"$AC4waC~D"D%D&D'fVqrwb(B")
(qdv "mok"	"$AD*0~D$D.D/D;C](B")
(qdv "mong"	"$AC#M|MvC"C&C'MxM{M}Xh(B")
(qdv "mooi"	"$AC6C5C7C8C9C:C=C?CACCwH(B")
(qdv "moon"	"$ABzCGCEBwCFnMr)ug(B")
(qdv "moot"	"$AD)C;D(D-\Tib(B")
(qdv "muk"	"$AD>D?D@DADBXo\Ycenb(B")
(qdv "mung"	"$ACICJCNcBk|t?(B")
(qdv "na"	"$ADCDGDDDHE2oU(B")
(qdv "naai"	"$ADJDKDL(B")
(qdv "naam"	"$ADODP`+a0kn(B")
(qd "naan"	"$ADQ(B")
(qdv "naap"	"$ADEDFDIZ+(B")
(qdv "naau"	"$ADSDVDW_Nns(B")
(qd "nai"	"$AD`(B")
(qd "nam"	"$AZE(B")
(qd "nang"	"$AD\(B")
(qdv "nau"	"$AE$E%E&P`f$fUqqt[(B")
(qd "ne"	"$ADX(B")
(qdv "nei"	"$ADcDa6|6}D]DeDzCVl;lrnj(B")
(qd "neung"	"$ADo(B")
(qdv "ng"	"$ANeNsN`NaNbNfNgNiNnNrXu`ErZwy(B")
(qdv "nga"	"$AM_Q?Q@QAQCQEQHXsXt(B")
(qdv "ngaai"	"$A0,QBQDXW^_(B")
(qd "ngaak"	"$A6n(B")
(qdv "ngaam"	"$A0)QR(B")
(qdv "ngaan"	"$AQcQUQ[(B")
(qd "ngaang"	"$AS2(B")
(qdv "ngaau"	"$AO}R'X3kH(B")
(qdv "ngai"	"$AN#0+D^D_N!N1N:RORURcRh_=t/t`(B")
(qd "ngak"	"$A_@(B")
(qdv "ngam"	"$AbVpF(B")
(qdv "ngan"	"$AHMRxv8(B")
(qdv "ngat"	"$AFyRYX#Xn(B")
(qdv "ngau"	"$AE#9394E:E<qn(B")
(qd "ngit"	"$ADv(B")
(qdv "ngo"	"$A0A0=0>0?qz(B")
(qdv "ngoh"	"$ANRNT6j6k6l6m6o6p6vE6o0(B")
(qdv "ngoi"	"$A4tMb0-:R(B")
(qdv "ngok"	"$A6uT@ZLoIr&@V(B")
(qd "ngon"	"$A06(B")
(qd "ngong"	"$A0:(B")
(qd "ngung"	"$ANM(B")
(qd "ne"	"$ADX(B")
(qdv "nik"	"$A@yDdDg(B")
(qdv "nim"	"$ADnDip$(B")
(qd "nin"	"$ADj(B")
(qdv "ning"	"$AD{D|D~E]E"Xz_Lqw(B")
(qdv "nip"	"$ADmDsDtDwDxDyr((B")
(qdv "niu"	"$ADqDrtA(B")
(qdv "no"	"$AE,DTDUE+E-es(B")
(qdv "noh"	"$AE3E4YP_v(B")
(qdv "noi"	"$ADNDZDMDYhM(B")
(qdv "nok"	"$AE5o;(B")
(qdv "nong"	"$ADRH?`l(B")
(qdv "nuen"	"$AD[E/(B")
(qdv "nui"	"$AE.nO(B")
(qd "nuk"	"$At,(B")
(qdv "nung"	"$AE'E(E)Y/_f(B")
(qdv "o"	"$A0D0@0B0CNk(B")
(qdv "oh"	"$A?A?B`8`^f9ippb(B")
(qdv "oi"	"$A0.0'0(0*fHoMv0(B")
(qdv "ok"	"$A6qX,[Qc5(B")
(qdv "on"	"$A020800010407o'(B")
(qdv "ong"	"$A090;(B")
(qdv "pa"	"$AEB0G0RE?E@EChK(B")
(qdv "paai"	"$AEEEFEIY=(B")
(qdv "paak"	"$A0XFGFIE>EAEDgj(B")
(qdv "paan"	"$A0bEJEN(B")
(qdv "paang"	"$AEl0tEkEmEoEpErEt`X(B")
(qdv "paau"	"$AEZEY1*EWEXE\E](B")
(qd "pai"	"$AEz(B")
(qdv "pan"	"$A1tEgF5F6(B")
(qdv "pang"	"$AF>Es(B")
(qdv "pat"	"$AF%qb(B")
(qdv "pei"	"$AF)F$1IExE{E}F#F&F(E^X'Xrf>hAnk(B")
(qd "pek"	"$AE|(B")
(qdv "pik"	"$A1YEyF'q1(B")
(qdv "pin"	"$A1i1`F*F+F,F-ry(B")
(qdv "ping"	"$AF4F=EjF;3REiF8F9F:F<F?F@FAY7f0f3fi(B")
(qdv "pit"	"$AF2F3X/k-(B")
(qdv "piu"	"$AF11lF.F/F0Xb`QfNih(B")
(qdv "po"	"$AFWFU1'8,FLFNFOFQFTFVE[Yid_oh(B")
(qdv "poh"	"$AFFFEFDXOn^p+uK(B")
(qdv "pok"	"$AFKFS`[od(B")
(qdv "pong"	"$AET0r0v0x0yESEUdhs&(B")
(qdv "pooi"	"$A16EdE`EaEbEcEeEfEwFPEGE_oBv,(B")
(qdv "poon"	"$AELEKEP0hEhEM(B")
(qdv "poot"	"$AFCn`(B")
(qd "puk"	"$AFM(B")
(qdv "pung"	"$AEnEqEuEv(B")
(qdv "sa"	"$AHwI/I0I3I4K#X&Xm`DtDvh(B")
(qdv "saai"	"$AI9acgtsB(B")
(qdv "saam"	"$AH}H~I@nL(B")
(qdv "saan"	"$AI=I"4[I]I:I>IGU$d}cEf)t.uG(B")
(qdv "saang"	"$AJ!Iz(B")
(qdv "saap"	"$A;xTQTRv.(B")
(qdv "saat"	"$AHvHxI1I2I7o](B")
(qdv "saau"	"$AGJIRISITIZt9(B")
(qdv "sai"	"$AO8NwJFJ@JDJEJII8NxPvO,O4tQ(B")
(qdv "sak"	"$AH{`g(B")
(qdv "sam"	"$APDIuIrIs3;3@InItIxJ2I-a/(B")
(qdv "san"	"$AIqPBIm3?Ij3<3=IiIkIlIoIpIvIwP=P?PA(B")
(qdv "sang"	"$AIzI{I|(B")
(qdv "sap"	"$AJ.J*J0I,(B")
(qdv "sat"	"$AJ'J5J-JRI*O%(B")
(qdv "sau"	"$APbPeJV3p3nJUP^JWJXJ[J\JYJZJ]J^J~KQKRKTP_Pc[E],`2awoKt<(B")
(qdv "se"	"$AP4IgIdP)IaIbI6I^I_P6P:Y\wj(B")
(qdv "sei"	"$AKDK@(B")
(qdv "sek"	"$AJ/K6N}(B")
(qdv "seng"	"$APHIy(B")
(qdv "seuk"	"$AOwne(B")
(qdv "seung"	"$AK+K*O`IOILOk3#3"3%IJIKIMIPIQOaObOdOeOfadfOfWidlX(B")
(qdv "si"	"$AKAJBJGJPJ1J9J>J+J7K<J?J&JSJ(J)J,J:J;JHJKJLJOJTK9K:K;K=K>K?VEXKZV_1_PnfoHty3Wm'(B")
(qdv "sik"	"$AI+O'NvJ=O"JNJMJJJ3J4J6JCNtNzN}O$O(O1ixp*o$rat*s,(B")
(qdv "sim"	"$AIA2uI;IBf?iilx(B")
(qdv "sin"	"$AOHO_I?ICIEIFIHIIO3OIOJOYO[Q"Y~Y;k/tLs5v1(B")
(qdv "sing"	"$A3GIyJ$PJPTI}3P3I3K3OJ%J"I~J#PGPIPQPUX)nqPH(B")
(qdv "sip"	"$AIcIeIf(B")
(qdv "sit"	"$AGTI`P(P9P<Q&oF(B")
(qdv "siu"	"$AP!P&P%OzIYUWO{IUIXI[I\OtOuOvO|UXso(B")
(qdv "so"	"$AKUKXJ}I&I'I(I)KSKVK\K]K_`<vUPk(B")
(qdv "soh"	"$AKyJ_JaJhI5KrKsKtKvKx_o`Bf6tH(B")
(qdv "soi"	"$AHyHz(B")
(qdv "sok"	"$AKwK7`;`J(B")
(qdv "song"	"$AI#I$I%K,r*(B")
(qdv "sue"	"$AJiJbJdJsJ`JcJfJmJnJrJwJyJzJ|K]X-(B")
(qdv "suen"	"$AKcKaW-Ko4,KbKpK1P{P}Q!h/(B")
(qdv "suet"	"$AK5Q)(B")
(qdv "sui"	"$APkK.K0KdPh494a4b4cHpJ{KgKhKiKjKkKlKmKnK%K'K-K/PuPw]Medegqc(B")
(qdv "suk"	"$AJeK`JtJgJjJkJlJqKuKZK[K^YmY?[S^#(B")
(qdv "sun"	"$APEQ84<4=4>4?KqK2K3K4Q/Q1Q3Q4Q6Q7W;\wa_(B")
(qdv "sung"	"$AKI3gKJKKKMKNZ!aTq5(B")
(qdv "sut"	"$APtJuJvK$Pgs0(B")
(qdv "ta"	"$AK{K|K}nh(B")
(qdv "taai"	"$AL+L,4v4{L)L*L-_>nQ(B")
(qdv "taam"	"$AL8L0L5L6L7L=q{(B")
(qdv "taan"	"$AL>L/L1L2L3L4L9L;L<L?f'l~(B")
(qdv "taap"	"$AKzK~L#L.e](B")
(qdv "tai"	"$ALeLaLbm{5L5Y5^L]L`LcLdLfLgLiLjLkZPf7(B")
(qdv "tan"	"$AMLY[(B")
(qdv "tang"	"$ALZLYkx(B")
(qdv "tau"	"$AM7M5M6M8(B")
(qd "tek"	"$AL_(B")
(qdv "teng"	"$AL|M'(B")
(qdv "tik"	"$AL^LhYCl}o+(B")
(qdv "tim"	"$A5kLmLpLqLriem,wQ(B")
(qdv "tin"	"$ALl5a5hLnLoLsn1(B")
(qdv "ting"	"$AM"M#L}L~M$M%M&QQfCnzrQv*n.(B")
(qdv "tip"	"$ALyL{(B")
(qd "tit"	"$ALz(B")
(qdv "tiu"	"$ALu5wLtLwLxY,lvo"q;tPv6(B")
(qdv "to"	"$ALU_{LMM@M>MBMALWM<MC6G585;LNLOLPLQLRLSLTLVM=M?]1_6h:lbnJ(B")
(qdv "toh"	"$A6fMOMRMSMTMUMVMWMYY"c{(B")
(qdv "toi"	"$AL%L(4y5]L&L'(B")
(qdv "tok"	"$AMPMXuE(B")
(qdv "tong"	"$ALALFL@LBLCLDLELGLHLILJLKLLYNlYqmtJs+u1(B")
(qdv "tuen"	"$AME6ZMMMN(B")
(qd "tuet"	"$AMQ(B")
(qdv "tui"	"$AMHMFMGMIMJMK(B")
(qd "tuk"	"$AM:(B")
(qdv "tun"	"$A6\n6(B")
(qdv "tung"	"$AM(M,M4M3L[L\M)M*M+M-M.M/M0M1M2Y]YWYZ`LkXt>(B")
(qdv "uk"	"$AN]dW(B")
(qdv "wa"	"$AM[;);-;*;0FhM\M]M^n|(B")
(qdv "waai"	"$A;5;3;4Ma(B")
(qdv "waak"	"$A;r;-;s;.(B")
(qdv "waan"	"$AMe;9;7;<;B;CMdMgMlviMf(B")
(qd "waang"	"$A:a(B")
(qdv "waat"	"$A;+;,MZ(B")
(qdv "wai"	"$A;YN*REN=N;N'N(N,;`;d;1;[;\;]M~N$N%N&N)N+N-N.N/N0N3N5N7N8N9N<N>N?N@YK`0(B")
(qdv "wan"	"$ATFTKTONBTH;j;k;lNANHR|TETGTITJTLTMTNZ;\?ifk5(B")
(qdv "wang"	"$A:j:k(B")
(qdv "wat"	"$AG|>s(B")
(qd "wik"	"$ASr(B")
(qdv "wing"	"$AS@HSHYS1S=S>aIr#(B")
(qdv "woh"	"$A:M9x:L;vNONPNQYAf4q=(B")
(qdv "wok"	"$A;qXeol(B")
(qdv "wong"	"$AaeMy;F;G;H;I;J;K;L;MMtMuMwMz(B")
(qdv "woo"	"$ANZN[:~:|:z:w:x:y:{:};];$;%;&;'NXNYSsY|b)d0lhlop-(B")
(qdv "wooi"	"$A;X;a;c;2;W(B")
(qdv "woon"	"$AMf;;;:;8;=;>;@;AMcMkMnMsT+T.X(X`(B")
(qd "woot"	"$A;n(B")
(qd "ya"	"$AR2(B")
(qdv "yai"	"$AR7W'(B")
(qdv "yam"	"$ARtHNR{GUA^HIHQRqRuRwRy`3l'q?v/(B")
(qdv "yan"	"$AP@HK6wHLR}S!RrPFHJHPHRPCRpRsRvRzR~TPS]UgX7Xp_Ek3nwr>(B")
(qdv "yap"	"$AHkF|R>RX]0(B")
(qdv "yat"	"$AR;HUR<R]RgX}Y+oW(B")
(qdv "yau"	"$AGpGqSPSISHSVGuH`HaP]SDSESFSGSJSKSLSMSNSOSQSRSSSTSUSWY'X|_O_]i`k;nprGvOwnwx(B")
(qdv "ye"	"$AR9HGR,R.R/R0R1Y<(B")
(qdv "yeuk"	"$AT>ZJT<T;HuE0E1HtR)T?Y_(B")
(qdv "yeung"	"$AQlQyQkHAQsDpH@HBHCQjQmQnQoQpQqQrQtQuQvQwQxQza`l|m&w1p&(B")
(qdv "yi"	"$AR=RP6{6y6~RTRFRb6xReRWRlRiRIRKRjbyRQ6zDbR?R@RARBRCRDRGRHRJRLRMRNRSR^XfY&\2`f_W_^dtg2ill=noonwp(B")
(qdv "yik"	"$ARZRVRmDfR4R8R:R[R\R_R`RdRfRkRnRo^D^HfdrfRW(B")
(qdv "yim"	"$AQOQWH=H>OSQaQfQiQKQMQNQVQYQZQ^X_Y2n;(B")
(qdv "yin"	"$AOROVQTQ`H;QPQLH<OMOOOQQbQdQeQgQhQIQJQSQ]Q_YpZ]dNe{fLkYs[wzn:(B")
(qdv "ying"	"$AS"S0PNPMHOD}HTS&PLPOS#S$S%S'S(S)S*S+S,S-S.S/S3XMYx`Se-pP(B")
(qdv "yip"	"$AR6R5R3Du(B")
(qdv "yit"	"$AHHR-ZKt+(B")
(qdv "yiu"	"$AHFQ|R*R+HEQ{Q}Q~R!R"R#R%R&R(X2_:afahf,jW(B")
(qdv "yoh"	"$AS4`!(B")
(qdv "yue"	"$ASkl6SjSoSZHgShH#HcHdHeHfHiHjS`SaSbScSdSeSfSgSiSlSmSnSpSuSvSwSxSySzS~T"T#T$T%T&SXSYS[S\S]S^S_X.XqZM`if%pvo(r,q>qAt't(sDv'v9n4(B")
(qdv "yuen"	"$AT'T6T1MjT-T*QX4*HmHnG&MhMiMoMpMqP|P~OXQ#T(T)T,T/T0T2T3T4T5T7T8T9T:\>k<ngp0n5(B")
(qdv "yuet"	"$ATBQ(TAT=RRTCTD_\nFna(B")
(qdv "yui"	"$AHoHqP>Ran#(B")
(qdv "yuk"	"$ASqS}HbHhHlNVPqStS{S|T!X9ewgojEnZ(B")
(qdv "yun"	"$AHrHs(B")
(qdv "yung"	"$AS?S9o^SCSBHZH]HVHWHXH[H\H^H_NKNLS5S6S7S8S:S;S<SAY8`/g_iEp.(B")
(qdv "\\beng"	"$Ap\p]p^p_p`papcpdpepfpgphpipjpmpnpopppqprpsptpupwpypzp{p|p}p~q!q"q#q$q%q&q'q(q)q*q+q,q-q.q/q0q3(B")
(qdv "\\booi"	"$AjZj[j\j]j^j_j`jajcjdjejf(B")
(qdv "\\che"	"$Aiminioiqiritiuiviwiyizi{i|i~j!j"j#j$j&(B")
(qdv "\\chung"	"$Ar1r2r3r4r5r6r7r8r:r;r@rArBrCrDrErHrIrJrKrLrMrNrOrPrRrSrUrVrWrXrYr[r\r]r^r`rbrdrergrhrirjrmrnrorqrsrtrurvrwrxrzr{r|r}r~s]s"s#s$s%s's(s)s*s-s.s1s2s3s4s6s7s8s9s:s;s<s=(B")
(qdv "\\faat"	"$AwTwUwVwWwXwYwZw[w\w]w^w_(B")
(qdv "\\foh"	"$Al>l?l@lAlBlClDlElFlGlHlIlJlKlLlMlNlOlPlQlSlTlUlVlWlZl[l\l]l^l_l`(B")
(qdv "\\fong"	"$Al7l8l9l:l<(B")
(qdv "\\fung"	"$Al)l,l-l.(B")
(qdv "\\gaak"	"$Aw3w4w5w6w7w8w9(B")
(qdv "\\gam"	"$AnRnSnTn_nto`obofo&o*o/o2o3o6o:oAoCoDoGoJoLoRo[o\vFvGvHvIvJvKvLvM(B")
(qdv "\\gan"	"$A`x`y`z`{`|`}`~a]a"a#a$a%a&(B")
(qdv "\\gau"	"$Aalamanaoapaqarasatauavaxayaza{a|a}a~b!b"b#b$b%b&b'b(b*b+b,b-b.b/b0b1b2b3b4b5(B")
(qdv "\\gin"	"$Ajhjijjjkjljmjnjo(B")
(qdv "\\gok"	"$Auzu{u|u}u~v!v"v#(B")
(qdv "\\gwai"	"$AwIwJwKwLwMwN(B")
(qdv "\\gwoh"	"$Aj(j)j+j,j.j/(B")
(qdv "\\hau"	"$A_~`$`:`W`h`k_C_T_U_[__(B")
(qdv "\\him"	"$Al#l$l%l&l((B")
(qdv "\\jau"	"$At-t0t8tqtrtstttut{t|t}t~u]u"u#u%u&u'u(u)u*u+u,u-u.u/u0u2u3u4u5u6u7u8(B")
(qdv "\\juk"	"$Au`uaucudueufuhujukulumunuoupuqurusu;u<u=u>u?u@uAuBuCuDuFuHuIuJuLuMuNuOuPuQuRuTuUuVuWuYuZu[u\u]u^u_(B")
(qdv "\\jukfa"	"$As`sasbscsdsesfsgshsisjskslsmsnspsqsrssstsusvswsxsys{s|s}s~t!t"t#t$t%t&sGsHsIsJsKsLsMsOsPsQsSsTsUsVsWsXsYsZs\s_(B")
(qdv "\\kwat"	"$Aw`wiw:w=w>w?wAwBwDwEwFwG(B")
(qdv "\\ma"	"$Af`fafcfefffhfkflfmfnfofpfqfsftfufvfwfx(B")
(qdv "\\mo"	"$Ak#k$k%k&k'k(k)k*k+k,(B")
(qdv "\\moon"	"$AcFcGcHcIcJcKcLcMcNcOcPcQcRcScTcUcVcWcXcYc[(B")
(qdv "\\muk"	"$Ah;h<h>h?h@hBhDhEhFhGhHhIhLhNhOhPhQhRhShThUhVhWhXhYhZh[h\h]h^h_h`hahbhchdhehfhghhhihjhkhlhmhohphqhthuhvhwhxhyhzh{h|h}h~iai]i"i#i$i%i&i'i(i)i*i+i,i-i.i/i0i1i2i3i4i5i6i7mlmmmnmompmqmrmsmtmumvmwmzm|m}m~n!n"n$n%n&n(n)n*n+n,n-(B")
(qdv "\\nga"	"$Aj1j2j3j4j5j6(B")
(qdv "\\ngau"	"$Ajpjqjrjsjtjujvjwjxjyjzj{(B")
(qdv "\\niu"	"$Ap4p5p6p7p8p9p:p;p<p=p>p?p@pApBpCpEpGpHpIpJpKpMpNpOpRpSpTpUpVpW(B")
(qdv "\\nui"	"$Af#f+f1f:f<f@fAfBfDfFfGfJfKfMfPfQfSfT(B")
(qdv "\\pao"	"$Auvuwuxuy(B")
(qdv "\\saan"	"$Aa(a)a,a-a.a1a2a3a4a5a6a8a9a:a;a<a=a>aAaBaCaDaEaFaGaHaJaKaLaNaOaPaQaSaUaVaWaXaYaZ(B")
(qdv "\\sam"	"$Ababbbcbdbebfbgbhbibkblbmbnbobpbqbrbsbtbubvbwbxbzb{b}b~c]c"c#c$c%c&c'c(c)c*c+c,c-c.c/c0c1c2c3c4c6c7c8c9c:c;c<c=c>c?c@cAm"m#m$m%m'm(m)m*m+m-m.m/m0(B")
(qdv "\\sau"	"$A^Q^R^S^T^U^W^X^Y^Z^\^]^^^`^a^b^c^d^e^f^g^h^i^k^l^m^n^o^p^q^r^s^t^u^v^w^x^y^z^{^|^}^~_"_#_$_%_&_'_(_)_*_+_,_-j|j}j~k]k"(B")
(qdv "\\sek"	"$Am6m7m8m9m:m;m<m=m>m?m@mAmBmCmDmEmFmGmHmImJmKmLmMmNmOmPmQmRmSmTmUmVmWmXmYmZm[m\m]m^m_m`mambmcmdmemfmg(B")
(qdv "\\si"	"$Afzf|f}f~g]g"g#g$g%g&g'g(g)g*g+g,g-g.g/g0g1g3g4g5g6g7g8g9g:g;g<g=g>g?g@gAgBgCgDgEgFgGgHgIgJgKgLgMgNgOgPgQgRgSgTgUgVgWgXgYgZ(B")
(qdv "\\sik"	"$AwOwPwSb<b=b>b?b@bAbBbCbDbEbFbGbHbIbJbKbLbMbN(B")
(qdv "\\teng"	"$Ae`eaeBeCeDeEeFeGeHeIeJeLeMeNeOePeQeReTeUeVeWeXeYe[e\e^(B")
(qdv "\\to"	"$A[a[b[c[d[e[f[g[h[i[j[k[l[m[n[o[p[q[r[s[t[u[v[w[x[y[z[{[|[}[~\!\"\#\$\%\&\'\(\)\*\+\,\-\.\/\1[P[R[T[U[W[X[Y[[[\[][^[_(B")
(qdv "\\wai"	"$A`n`o`p`q`r`s`t`u`v`w(B")
(qdv "\\woh"	"$Aouovowoxoyozo{o|o}o~p!p"p#(B")
(qdv "\\wong"	"$Ag`gagbgcgdgfghgigkglgmgngpgqgrgsgugvgxgygzg{g|g}g~h!h"h#h$h%h'h(h)h*h+h,h-h.h/h0h1h2h3h4h6(B")
(qdv "\\yan"	"$AY#Y6YHYX(B")
(qdv "\\yat"	"$Aj8j9j:j<j=j>j?j@jAjBjCjFjGjHjIjJjKjNjOjPjQjRjTjUjVjY(B")
(qdv "\\yi"	"$AqCqDqEqFqGqHqIqJqKqLqMqNqOqPqQqRqSqTqUqVqWqXqYqZq[q]q^q_q`qaZcZgZhZiZjZkZlZmZnZo(B")
(qdv "\\yideuh"	"$AZpZqZrZsZtZuZvZwZxZyZzZ{Z|Z}Z~["[#[$[%[&['[([)[*[+[,[-[.[/[0[1[2[3[4[5[7[8[9[:(B")
(qdv "\\yin"	"$AZ&Z'Z(Z)Z*Z,Z-Z.Z0Z1Z2Z3Z4Z5Z7Z8Z9Z:Z=Z?Z@ZAZBZCZDZFZGZHZNZRZSZTZUZYZ[(B")
(qdv "\\yue"	"$AvPvQvRvSvVvXvYvZv[v\v]v^v_vavbvcvdvevfvgvkvmvnvovpvqvrvsvtvuvvvwvxvyvzv{v|v}v~w]w#w$w%w&w'w(w*w+w,w-w.w/(B")
(qdv "\\yuk"	"$Al"k`kakbkckdkekfkgkikjkkkmkokpkqkrksktkvkykzk{k~l!k>k?k@kBkCkDkEkFkGkIkKkLkMkOkQkRkSkTkUkVkWk[k\k]k^k_(B")

(quail-setup-current-package)
