package SYS::grent;

@ISA    = qw(Exporter);
@EXPORT = qw(getgrent getgrnam getgrgid);

use Carp;
use Struct;

struct SYS::grent qw{
     name passwd gid members
};

sub getgrnam {
    confess "usage: getgrnam(gname)" if @_ != 1;
    my $name = $_[0];
    my @fields = CORE::getgrnam($name);
    return @fields
	? new SYS::grent @fields
	: undef;
} 

sub getgrgid {
    confess "usage: getgrgid(gid)" if @_ != 1;
    my $uid = $_[0];
    my @fields = CORE::getgrgid($uid);
    return @fields
	? new SYS::grent @fields
	: undef;
} 

sub getgrent {
    confess "usage: getgrent()" if @_ != 0;
    my @fields = CORE::getgrent();
    return @fields
	? new SYS::grent @fields
	: undef;
} 

sub new {
    confess "usage: new list" if @_ == 0;
    my $class = shift;
    # these are created so they can be imported
    ($name, $passwd, $gid, @members) = @_;
    if (@members == 1) {
	@members = (split ' ', $members[0]);
    } 
    $members = [ @members ];
    return bless [ $name, $passwd, $gid, $members ];
} 

1;
