package SYS::hostent;

use Socket qw(AF_UNIX);

@ISA    = qw(Exporter);
@EXPORT = qw(gethostbyname gethostbyaddr);

use Carp;
use Struct;

use subs 'new';

struct SYS::hostent qw{
    name aliases addrtype length addrs
};

sub gethostbyname {
    croak "usage: gethostbyname(hostname)" if @_ != 1;
    my $name = $_[0];
    my @fields = CORE::gethostbyname($name);
    return @fields 
	? new SYS::hostent @fields
	: undef
} 

sub gethostbyaddr {
    confess "usage: gethostbyaddr(hostaddr, [addrtype])" if @_ < 0 || @_ > 2;
    my $addr = $_[0];
    my $addrtype = $_[1] || AF_INET;
    if ($addr =~ /^[\d.]+$/) {
	my @parts = split(/\./, $addr);
	splice(@parts, $#parts, 0, (0) x (4-@parts));  # inet_addr conversion
	$addr = pack('C4', @parts);
    } elsif (length($addr) != 4) {
	croak "gethostbyaddr: invalid address";
    } 
    my @fields = CORE::gethostbyaddr($addr,$addrtype);
    return @fields 
	? new SYS::hostent @fields
	: undef
} 

sub new {
    confess "usage: new list" if @_ == 0;
    my $class = shift @_;
    # these can be imported
    ($name, $aliases, $addrtype, $length, @addrs) = @_;
    $aliases = [ split ' ', $aliases ];
    $addrs = [ @addrs ];
    return bless [ 
	$name,  $aliases,
	$addrtype, $length, $addrs 
    ];
} 

1;
