package SYS::localtime;

require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(localtime ctime);

use Carp;
use Struct;

struct SYS::localtime qw{
   sec min hour 
   mday mon year 
   wday yday isdst
};

sub localtime {
    croak "usage: new SYS::localtime time" if @_ > 1;
    my $timethen = $_[0];
    my @fields = CORE::localtime $timethen;
    return @fields
    	? new SYS::localtime @fields
	: undef;
} 

sub ctime {
    croak "usage: new SYS::ctime time" if @_ > 1;
    my $timethen = $_[0];
    $timethen = CORE::time unless defined $timethen;
    return scalar CORE::localtime $timethen;
} 

sub new { 
    croak "usage: new SYS::localtime time" if @_ == 0;
    my $class = shift;
    # these can be imported
    ($sec,$min,$hour,$mday,$mon,
	$year,$wday,$yday,$isdst) = @_;
    return bless [ @_ ];
};

1;
