package SYS::mntent;

use Carp;
use Struct;

require Exporter;
@ISA = qw(Exporter Struct);
@EXPORT = qw(getmntent setmntent endmntent addmntent);

$IMA = ref bless [];

################

$MTAB = "/etc/mtab";

struct SYS::mntent qw{
    fsname dir type opts freq passno
};

sub setmntent {
    if (@_ == 2) {
	carp "setmntent: 2nd argument ignored"
    } elsif (@_ != 1) {
	croak "usage: setmntent filename";
    } 
    $filename = $_[0];

    if (defined fileno($MTAB)) {
	close $MTAB 		|| carp "can't close $filename: $!";
    } 
    open ($MTAB, $filename) 	|| croak "can't open $filename: $!";
} 

sub endmntent {
    if (@_) {
	croak "usage: endmntent";
    } 
    if (defined fileno($MTAB)) {
	close $MTAB 		|| carp "can't close $filename: $!";
    } else {
	carp "endmntent called on mount table table";
    } 
} 

sub getmntent {
    setmntent($MTAB) unless defined fileno($MTAB);
    local $_ = <$MTAB>;
    $_ and bless [ split ];
} 

sub addmntent {
    croak "addmntent unimplemented";
} 

sub hasmntopt {
    if (@_ != 2) {
	croak "usage: hasmntopt mntent option";
    } 
    my($mntent, $opt) = @_;
    if (ref $mntent ne $IMA) {
	carp "hasmntopt: arg #1 not of type $IMA";
    } 
    $mntent->opts =~ /\b\Q$opt\E(=[^,]+)?\b/;
} 

1;
