package SYS::pwent;

@ISA    = qw(Exporter);
@EXPORT = qw(getpwent getpwnam getpwuid);

use Carp;
use Struct;

struct SYS::pwent qw{
    name passwd 
    uid gid 
    quota comment gcos 
    dir shell
};

sub getpwnam {
    croak "usage: getpwent id" if @_ != 1;
    my $name = $_[0];
    my @fields = CORE::getpwnam($name);
    return @fields
    	? new SYS::pwent @fields
	: undef;
} 

sub getpwuid {
    croak "usage: getpwent id" if @_ != 1;
    my $uid = $_[0];
    my @fields = CORE::getpwuid($uid);
    return @fields
    	? new SYS::pwent @fields
	: undef;
} 

sub getpwent {
    croak "usage: getpwent" if @_ != 0;
    my @fields = CORE::getpwent();
    return @fields
    	? new SYS::pwent @fields
	: undef;
} 

sub new {
    croak "usage: pwent::new list" if @_ == 0;
    my $class = shift;
    # these are created so they can be imported
    ($name, $passwd, $uid, $gid, $quota, $comment, $gcos, $dir, $shell) 
	= @_;
    bless [ @_ ];
};

1;
