package SYS::servent;

@ISA    = qw(Exporter);
@EXPORT = qw(getservbyname getservbyport getservent);

use Carp;
use Struct;

struct SYS::servent qw{
   name aliases port proto
};

sub getservbyname {
    croak "usage: getservbyname name proto" if @_ == 0 || @_ > 2;
    my $name  = $_[0];
    my $proto = $_[1] || "tcp";
    my @fields = CORE::getservbyname($name, $proto);
    return @fields
    	? new SYS::servent @fields
	: undef;
} 

sub getservbyport {
    croak "usage: getservbyport name proto" if @_ == 0 || @_ > 2;
    my $num = $_[0];
    my $proto = $_[1] || "tcp";
    my @fields = CORE::getservbyport($num,$proto);
    return @fields
    	? new SYS::servent @fields
	: undef;
} 

sub getservent {
    croak "usage: getservent" if @_ != 0;
    my @fields = CORE::getservent();
    return @fields
    	? new SYS::serv @fields
	: undef;
} 

sub new {
    croak "usage: servent->new list" if @_ == 0;
    my $class = shift;
    # these are created so they can be imported
    ($name, $aliases, $port, $proto) = @_;
    $aliases = [ split(' ', $aliases) ];
    bless [ $name, $aliases, $port, proto ];
};

1;
