package SYS::statfs;

@ISA		= qw(Exporter);
@EXPORT		= qw(statfs fstatfs);
@EXPORT_OK	= qw($spare $fsid);  # the struct call will append to this!!

use Carp;
use Struct;

struct SYS::statfs qw{
    type bsize blocks bfree bavail files ffree 
    fsid0 fsid1
    spare0 spare1 spare2 spare3 spare4 spare5 spare6 spare7 
};

$fieldno  = 1 + keys %fieldno;  # struct() made my %SYS::statfs::fieldno map!!
$template = "L" x $fieldno;
$buff     = " " x (length(pack("L",1)) * $fieldno);

require Grope_C_Includes;
Grope_C_Includes::fetch_symbols("sys/syscall.h", qw(SYS_statfs SYS_fstatfs));

#################################################################

sub fsid {
    my $self = $_[0];
    my @fsid = ( $self->fsid0, $self->fsid1 );
    return wantarray ? @fsid : \@fsid;
} 

sub spare {
    my $self = $_[0];
    my @spare = @{$self}[ $fieldno{"spare0"} .. $fieldno{"spare7"} ];
    return wantarray ? @spare : \@spare;
} 

sub statfs {
    my $path = $_[0];
    sub SYS_statfs;
    my $rv = syscall(SYS_statfs, $path, $buff);
    if ($rv == -1) { return undef }; 
    return new SYS::statfs unpack($template, $buff);
}

sub fstatfs {
    my $maybe_fd  = $_[0];
    my $fd;
    if ($maybe_fd >= 0 && $maybe_fd < 500) {
	$fd = $maybe_fd;
    } elsif (!defined ($fd = fileno($maybe_fd))) {
	croak"doesn't seem like a valid file descriptor: $maybe_fd";
    } 
    sub SYS_fstatfs;
    my $rv = syscall(SYS_fstatfs, $fd, $buff);
    if ($rv == -1) { return undef }; 
    my $ap = bless [];
    return new SYS::statfs unpack($template, $buff);
}

sub new {
    croak "usage: new SYS::statfs list" if @_ == 0;
    my $class = shift;

    # these are made so they can be imported
    ($type, $bsize, $blocks, $bfree, $bavail, $files, $ffree, 
     $fsid0, $fsid1, 
     $spare0, $spare1, $spare2, $spare3, 
     $spare4, $spare5, $spare6, $spare7) = @_;

    my $sp = bless [ @_ ];
    $spare = $sp->spare;
    $fsid = $sp->fsid;
    return $sp;
} 

1;
