package Struct;

require Exporter;

@ISA = qw(Exporter);
@EXPORT = qw(struct);

use Carp;

no strict 'refs'; # no kidding

sub struct {
    unless (@_ > 1) {
	confess "usage: struct name, field1, field2, ... \n";
    } 
    my($structname, @fields) = @_;
    #if (defined %{"main::${structname}::"}) {
	#carp "Warning: package $structname non empty!";
    #} else {
	#carp "Cool: package $structname plenty empty!";
    #} 

    if (defined %{"${structname}::fieldno"}) {
	carp "Warning: redefining struct $structname!";
    } 
    my $fieldno = 0;
    for $field ( @fields ) {
	eval qq{
	    sub ${structname}::$field { 
		my \$self = \$_[0];
		if ( ref \$self ne '$structname' ) { 
		    croak "type for $field method should be $structname, not " .
			ref \$self;
		} 
		\$self->[$fieldno];
	    }
	};
	die "eval died $@" if $@;
	${$structname . '::fieldno'}{$field} = $fieldno;
	$fieldno++;
    }
    push(@{$structname . '::ISA'}, 'Struct');
    for (@fields) { s/^/\$/ }
    push (@{$structname . '::EXPORT_OK'}, @fields);
    #print "export_ok'ing @fields from $structname\n";

    # $structname->new();  # don't bother returning one
} 

sub _fieldnos { 
    my $self = $_[0];
    my $type = ref($self) || $self;
    \%{"${type}::fieldno"};
}

sub new {
    my $self = $_[0];
    my $type = ref($self) || $self;
    bless [], $type;
} 

sub import_fields {
    my $self = $_[0];
    my $callpack = (caller)[0];
    #for $field ( keys %{$self->_fieldnos} ) {
    while (($name, $number) = each %{$self->_fieldnos} ) {
	#print "exporting field $name into $callpack, value is $self->[$number]\n"; 
	${"${callpack}::$name"} = $self->[$number];
    } 

} 

1;
