'\"
'\" Copyright (c) 1995-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" SCCS: @(#) interp.n 1.23 96/08/21 10:02:02
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  If an argument is present, then a line break is
'\"	forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" SCCS: @(#) man.macros 1.8 96/02/15 20:02:24
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$1"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH interp n 7.5 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
interp \- Create and manipulate Tcl interpreters
.SH SYNOPSIS
\fBinterp \fIoption \fR?\fIarg arg ...\fR?
.BE
.SH DESCRIPTION
.PP
This command makes it possible to create one or more new Tcl 
interpreters that co-exist with the creating interpreter in the
same application.  The creating interpreter is called the \fImaster\fR
and the new interpreter is called a \fIslave\fR. 
A master can create any number of slaves, and each slave can
itself create additional slaves for which it is master, resulting
in a hierarchy of interpreters.
.PP
Each interpreter is independent from the others: it has its own name
space for commands, procedures, and global variables.
A master interpreter may create connections between its slaves and
itself using a mechanism called an \fIalias\fR.  An \fIalias\fR is
a command in a slave interpreter which, when invoked, causes a
command to be invoked in its master interpreter or in another slave
interpreter.  The only other connections between interpreters are
through environment variables (the \fBenv\fR variable), which are
normally shared among all interpreters in the application. Note that the
name space for files (such as the names returned by the \fBopen\fR command)
is no longer shared between interpreters. Explicit commands are provided to
share files and to transfer references to open files from one interpreter
to another.
.PP
The \fBinterp\fR command also provides support for \fIsafe\fR
interpreters.  A safe interpreter is a slave whose functions have
been greatly restricted, so that it is safe to execute untrusted
scripts without fear of them damaging other interpreters or the
application's environment. For example, all IO channel creation
commands and subprocess creation commands are removed from safe interpreters.
See SAFE INTERPRETERS below for more information on what features
are present in a safe interpreter.  The alias mechanism can be
used for protected communication (analogous to a kernel call)
between a slave interpreter and its master.
.PP
A qualified interpreter name is a proper Tcl lists containing a subset of its
ancestors in the interpreter hierarchy, terminated by the string naming the
interpreter in its immediate master. Interpreter names are relative to the
interpreter in which they are used. For example, if \fIa\fR is a slave of
the current interpreter and it has a slave \fIa1\fR, which in turn has a
slave \fIa11\fR, the qualified name of \fIa11\fR in \fIa\fR is the list
\fI{a1 a11}\fR.
.PP
The \fBinterp\fR command, described below, accepts qualified interpreter
names as arguments; the interpreter in which the command is being evaluated
can always be referred to as \fI{}\fR (the empty list or string). Note that
it is impossible to refer to a master (ancestor) interpreter by name in a
slave interpreter except through aliases. Also, there is no global name by
which one can refer to the first interpreter created in an application.
Both restrictions are motivated by safety concerns.
.PP
The \fBinterp\fR command is used to create, delete, and manipulate
slave interpreters, and to share or transfer
channels between interpreters.  It can have any of several forms, depending
on the \fIoption\fR argument:
.TP
\fBinterp \fBalias \fIsrcPath \fIsrcCmd\fR
Returns a Tcl list whose elements are the \fItargetCmd\fR and
\fIarg\fRs associated with the alias named \fIsrcCmd\fR
(all of these are the values specified when the alias was
created; it is possible that the actual source command in the
slave is different from \fIsrcCmd\fR if it was renamed).
.TP
\fBinterp \fBalias \fIsrcPath \fIsrcCmd\fR \fB{}\fR
Deletes the alias for \fIsrcCmd\fR in the slave interpreter identified by
\fIsrcPath\fR.
\fIsrcCmd\fR refers to the name under which the alias
was created;  if the source command has been renamed, the renamed
command will be deleted.
.TP
\fBinterp \fBalias \fIsrcPath \fIsrcCmd\fR \fItargetPath \fItargetCmd \fR?\fIarg arg ...\fR?
This command creates an alias between one slave and another (see the
\fBalias\fR slave command below for creating aliases between a slave
and its master).  In this command, either of the slave interpreters
may be anywhere in the hierarchy of interpreters under the interpreter
invoking the command.
\fISrcPath\fR and \fIsrcCmd\fR identify the source of the alias.
\fISrcPath\fR is a Tcl list whose elements select a particular
interpreter.  For example, ``\fBa b\fR'' identifies an interpreter
\fBb\fR, which is a slave of interpreter \fBa\fR, which is a slave
of the invoking interpreter.  An empty list specifies the interpreter
invoking the command.  \fIsrcCmd\fR gives the name of a new
command, which will be created in the source interpreter.
\fITargetPath\fR and \fItargetCmd\fR specify a target interpreter
and command, and the \fIarg\fR arguments, if any, specify additional
arguments to \fItargetCmd\fR which are prepended to any arguments specified
in the invocation of \fIsrcCmd\fR.
\fITargetCmd\fR may be undefined at the time of this call, or it may
already exist; it is not created by this command.
The alias arranges for the given target command to be invoked
in the target interpreter whenever the given source command is
invoked in the source interpreter.  See ALIAS INVOCATION below for
more details.
.TP
\fBinterp \fBaliases \fR?\fIpath\fR?
This command returns a Tcl list of the names of all the source commands for
aliases defined in the interpreter identified by \fIpath\fR.
.TP
\fBinterp \fBcreate \fR?\fB\-safe\fR? ?\fB\-\|\-\fR? ?\fIpath\fR?
Creates a slave interpreter identified by \fIpath\fR and a new command,
called a \fIslave command\fR. The name of the slave command is the last
component of \fIpath\fR. The new slave interpreter and the slave command
are created in the interpreter identified by the path obtained by removing
the last component from \fIpath\fR. For example, if \fIpath is ``\fBa b
c\fR'' then a new slave interpreter and slave command named ``\fBc\fR'' are
created in the interpreter identified by the path ``\fBa b\fR''.
The slave command may be used to manipulate the new interpreter as
described below. If \fIpath\fR is omitted, Tcl creates a unique name of the
form \fBinterp\fIx\fR, where \fIx\fR is an integer, and uses it for the
interpreter and the slave command. If the \fB\-safe\fR switch is specified
(or if the master interpreter is a safe interpreter), the new slave
interpreter will be created as a safe interpreter with limited
functionality; otherwise the slave will include the full set of Tcl
built-in commands and variables. The \fB\-\|\-\fR switch can be used to
mark the end of switches;  it may be needed if \fIpath\fR is an unusual
value such as \fB\-safe\fR. The result of the command is the name of the
new interpreter. The name of a slave interpreter must be unique among all
the slaves for its master;  an error occurs if a slave interpreter by the
given name already exists in this master.
.TP
\fBinterp \fBdelete \fR?\fIpath ...?\fR
Deletes zero or more interpreters given by the optional \fIpath\fR
arguments, and for each interpreter, it also deletes its slaves. The
command also deletes the slave command for each interpreter deleted.
For each \fIpath\fR argument, if no interpreter by that name
exists, the command raises an error.
.TP
\fBinterp \fBeval \fIpath arg \fR?\fIarg ...\fR?
This command concatenates all of the \fIarg\fR arguments in the same
fashion as the \fBconcat\fR command, then evaluates the resulting string as
a Tcl script in the slave interpreter identified by \fIpath\fR. The result
of this evaluation (including error information such as the \fBerrorInfo\fR
and \fBerrorCode\fR variables, if an error occurs) is returned to the
invoking interpreter.
.TP
\fBinterp \fBexists \fIpath\fR
Returns  \fB1\fR if a slave interpreter by the specified \fIpath\fR
exists in this master, \fB0\fR otherwise. If \fIpath\fR is omitted, the
invoking interpreter is used.
.TP
\fBinterp \fBissafe\fR ?\fIpath\fR?
Returns \fB1\fR if the interpreter identified by the specified \fIpath\fR
is safe, \fB0\fR otherwise.
.TP
\fBinterp \fBshare\fR \fIsrcPath channelId destPath\fR
Causes the IO channel identified by \fIchannelId\fR to become shared
between the interpreter identified by \fIsrcPath\fR and the interpreter
identified by \fIdestPath\fR. Both interpreters have the same permissions
on the IO channel.
Both interpreters must close it to close the underlying IO channel; IO
channels accessible in an interpreter are automatically closed when an
interpreter is destroyed.
.TP
\fBinterp \fBslaves\fR ?\fIpath\fR?
Returns a Tcl list of the names of all the slave interpreters associated
with the interpreter identified by \fIpath\fR. If \fIpath\fR is omitted,
the invoking interpreter is used.
.TP
\fBinterp \fBtarget \fIpath alias\fR
Returns a Tcl list describing the target interpreter for an alias. The
alias is specified with an interpreter path and source command name, just
as in \fBinterp alias\fR above. The name of the target interpreter is
returned as an interpreter path, relative to the invoking interpreter.
If the target interpreter for the alias is the invoking interpreter then an
empty list is returned. If the target interpreter for the alias is not the
invoking interpreter or one of its descendants then an error is generated.
The target command does not have to be defined at the time of this invocation.
.TP
\fBinterp \fBtransfer\fR \fIsrcPath channelId destPath\fR
Causes the IO channel identified by \fIchannelId\fR to become available in
the interpreter identified by \fIdestPath\fR and unavailable in the
interpreter identified by \fIsrcPath\fR.
.SH "SLAVE COMMAND"
.PP
For each slave interpreter created with the \fBinterp\fR command, a
new Tcl command is created in the master interpreter with the same
name as the new interpreter. This command may be used to invoke
various operations on the interpreter.  It has the following
general form:
.CS
\fIslave command \fR?\fIarg arg ...\fR?
.CE
\fISlave\fR is the name of the interpreter, and \fIcommand\fR
and the \fIarg\fRs determine the exact behavior of the command.
The valid forms of this command are:
.TP
\fIslave \fBaliases\fR
Returns a Tcl list whose elements are the names of all the
aliases in \fIslave\fR.  The names returned are the \fIsrcCmd\fR
values used when the aliases were created (which may not be the same
as the current names of the commands, if they have been
renamed).
.TP
\fIslave \fBalias \fIsrcCmd\fR
Returns a Tcl list whose elements are the \fItargetCmd\fR and
\fIarg\fRs associated with the alias named \fIsrcCmd\fR
(all of these are the values specified when the alias was
created; it is possible that the actual source command in the
slave is different from \fIsrcCmd\fR if it was renamed).
.TP
\fIslave \fBalias \fIsrcCmd \fB{}\fR
Deletes the alias for \fIsrcCmd\fR in the slave interpreter.
\fIsrcCmd\fR refers to the name under which the alias
was created;  if the source command has been renamed, the renamed
command will be deleted.
.TP
\fIslave \fBalias \fIsrcCmd targetCmd \fR?\fIarg ..\fR?
Creates an alias such that whenever \fIsrcCmd\fR is invoked
in \fIslave\fR, \fItargetCmd\fR is invoked in the master.
The \fIarg\fR arguments will be passed to \fItargetCmd\fR as additional
arguments, prepended before any arguments passed in the invocation of
\fIsrcCmd\fR.
See ALIAS INVOCATION below for details.
.TP
\fIslave \fBeval \fIarg \fR?\fIarg ..\fR?
This command concatenates all of the \fIarg\fR arguments in
the same fashion as the \fBconcat\fR command, then evaluates
the resulting string as a Tcl script in \fIslave\fR.
The result of this evaluation (including error information
such as the \fBerrorInfo\fR and \fBerrorCode\fR variables, if an
error occurs) is returned to the invoking interpreter.
.TP
\fIslave \fBissafe\fR
Returns  \fB1\fR if the slave interpreter is safe, \fB0\fR otherwise.

.SH "ALIAS INVOCATION"
.PP
The alias mechanism has been carefully designed so that it can
be used safely when an untrusted script is executing
in a safe slave and the target of the alias is a trusted
master.  The most important thing in guaranteeing safety is to
ensure that information passed from the slave to the master is
never evaluated or substituted in the master;  if this were to
occur, it would enable an evil script in the slave to invoke
arbitrary functions in the master, which would compromise security.
.PP
When the source for an alias is invoked in the slave interpreter, the
usual Tcl substitutions are performed when parsing that command.
These substitutions are carried out in the source interpreter just
as they would be for any other command invoked in that interpreter.
The command procedure for the source command takes its arguments
and merges them with the \fItargetCmd\fR and \fIarg\fRs for the
alias to create a new array of arguments.  If the words
of \fIsrcCmd\fR were ``\fIsrcCmd arg1 arg2 ... argN\fR'',
the new set of words will be
``\fItargetCmd arg arg ... arg arg1 arg2 ... argN\fR'',
where \fItargetCmd\fR and \fIarg\fRs are the values supplied when the
alias was created.  \fITargetCmd\fR is then used to locate a command
procedure in the target interpreter, and that command procedure
is invoked with the new set of arguments.  An error occurs if
there is no command named \fItargetCmd\fR in the target interpreter.
No additional substitutions are performed on the words:  the
target command procedure is invoked directly, without
going through the normal Tcl evaluation mechanism.
Substitutions are thus performed on each word exactly once:
\fItargetCmd\fR and \fIargs\fR were substituted when parsing the command
that created the alias, and \fIarg1 - argN\fR are substituted when
the alias's source command is parsed in the source interpreter.
.PP
When writing the \fItargetCmd\fRs for aliases in safe interpreters,
it is very important that the arguments to that command never be
evaluated or substituted, since this would provide an escape
mechanism whereby the slave interpreter could execute arbitrary
code in the master.  This in turn would compromise the security
of the system.

.SH "SAFE INTERPRETERS"
.PP
A safe interpreter is one with restricted functionality, so that
is safe to execute an arbitrary script from your worst enemy without
fear of that script damaging the enclosing application or the rest
of your computing environment.  In order to make an interpreter
safe, certain commands and variables are removed from the interpreter.
For example, commands to create files on disk are removed, and the
\fBexec\fR command is removed, since it could be used to cause damage
through subprocesses.
Limited access to these facilities can be provided, by creating
aliases to the master interpreter which check their arguments carefully
and provide restricted access to a safe subset of facilities.
For example, file creation might be allowed in a particular subdirectory
and subprocess invocation might be allowed for a carefully selected and
fixed set of programs.
.PP
A safe interpreter is created by specifying the \fB\-safe\fR switch
to the \fBinterp create\fR command.  Furthermore, any slave created
by a safe interpreter will also be safe.
.PP
A safe interpreter is created with exactly the following set of
built-in commands:
.DS
.ta 1.2i 2.4i 3.6i
\fBafter	append	array	break
case	catch	clock	close
concat	continue	eof	error
eval	expr	fblocked	fileevent
flush	for	foreach	format
gets	global	history	if
incr	info	interp	join
lappend	lindex	linsert	list
llength	lower	lrange	lreplace
lsearch	lsort	package	pid
proc	puts	read	rename
return	scan	seek	set
split	string	subst	switch
tell	trace	unset	update
uplevel	upvar	vwait	while\fR
.DE
All commands not on this list are removed by \fBinterp create\fR when it
creates a safe interpreter.
These commands can be recreated later as Tcl procedures or aliases.
.PP
In addition, the \fBenv\fR variable is not present in a safe interpreter,
so it cannot share environment variables with other interpreters. The
\fBenv\fR variable poses a security risk, because users can store
sensitive information in an environment variable. For example, the PGP
manual recommends storing the PGP private key protection password in
the environment variable \fIPGPPASS\fR. Making this variable available
to untrusted code executing in a safe interpreter would incur a
security risk.
.PP
If extensions are loaded into a safe interpreter, they may also restrict
their own functionality to eliminate unsafe commands. For a discussion of
management of extensions for safety see the manual entries for the
\fBpackage\fR and \fBload\fR Tcl commands.
.SH CREDITS
.PP
This mechanism is based on the Safe-Tcl prototype implemented
by Nathaniel Borenstein and Marshall Rose.

.SH "SEE ALSO"
load(n), package(n) Tcl_CreateSlave(3)

.SH KEYWORDS
alias, master interpreter, safe interpreter, slave interpreter
