#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <netinet/in.h>
#include <sys/syslog.h>
#include <arpa/nameser.h>
#include "ns.h"
#include "db.h"
#define ITEMS_TO_SHUFFLE 16 /* arbitrary -- can make it higher */

shuffle_rrs(cp, count, eom)
register u_char *cp;
int count;
u_char *eom;
{
	register int i, j, c;
	int type, class, dlen, n, A_recs = 0;
	struct in_addr inaddr[ITEMS_TO_SHUFFLE];
	u_char *rr[ITEMS_TO_SHUFFLE];

#ifdef DEBUG
	if (debug > 2) 
		fprintf(ddt,"shuffle_rrs(0x%x, %d)\n", cp, count);
#endif DEBUG
	if (count == 1) 
		return;		/* nothing to randomize */
	if (count > ITEMS_TO_SHUFFLE) {
#ifdef DEBUG
		if (debug > 2) 
			fprintf(ddt, "Too many records to shuffle\n");
		return;
	}
#endif DEBUG

	/* gather up the A records */
	for (c = count, i = 0; c > 0; --c, i++) {
		n = dn_skipname(cp, eom);
		if (n < 0) return;		/* bogus, stop processing */
	    	cp += n;
	    	if (cp + QFIXEDSZ > eom) return;
	    	GETSHORT(type, cp);
		if (type != T_A)
			continue;
	    	GETSHORT(class, cp);
	    	cp += sizeof(u_long);
	    	GETSHORT(dlen, cp);
	    	if (dlen > eom - cp) return;	/* bogus, stop processing */
		rr[i] = cp;
		bcopy(cp, (char *) &(inaddr[i]), sizeof(struct in_addr));
		cp += dlen;
		A_recs++;
	}
	if (A_recs < 2)
		return;

	/* shuffle up the addresses */
	if ((c = rand() % A_recs) == 0)
		return;
	for (i = 0, j = A_recs; j > 0; j--, i++) {
		bcopy((char *) &(inaddr[c]), rr[i], sizeof(struct in_addr));
		if (++c == A_recs) 
			c = 0;
	}
	return;
}
