<!--
 - Copyright (C) Internet Systems Consortium, Inc. ("ISC")
 -
 - Permission to use, copy, modify, and/or distribute this software for any
 - purpose with or without fee is hereby granted, provided that the above
 - copyright notice and this permission notice appear in all copies.
 -
 - THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
 - REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 - AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
 - INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 - LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 - OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 - PERFORMANCE OF THIS SOFTWARE.
-->
### Functional enhancements from prior major releases of BIND 9

#### BIND 9.8.0

BIND 9.8.0 includes a number of changes from BIND 9.7 and earlier
releases.  New features include:

- Built-in trust anchor for the root zone, which can be
  switched on via "dnssec-validation auto;"
- Support for DNS64.
- Support for response policy zones (RPZ).
- Support for writable DLZ zones.
- Improved ease of configuration of GSS/TSIG for
  interoperability with Active Directory
- Support for GOST signing algorithm for DNSSEC.
- Removed RTT Banding from server selection algorithm.
- New "static-stub" zone type.
- Allow configuration of resolver timeouts via
  "resolver-query-timeout" option.
- The DLZ "dlopen" driver is now built by default.
- Added a new include file with function typedefs
  for the DLZ "dlopen" driver.
- Made "--with-gssapi" default.
- More verbose error reporting from DLZ LDAP.

#### BIND 9.7.0

BIND 9.7.0 includes a number of changes from BIND 9.6 and earlier
releases.  Most are intended to simplify DNSSEC configuration.
New features include:

- Fully automatic signing of zones by "named".
- Simplified configuration of DNSSEC Lookaside Validation (DLV).
- Simplified configuration of Dynamic DNS, using the "ddns-confgen"
  command line tool or the "local" update-policy option.  (As a side
  effect, this also makes it easier to configure automatic zone
  re-signing.)
- New named option "attach-cache" that allows multiple views to
  share a single cache.
- DNS rebinding attack prevention.
- New default values for dnssec-keygen parameters.
- Support for RFC 5011 automated trust anchor maintenance
- Smart signing: simplified tools for zone signing and key
  maintenance.
- The "statistics-channels" option is now available on Windows.
- A new DNSSEC-aware libdns API for use by non-BIND9 applications
- On some platforms, named and other binaries can now print out
  a stack backtrace on assertion failure, to aid in debugging.
- A "tools only" installation mode on Windows, which only installs
  dig, host, nslookup and nsupdate.
- Improved PKCS#11 support, including Keyper support and explicit
  OpenSSL engine selection.

#### BIND 9.6.0

- Full NSEC3 support
- Automatic zone re-signing
- New update-policy methods tcp-self and 6to4-self
- The BIND 8 resolver library, libbind, has been removed from the BIND 9
  distribution and is now available as a separate download.
- Change the default pid file location from /var/run to
  /var/run/{named,lwresd} for improved chroot/setuid support.

#### BIND 9.5.0

- GSS-TSIG support (RFC 3645).
- DHCID support.
- Experimental http server and statistics support for named via xml.
- More detailed statistics counters including those supported in BIND 8.
- Faster ACL processing.
- Use Doxygen to generate internal documentation.
- Efficient LRU cache-cleaning mechanism.
- NSID support.

BIND 9.4.0

- Implemented "additional section caching (or acache)", an internal cache
  framework for additional section content to improve response performance.
  Several configuration options were provided to control the behavior.
- New notify type 'master-only'.  Enable notify for master zones only.
- Accept 'notify-source' style syntax for query-source.
- rndc now allows addresses to be set in the server clauses.
- New option "allow-query-cache".  This lets "allow-query" be used to
  specify the default zone access level rather than having to have every
  zone override the global value.  "allow-query-cache" can be set at both
  the options and view levels.  If "allow-query-cache" is not set then
  "allow-recursion" is used if set, otherwise "allow-query" is used if set
  unless "recursion no;" is set in which case "none;" is used, otherwise
  the default (localhost; localnets;) is used.
- rndc: the source address can now be specified.
- ixfr-from-differences now takes master and slave in addition to yes and
  no at the options and view levels.
- Allow the journal's name to be changed via named.conf.
- 'rndc notify zone [class [view]]' resend the NOTIFY messages for the
  specified zone.
- 'dig +trace' now randomly selects the next servers to try.  Report if
  there is a bad delegation.
- Improve check-names error messages.
- Make public the function to read a key file, dst_key_read_public().
- dig now returns the byte count for axfr/ixfr.
- allow-update is now settable at the options / view level.
- named-checkconf now checks the logging configuration.
- host now can turn on memory debugging flags with '-m'.
- Don't send notify messages to self.
- Perform sanity checks on NS records which refer to 'in zone' names.
- New zone option "notify-delay".  Specify a minimum delay between sets of
  NOTIFY messages.
- Extend adjusting TTL warning messages.
- Named and named-checkzone can now both check for non-terminal wildcard
  records.
- "rndc freeze/thaw" now freezes/thaws all zones.
- named-checkconf now check acls to verify that they only refer to existing
  acls.
- The server syntax has been extended to support a range of servers.
- Report differences between hints and real NS rrset and associated address
  records.
- Preserve the case of domain names in rdata during zone transfers.
- Restructured the data locking framework using architecture dependent
  atomic operations (when available), improving response performance on
  multi-processor machines significantly.  x86, x86_64, alpha, powerpc, and
  mips are currently supported.
- UNIX domain controls are now supported.
- Add support for additional zone file formats for improving loading
  performance.  The masterfile-format option in named.conf can be used to
  specify a non-default format.  A separate command named-compilezone was
  provided to generate zone files in the new format.  Additionally, the -I
  and -O options for dnssec-signzone specify the input and output formats.
- dnssec-signzone can now randomize signature end times (dnssec-signzone -j
  jitter).
- Add support for CH A record.
- Add additional zone data constancy checks.  named-checkzone has extended
  checking of NS, MX and SRV record and the hosts they reference.  named
  has extended post zone load checks.  New zone options: check-mx and
  integrity-check.
- edns-udp-size can now be overridden on a per server basis.
- dig can now specify the EDNS version when making a query.
- Added framework for handling multiple EDNS versions.
- Additional memory debugging support to track size and mctx arguments.
- Detect duplicates of UDP queries we are recursing on and drop them.  New
  stats category "duplicates".
- "USE INTERNAL MALLOC" is now runtime selectable.
- The lame cache is now done on a <qname,qclass,qtype> basis as some
  servers only appear to be lame for certain query types.
- Limit the number of recursive clients that can be waiting for a single
  query (<qname,qtype,qclass>) to resolve.  New options clients-per-query
  and max-clients-per-query.
- dig: report the number of extra bytes still left in the packet after
  processing all the records.
- Support for IPSECKEY rdata type.
- Raise the UDP recieve buffer size to 32k if it is less than 32k.
- x86 and x86_64 now have seperate atomic locking implementations.
- named-checkconf now validates update-policy entries.
- Attempt to make the amount of work performed in a iteration self tuning.
  The covers nodes clean from the cache per iteration, nodes written to
  disk when rewriting a master file and nodes destroyed per iteration when
  destroying a zone or a cache.
- ISC string copy API.
- Automatic empty zone creation for D.F.IP6.ARPA and friends.  Note: RFC
  1918 zones are not yet covered by this but are likely to be in a future
  release.
- New options: empty-server, empty-contact, empty-zones-enable and
  disable-empty-zone.
- dig now has a '-q queryname' and '+showsearch' options.
- host/nslookup now continue (default)/fail on SERVFAIL.
- dig now warns if 'RA' is not set in the answer when 'RD' was set in the
  query.  host/nslookup skip servers that fail to set 'RA' when 'RD' is set
  unless a server is explicitly set.
- Integrate contibuted DLZ code into named.
- Integrate contibuted IDN code from JPNIC.
- libbind: corresponds to that from BIND 8.4.7.

#### BIND 9.3.0

- DNSSEC is now DS based (RFC 3658).
- DNSSEC lookaside validation.
- check-names is now implemented.
- rrset-order is more complete.
- IPv4/IPv6 transition support, dual-stack-servers.
- IXFR deltas can now be generated when loading master files,
  ixfr-from-differences.
- It is now possible to specify the size of a journal, max-journal-size.
- It is now possible to define a named set of master servers to be used in
  masters clause, masters.
- The advertised EDNS UDP size can now be set, edns-udp-size.
- allow-v6-synthesis has been obsoleted.
- Zones containing MD and MF will now be rejected.
- dig, nslookup name. now report "Not Implemented" as NOTIMP rather than
  NOTIMPL.  This will have impact on scripts that are looking for NOTIMPL.
- libbind: corresponds to that from BIND 8.4.5.

#### BIND 9.2.0

- The size of the cache can now be limited using the "max-cache-size"
  option.
- The server can now automatically convert RFC1886-style recursive lookup
  requests into RFC2874-style lookups, when enabled using the new option
  "allow-v6-synthesis".  This allows stub resolvers that support AAAA
  records but not A6 record chains or binary labels to perform lookups in
  domains that make use of these IPv6 DNS features.
- Performance has been improved.
- The man pages now use the more portable "man" macros rather than the
  "mandoc" macros, and are installed by "make install".
- The named.conf parser has been completely rewritten.  It now supports
  "include" directives in more places such as inside "view" statements, and
  it no longer has any reserved words.
- The "rndc status" command is now implemented.
- rndc can now be configured automatically.
- A BIND 8 compatible stub resolver library is now included in lib/bind.
- OpenSSL has been removed from the distribution.  This means that to use
  DNSSEC, OpenSSL must be installed and the --with-openssl option must be
  supplied to configure.  This does not apply to the use of TSIG, which
  does not require OpenSSL.
- The source distribution now builds on Windows.  See
  win32utils/readme1.txt and win32utils/win32-build.txt for details.
- This distribution also includes a new lightweight stub resolver library
  and associated resolver daemon that fully support forward and reverse
  lookups of both IPv4 and IPv6 addresses.  This library is considered
  experimental and is not a complete replacement for the BIND 8 resolver
  library.  Applications that use the BIND 8 `res_*` functions to perform
  DNS lookups or dynamic updates still need to be linked against the BIND 8
  libraries.  For DNS lookups, they can also use the new "getrrsetbyname()"
  API.
- BIND 9.2 is capable of acting as an authoritative server for DNSSEC
  secured zones.  This functionality is believed to be stable and complete
  except for lacking support for verifications involving wildcard records
  in secure zones.
- When acting as a caching server, BIND 9.2 can be configured to perform
  DNSSEC secure resolution on behalf of its clients.  This part of the
  DNSSEC implementation is still considered experimental.  For detailed
  information about the state of the DNSSEC implementation, see the file
  doc/misc/dnssec.
