/*
 * ------------------------------------------------------------------------
 * 
 * GateD, Release 3.5.5 
 * 
 * Copyright (c) 1996, 1997 The Regents of the University of Michigan
 * All Rights Reserved
 * 
 * License to use, copy, modify, and distribute this software and its
 * documentation can be obtained from Merit at the University of Michigan.
 * 
 * Merit GateDaemon Project
 * 4251 Plymouth Road, Suite C
 * Ann Arbor, MI 48105
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * ---------------------
 * 
 * Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 * All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * Royalty-free licenses to redistribute GateD Release
 * 3 in whole or in part may be obtained by writing to:
 * 
 * GateDaemon Project
 * Information Technologies/Network Resources
 * 200 CCC
 * Cornell University
 * Ithaca, NY  14853-2601  USA
 * 
 * GateD is based on Kirton's EGP, UC Berkeley's routing
 * daemon	 (routed), and DCN's HELLO routing Protocol.
 * Development of GateD has been supported in part by the
 * National Science Foundation.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.cornell.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 * Portions of this software may fall under the following
 * copyrights:
 * 
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms are
 * permitted provided that the above copyright notice and
 * this paragraph are duplicated in all such forms and that
 * any documentation, advertising materials, and other
 * materials related to such distribution and use
 * acknowledge that the software was developed by the
 * University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote
 * products derived from this software without specific
 * prior written permission.  THIS SOFTWARE IS PROVIDED
 * ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * This copyright has ben automaticly added by the util/addcopyright.pl program.
 * __END_OF_COPYRIGHT__
 */

/*
 *  isis.h,v 1.11 1993/01/07 22:37:58 jch Exp
 */

/* Gated Release 3.5 */
/* Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.  All */
/* rights reserved.  Refer to Particulars and other Copyright notices at */
/* the end of this file.  */
/*  */


#ifndef _isis_h
#define _isis_h

#include "isis_pdus.h"
#include "isis_lsp.h"

/*
 *	Contains a list of items that are to be aged. List is maintained
 *	in acending order of time-to-live, (with deltas rather than absolutes
 *	used between nodes. When an item's time-to-live reaches zero, the
 *	delete function is called with the item as argument.
 */
typedef struct _AgeList {
	DLList	links;
	PTIF	delete;
	u_short	ttlOffset;		/* byte offset into 'item' of ttl field */
} AgeList;

typedef enum {ManualConfig, AutoConfig} ConfigurationType;
typedef enum {AdjInitializing, AdjUp, AdjFailed} AdjacencyState;
typedef enum {Unknown, ES, IS, L1IS, L2IS} SystemType;
typedef enum {HoldingTimerExpired, ChecksumError, OneWayConnection,
	CircuitDisabled, VersionSkew, AreaMismatch, TooManyLANIS,
	TooManyLANES, WrongSystemType, IDMismatch} ReasonCode;
typedef enum {Broadcast, Pt2Pt} CircuitType;

/* TODO: maybe make this a union to clarify what is used for IIH and ESH */
typedef struct _AdjacencyEntry {
	DLList			links;
	u_short			name;		/* unique identifier within circuit */
	ConfigurationType	type;
	struct _CircuitEntry	*circuit;	/* back pointer to circuit */
	AdjacencyState		state;
	struct _AdjacencyEntry	*hashNext;
	u_short			hashIndex;	/* index into hashtable */
	MACAddress		neighborMAC;	/* broadcast circuit only */
	u_char			LANPriority;	/* broadcast circuit only */
	SystemType		adjacencyType;	/* type of adjacency */
	SystemID6		neighborSysID;	/* from IIH */
	SystemID7		desigLANID;	/* from IIH */
	IPAddrList		ipaddrs;	/* from IIH (DUAL) */
	Boolean			level2Only;	/* true -> L2 link only */
	u_short			holdingTime;	/* original value from IIH, ESH, ISH */
	u_short			remainingTime;	/* time to live */
	u_short			numIds;		/* ES only */
	u_char			*neighborInfo;	/* either IS areas or ES ids */
} AdjacencyEntry;

/* adjacencies which should be freed upon next run on spf algorithm */
typedef struct _OldAdjacencyEntry {
	DLList	links;
} OldAdjacencyEntry;

#define CircuitNameLen	8

typedef struct _CircuitEntry {
	char		name[CircuitNameLen];	/* name of circuit, ie. un0 */
	int		kernindex;		/* kernel index of circuit */
	int		summarized;		/* true if already summarized (broadcast only) */
	int		fd;			/* socket */
	CircuitType	circuitType;		/* pt2pt or broadcast */
	SystemID6	myMAC;			/* MAC address of this system */
	u_short		helloInterval;		/* clause 11.1.3 */
	u_short		ISIShelloInterval;	/* clause 11.1.3 */
	u_short		holdingTimer;		/* HT for this system */
	MetricList	l1Metric;
	MetricList	l2Metric;
	u_char		l1Priority;		/* for becoming LAN L1 designated IS */
	u_char		l2Priority;		/* for becoming LAN L2 designated IS */
	Boolean		manualL2Only;		/* true if used for L2 only */
	Boolean		up;			/* true if circuit is UP */
	u_char		localId;		/* locally assigned circuit ID */
	SystemID7	circuitId;		/* LAN ID of L1 designated sys, or the ID of the circuit (if pt-to-pt) */
	SystemID7	l2CircuitId;		/* LAN ID of the L2 designated sys */
	AgeList		*esAdjs;		/* ES adjacencies */
	AgeList		*isAdjs;		/* IS adjacencies */
	LSPGroup	*l1PLSP;		/* L1 pseudonode LSP for this circuit */
	LSPGroup	*l2PLSP;		/* L2 pseudonode LSP for this circuit */

	/* the next two boolean control whether pseudonode LSPs are generated */
	Boolean		l1DR;			/* True if L1 designated router */
	Boolean		l2DR;			/* True if L2 designated router */

	Counter		circuitChanges;		/* # circuit up/down */
	Counter		adjacencyEvents;	/* # adjacency state change events */
	Counter		initFailures;		/* # initialization failure events */
	Counter		rejAdjs;		/* # rejected adjacency events */
	Counter		corruptedLSPs;		/* # corrupted LSPs received */
	Counter		l1DesignateChanges;	/* # L1 designated IS changes */
	Counter		l2DesignateChanges;	/* # L2 designated IS changes */
	Counter		pdusSent;
	Counter		pdusReceived;
	struct _CircuitEntry *next;
	u_char		simSubnetId;		/* used by simulator only */
	int		(*transmitFunc)();	/* packet transmission function */
	IPAddrList	ipAddrs;		/* list of IP addresses for this circuit */
	LSEntry		*lastFlooded[2];	/* last LSP flooded on this circuit */
	task		*task;			/* task handling timers for this circuit */
	char		task_name[40];		/* hack to hold task name in heap */
	task_timer	*timer_l1iih;		/* L1 IIH timer */
	task_timer	*timer_l2iih;		/* L2 IIH timer */
	task_timer	*timer_p2piih;		/* P2P IIH timer */
} CircuitEntry;


#define ISIS_INTERNAL           1
#define ISIS_EXTERNAL           2
#define ISIS_SUMMARY            3
#define ISIS_AUTOSUMMARY        4

#define	ISIS_LIMIT_METRIC	1, 63

#endif	/* _isis_h */


/*
 * ------------------------------------------------------------------------
 * 
 * 	GateD, Release 3.5
 * 
 * 	Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 * 	    All rights reserved.
 * 
 * 	THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * 	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * 	LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * 	AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * 	Royalty-free licenses to redistribute GateD Release
 * 	3 in whole or in part may be obtained by writing to:
 * 
 * 	    GateDaemon Project
 * 	    Information Technologies/Network Resources
 * 	    200 CCC
 * 	    Cornell University
 * 	    Ithaca, NY  14853-2601  USA
 * 
 * 	GateD is based on Kirton's EGP, UC Berkeley's routing
 * 	daemon	 (routed), and DCN's HELLO routing Protocol.
 * 	Development of GateD has been supported in part by the
 * 	National Science Foundation.
 * 
 * 	Please forward bug fixes, enhancements and questions to the
 * 	gated mailing list: gated-people@gated.cornell.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 *       Portions of this software may fall under the following
 *       copyrights:
 * 
 * 	Copyright (c) 1988 Regents of the University of California.
 * 	All rights reserved.
 * 
 * 	Redistribution and use in source and binary forms are
 * 	permitted provided that the above copyright notice and
 * 	this paragraph are duplicated in all such forms and that
 * 	any documentation, advertising materials, and other
 * 	materials related to such distribution and use
 * 	acknowledge that the software was developed by the
 * 	University of California, Berkeley.  The name of the
 * 	University may not be used to endorse or promote
 * 	products derived from this software without specific
 * 	prior written permission.  THIS SOFTWARE IS PROVIDED
 * 	``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * 	INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * 	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * ------------------------------------------------------------------------
 * 
 * 	Copyright 1991 D.L.S. Associates
 * 
 * 	Permission to use, copy, modify, distribute, and sell this software
 * 	and its documentation for any purpose is hereby granted without
 * 	fee, provided that the above copyright notice appear in all copies
 * 	and that both that copyright notice and this permission notice
 * 	appear in supporting documentation, and that the name of D.L.S. not
 * 	be used in advertising or publicity pertaining to distribution of
 * 	the software without specific, written prior permission.  D.L.S.
 * 	makes no representations about the suitability of this software for
 * 	any purpose.  It is provided "as is" without express or implied
 * 	warranty.
 * 
 * 	D.L.S. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * 	INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * 	NO EVENT SHALL D.L.S.  BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * 	CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * 	OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * 	NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * 	CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 * 	Authors:  Robert Hagens and Dan Schuh
 * 
 * 
 */
