# IBM OS/2 VisualAge C++ make file for figlet version 2.2 (31 May 1997)
# modified by Jim Northrup <northrup@bright.net>
# from original Unix Makefile for figlet version 2.2 (15 Oct 1996)
# Copyright 1993, 1994 Glenn Chappell and Ian Chai
# Copyright 1996 John Cowan

# Please make sure DESTDIR, MANDIR, DEFAULTFONTDIR and
#   DEFAULTFONTFILE are defined to reflect the situation
#   on your computer.  See README for details.

# icc is the IBM VisualAge C++ compiler
# /C+ directs the compiler to perform a compile only (no link)
CC = icc
CFLAGS = /C+

# Where the executables should be put
# Ed. Note: currently this is not used in the OS/2 version
DESTDIR = .\

# Where the man page should be put
# Ed. Note: currently this is not used in the OS/2 version
MANDIR = .\

# Where figlet will search first for fonts (the ".flf" files).
DEFAULTFONTDIR = .\fonts

# The filename of the font to be used if no other is specified
#   (standard.flf is recommended, but any other can be used).
#   This font file should reside in the directory specified by
#   DEFAULTFONTDIR.
DEFAULTFONTFILE = standard.flf

##
##  END OF CONFIGURATION SECTION
##

SOURCES = figlet.c zipio.c crc.c inflate.c getopt.c

figlet.exe: $(SOURCES:.c=.obj)
        $(CC) $**;

figlet.obj: $(SOURCES)
        $(CC) $(CFLAGS)  $**;
        /DDEFAULTFONTDIR=$(DEFAULTFONTDIR)
        /DDEFAULTFONTFILE=$(DEFAULTFONTFILE)

getopt.obj: getopt.c
        $(CC) $(CFLAGS) $**;

zipio.obj: zipio.c
        $(CC) $(CFLAGS) $**;

crc.obj: crc.c
        $(CC) $(CFLAGS) $**;

inflate.obj: inflate.c
        $(CC) $(CFLAGS) $**;

# Ed. Note: this section was commented out - I may create a seperate
# make file for chkfont at a later date

# chkfont: chkfont.c
#        $(CC) $(CFLAGS) -o chkfont chkfont.c


# Ed. Note: This make file currently does no cleanup or installation

# rm -f *.o figlet chkfont

# install: figlet chkfont
#       mkdir $(DEFAULTFONTDIR)
#        cp figlet $(DESTDIR)
#        cp chkfont $(DESTDIR)
#        cp figlist $(DESTDIR)
#        cp showfigfonts $(DESTDIR)
#        cp fonts/*.flf $(DEFAULTFONTDIR)
#        cp fonts/*.flc $(DEFAULTFONTDIR)
#        cp figlet.6 $(MANDIR)
