#! /bin/sh
# Copyright (C) 2002-2012 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Test Automake style tests.

. ./defs || Exit 1

cat >> configure.ac << 'END'
AC_CONFIG_FILES([dir/Makefile])
AC_OUTPUT
END

mkdir dir

cat > Makefile.am << 'END'
SUBDIRS = dir
TESTS = \
  subrun.sh
subrun.sh:
	(echo '#! /bin/sh'; echo 'dir/echo.sh') > $@
	chmod +x $@
CLEANFILES = subrun.sh
END

cat > dir/Makefile.am << 'END'
check_SCRIPTS = echo.sh
echo.sh:
	(echo '#! /bin/sh'; echo 'echo Hello') > $@
	chmod +x $@
CLEANFILES = echo.sh
END

if test x"$am_parallel_tests" = x"yes"; then
  cp "$am_scriptdir/test-driver" .
fi

$ACLOCAL
$AUTOCONF
$AUTOMAKE
./configure

$MAKE check >stdout || { cat stdout; Exit 1; }
cat stdout
grep '^PASS: subrun\.sh *$' stdout
grep 'PASS.*echo\.sh' stdout && Exit 1

# 'check' should depend directly on 'check-am' (similar tests are
# in check.test and check3.test).
$EGREP '^check:.* check-recursive( |$)' Makefile.in
$EGREP '^check:.* check-am( |$)' dir/Makefile.in

# Make sure subrun.sh is still on its line as above.  This means Automake
# hasn't rewritten the TESTS line unnecessarily (we can tell, because all
# Automake variables are reformatted by VAR_PRETTY).
grep '^  subrun\.sh$' Makefile.in

:
