/* LocaleInformation_nb.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_nb extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "JOD|BOV|XAU|FOK|LBP|EUR|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|ITL|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|GBP|SAS|SAR|LTT|INR|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|CNP|MZE|GNF|OMS|PGK|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|JPY|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesDisplayNameValues = "Jordanske dinarer|Boliviansk mvdol|Gull|F\u00e6r\u00f8yske kronur|Libanesiske pund|Euro|Vietnamesiske dong|Tanzanianske shilling|Boliviansk pesos|Kambodsjanske riel|Asian Monetary Unit|Boliviano (1863-1962)|Kambodsjanske gamle riel|Zambiske pund|Australske pund|CFA Franc BEAC|Maltesiske pund|Ghanesiske revaluerte cedi|Zambiske kwacha|Asian Dinar Unit of Account|Ghanesiske pund|Boliviano|Ghanesiske gamle cedi|Maltesiske lira|Australske dollar|Amerikanske dollar (samme dag)|Italienske lire|Amerikanske dollar (neste dag)|Ghanesiske cedi|Singaporske dollar|Panamanske balboa|Laotiske kip|Kirgisiske som|Sveitsiske franc|\u00d8sterrikske shilling|Amerikanske dollar|Etiopiske dollar|Bruneiske dollar|Jamaikanske pund|Etiopiske birr|Algeriske franc germinal|Algeriske nye franc|Algeriske dinarer|Paraguayanske guarani|Libyske pund|Jamaikanske dollar|Islandske kronar|Spanske peseta|Bermudiske pund|Libyske dinarer|Libyske British Military Authority-lira|Bermudiske dollar|Nederlandske gylden|Mauritanske ouguiya|Iranske rialer|Svenske kroner|Eritreiske nakfa|Kenyanske shilling|Sentralafrikanske franc (CFA)|Argentinske pesos|Argentinske pesos (1983-1985)|Argentinske Peso Moneda Nacional|Taiwanske nye dollar|Sudanesiske pund|Georgiske lari|Georgiske kupon larit|Martinique-franc|Falklands\u00f8yene-pund|Argentinske australer|Sudanesiske dinarer|Irakske dinarer|Tuvalske dollar|Seychelliske rupier|Latviske rubler|Fijianske pund|Latviske lats|Congolesiske zaire|Kongolesiske republikk-franc|Kongolesiske franc (congolais)|Fijianske dollar|Nicaraguanske cordoba oro|Makaoske pataca|Nicaraguanske gullcordoba|Nicaraguanske cordoba|COMECON Transferable Ruble|Finske mark (1860-1962)|Finske mark|Salomonske dollar|Luxemburgske franc|Trinidadiske gamle dollar|Angolanske escudo|Angolan Kwanza Reajustado (1995-1999)|Mongolske tugrik|Ungarske forinter|Burundiske franc|Angolanske ny kwanza (1990-2000)|Angolanske kwanza (1977-1990)|Trinidadiske dollar|Swazilandske lilangeni|Ny-hebridene CFP-franc|Britiske pund sterling|Saudiarabiske riyaler (1936-1952)|Saudiarabiske riyaler|Litauiske talonas|Indiske rupier|Portugisiske escudo|Angolanske kwanza|Portugisiske conto|Litauiske lita|Kasakhstanske tenge|Kasakhstanske rubler|De britiske jomfru\u00f8yene-dollar|Nigerianske pund|Myanmarske dollar (FEC)|Nigerianske naira|Haitiske gourde|Syriske pund|Palestinske pund|Bahrainske dinarer|Myanmarske kyat|Nederlandske antillegylden|Tsjekkiske koruna|Manske pund sterling|Bulgarske lev (FEC)|Lesothiske loti|Gabonske franc (CFA)|Bulgarske lev (1879-1952)|Bulgarske lev|Bulgarske sosialist-lev|Kanadiske dollar|Bulgarske lev (hard)|Tyrkiske lira|Caymanske dollar|Kypriotiske pund|Israelske nye shekler|Guyanske dollar|Armenske dram|Israelske pund|Maliske franc|Israelske shekler|Venezuelanske bolivar|Albanske dollar (FEC)|Liberiske dollar|Albanske lek valute|Kroatiske kuna|Reunionske franc|Kroatiske dinarer|Albanske lek|Jersey pund sterling|Albanske lek (1946-1961)|Makedonske denarer (1992-1993)|Nordvietnamesiske viet minh piastre dong viet|Nordvietnamesiske nye dong|Makedonske denarer|Nordvietnamesiske piastre dong viet|Timoresiske pataca|CFP Franc|Belgiske franc (\u00f8konomiske)|Guinea-Bissau-pesos|Kuwaitiske dinarer|Portugisiske Guinea Mil Reis|Belgiske franc|Timoresiske escudo|Belgiske franc (konvertible)|Portugisiske guinea escudo|Salvadoranske colon|Curacao-gylden|Bangladeshiske taka|Tonganske pund sterling|Tonganske pa\u02bbanga|CFA Franc BCEAO|Sovjetiske rubler|Sovjetiske nye rubler|Kaledonske franc germinal|Kappverdiske escudo|Franske antiller-franc (CFA)|S\u00f8rafrikanske rand|Dominikanske pesos|Kubanske Foreign Exchange Certificates|S\u00f8rafrikanske pund|S\u00f8rafrikanske rand (\u00f8konomisk)|Tunisiske dinarer|Kubanske pesos|Fransk Guyana-franc guiana|Ugandiske shilling|Ceylonske rupier|Affar og Issa franc|Vatikanstatens lira|Sao Tome og Principe-escudo|Ugandiske shilling (1966-1987)|Sao Tome og Principe-dobra|Marshall\u00f8yene-dollar|Nyzealandske pund|Vestsamoisk tala|Vestsamoisk pund|Hoduras Lempira|French Metropolitan Nouveau Franc|Turkmenske manat|Guatemalanske quetzal|Nyzealandske dollar|Skotske pund|Barbadisk dollar|Namibiske dollar|Madagassiske franc|Madagassiske ariary|Egyptiske pund|Britisk Honduras-dollar|Polske zloty (1950-1995)|Bosnia-Hercegovina nye dinarer|Polske US dollar (FEC)|Bosnia-Hercegovina mark (konvertible)|Beliziske dollar|Bosnia-Hercegovina dinarer|Polske zloty|Jemenittiske rialer|Surinamske gylden|Tsjekkoslovakiske koruna (hard)|S\u00f8rkoreanske won|Hviterussiske rubler|Jemenittiske imadi-riyaler|Hviterussiske rubler (1992-1994)|Tsjekkoslovakiske koruna|S\u00f8rkoreanske gamle won|S\u00f8rkoreanske hwan|Hviterussiske nye rubler (1994-1999)|Somalilandske shilling|Greske nye drakmer|Pakistanske rupier|Afghani|Zimbabwiske dollar|Srilankiske rupier|Greske drakmer|Irske pund|Afghani (1927-2002)|Jemenittiske dinarer|Rwandiske franc|Costaricanske colon|Tadsjikiske somoni|Tadsjikiske rubler|Estiske kroon|Ekvatorialguineanske peseta guineana|Moldovske ruble cupon|Hongkong-dollar|Danske kroner|Moldovske leu|Ekvatorialguineanske franco|Ekvatorialguineanske ekwele guineana|Indonesiske rupier|UAE dirham|Nordkoreanske won|Indonesiske nye rupier|Botswanske pula|Moldovske leu cupon|Indonesiske Java-rupier|Nordkoreanske won (1947-1959)|Indonesiske nica-gylden|Vanuatisk vatu|Islamske dinarer|Somaliske shilling|Andorranske pesetas|Russiske rubler (1991-1998)|Guadeloupe-franc|Djiboutiske franc|Andorranske dinarer|Monegaskiske franc germinal|Monegaskiske franc nouveau|Ecuadorianske Unidad de Valor Constante (UVC)|Ecuadorianske sucre|Liechtensteinske franc|Russiske rubler|Filippinske pesos|Usbekiske sum|Colombianske pesos|Thailandske baht|Nordirske pund|Burmesiske rupier|Kongolesiske franc (CFA)|Burmesiske kyat|Colombianske papir-pesos|Usbekiske kupong-som|Ukrainske karbovanetz|Qatarske riyaler|Ukrainsle hryvnia|Guineanske syli|Kinesiske Yuan Renminbi|Mosambikiske metical|Kinesiske US dollar (FEC)|Uruguayanske peso uruguayo|Guineanske franc (1960-1972)|Sanmarinske lira|Kinesiske Jen Min Piao Yuan|Mosambikiske escudo|Guineanske franc|Omanske rial saidi|Papuanske kina|Omanske rialer|Uruguayanske pesos (1975-1993)|French UIC-Franc|Bhutanske rupier|Zairiske zaire|Marokkanske franc|Marokkanske dirham|Bhutanske ngultrum|French Gold Franc|Uruguayanske peso fuerte|Malaysiske ringgit|Zairiske nye zaire|Aserbajdsjanske Manat|Gambiske pund|Komoriske franc|Sierraleonske leone|Gambiske dalasi|European Currency Unit|Bahamske pund|Kamerunske franc (CFA)|Meksikanske Unidad de Inversion (UDI)|CFA Franc BCEAEC|Bahamske dollar|Meksikanske s\u00f8lvpesos (1861-1992)|Meksikanske pesos|Peruvianske sol|Gr\u00f8nlandske kroner|Brasilianske cruzeiro (1942-1967)|Peruvianske sol nuevo|Chilenske pesos|Slovakiske koruna|Peruvianske inti|Brasilianske cruzeiro|Special Drawing Rights|Franske franc (Germinal/Franc Poincare)|Franske franc|Brasilianske cruzado novo|Chilenske Unidades de Fomento|Chilenske escudo|Brasilianske realer|Chilenske condor|Brasilianske cruzeiro (1990-1993)|Tyske sperrmark|Malawiske pund|Brasilianske cruzado|Brasiliansk cruzeiro novo (1967-1986)|Malawisle kwacha|Transdniestrianske rubler|Tyske mark|Tsjadiske franc (CFA)|Transdniestrianske nye rubler|Transdniestriansk rubler (kupon)|Nepalesiske rupier|Cook\u00f8yene dollar|Japanske yen|Maldiviske rufiyaa|CFA Nouveau Franc|Maldiviske rupier|\u00d8stkaribiske dollar|Slovenske tolar|Jugoslaviske reforerte dinarer|Arubiske gylden|Jugoslaviske oktoberdinarer|\u00d8sttyske ostmark|Jugoslaviske konvertible dinarer|Jugoslaviske noviy-dinarer|Turks- og Caicos\u00f8yene-crown|Jugoslaviske 1994-dinarer|Jugoslaviske f\u00f8derasjonen-dinarer|Rumenske nye leu|Jugoslaviske dinarer (hard)|Rumenske leu|Slovenske tolar bons|Norske kroner|Mauritiske rupier|European Unit of Account (XBD)|Gibraltarske pund|Vietnamesiske nasjonale dong|European Unit of Account (XBC)|Vietnamesiske republikk-dong|European Monetary Unit|European Composite Unit|Kiribatiske dollar|Sankthelenske pund|Vietnamesiske nye dong";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "JOD|BOV|XAU|FOK|LBP|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|SAS|SAR|LTT|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|CNP|MZE|GNF|OMS|PGK|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesSymbolValues = "JD|BOV|XAU|FOK|LL|VND|T Sh|BOP|CR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|Bs|GHO|Lm|$A|USS|USN|GHC|S$|PAB|LAK|som|SwF|ATS|US$|ETD|BND|JMP|Br|DZG|DZF|DA|PYG|LYP|J$|ISK|ESP|BMP|LD|LYB|Ber$|NLG|UM|RI|SKr|ERN|K Sh|CFF|Arg$|ARP|ARM|NT$|SDP|lari|GEK|MQF|FKP|ARA|SDD|ID|TVD|SR|LVR|FJP|LVL|CDL|CDG|CDF|F$|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SI$|LUF|TTO|AOS|AOR|Tug|Ft|Fbu|AON|AOK|TT$|E|NHF|SAS|SRl|LTT|PTE|AOA|PTC|LTL|T|KZR|VGD|NGP|MMX|NGN|HTG|LS|PSP|BD|MMK|NA f.|CZK|IMP|BGX|M|GAF|BGO|BGN|BGM|Can$|lev|TL|KYD|\u00a3C|ILS|G$|dram|ILP|MLF|ILL|Be|ALX|LRD|ALV|HRK|REF|HRD|lek|JEP|ALK|MKN|VDP|VDN|MDen|VDD|TPP|CFPF|BEL|GWP|KD|GWM|BF|TPE|BEC|GWE|SVC|CWG|Tk|TOS|T$|XOF|SUR|SUN|NCF|CVEsc|XNF|R|RD$|CUX|ZAP|ZAL|TND|CUP|GUF|U Sh|LNR|AIF|VAL|STE|UGS|Db|MHD|NZP|WST|WSP|L|XMF|TMM|Q|$NZ|SSP|BDS$|N$|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|KM|BZ$|BAD|Zl|YRl|Sf|CSK|KRW|Rbl|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|Pra|Af|Z$|SL Re|GRD|IR\u00a3|AFA|YDD|RWF|C|TJS|TJR|EEK|GQP|MDR|HK$|DKr|MDL|GQF|GQE|Rp|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VT|XID|So. Sh.|ADP|RUR|GPF|DF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|Col$|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QR|UAH|GNS|Y|Mt|CNX|Ur$|GNI|SML|CNP|MZE|GF|OMS|PGK|RO|UYP|XFU|BTR|ZRZ|MAF|MAD|Nu|XFO|UYF|RM|ZRN|AZM|GMP|CF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MEX$|PES|GLK|BRZ|PEN|Ch$|Sk|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|R$|CLC|BRE|DES|MWP|BRC|BRB|MK|PDR|DEM|TDF|PDN|PDK|Nrs|CKD|MVR|XCF|MVP|EC$|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|leu|SIB|kr|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "jan",
    "feb",
    "mar",
    "apr",
    "mai",
    "jun",
    "jul",
    "aug",
    "sep",
    "okt",
    "nov",
    "des",
    null,
  };

  private static final String[] months = {
    "januar",
    "februar",
    "mars",
    "april",
    "mai",
    "juni",
    "juli",
    "august",
    "september",
    "oktober",
    "november",
    "desember",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "s\u00f8n.",
    "man.",
    "tir.",
    "ons.",
    "tor.",
    "fre.",
    "l\u00f8r.",
  };

  private static final String[] weekdays = {
    null,
    "s\u00f8ndag",
    "mandag",
    "tirsdag",
    "onsdag",
    "torsdag",
    "fredag",
    "l\u00f8rdag",
  };

  private static final String[] eras = {
    "f.Kr.",
    "e.Kr.",
  };

  private static final String[][] zoneStrings =
  {
    { "EET", "Eastern European Standard Time", "EEST", "Eastern European Daylight Time",  "Europe/Bucharest" },
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "\u00d8st-Timor|Tokelau|Tadsjikistan|Thailand|Togo|Franske s\u00f8romr\u00e5der|Guyana|Tchad|Turks- og Caicos\u00f8yene|Guinea-Bissau|Guam|Guatemala|S\u00f8r-Georgia og S\u00f8r-Sandwich-\u00f8yene|Hellas|Ekvatorial-Guinea|Guadeloupe|Swaziland|Syria|Guinea|Gambia|Gr\u00f8nland|El Salvador|Sao Tome og Principe|Gibraltar|Ghana|Surinam|Fransk Guyana|Serbia|Georgia|Somalia|Grenada|Senegal|San Marino|Storbritannia|Sierra Leone|Gabon|Slovakia|Svalbard og Jan Mayen|Slovenia|Saint Helena|Singapore|Sverige|Sudan|Seychellene|Salomon\u00f8yene|Saudi Arabia|Frankrike|F\u00e6r\u00f8yene|Mikronesiaf\u00f8derasjonen|Rwanda|Falklands\u00f8yene (Malvinas)|Den russiske f\u00f8derasjon|Fiji|Finland|Romania|Reunion|Etiopia|Spania|Eritrea|Vest-Sahara|Egypt|Estland|Ecuador|Algerie|Qatar|Den dominikanske republikk|Paraguay|Dominica|Palau|Danmark|Djibouti|Portugal|Palestinsk territorium|Puerto Rico|Tyskland|Pitcairn|St. Pierre og Miquelon|Polen|Pakistan|Filippinene|Papua Ny-Guinea|Fransk Polynesia|Tsjekkia|Peru|Kypros|Christmas\u00f8ya|Kapp Verde|Panama|Cuba|Costa Rica|Colombia|Kina|Kamerun|Chile|Cook\u00f8yene|Elfenbenskysten|Sveits|Kongo|Den sentralafrikanske republikk|Kongo, Den demokratiske republikken|Kokos\u00f8yene (Keeling\u00f8yene)|Oman|Canada|Belize|Hviterussland|Botswana|Bouvet\u00f8ya|Bhutan|Bahamas|Brasil|New Zealand|Bolivia|Brunei Darussalam|Bermuda|Niue|Benin|Burundi|Bahrain|Nauru|Bulgaria|Burkina Faso|Nepal|Belgia|Norge|Bangladesh|Barbados|Zimbabwe|Nederland|Bosnia og Hercegovina|Nicaragua|Nigeria|Norfolk\u00f8yene|Aserbajdsjan|Niger|Ny-Caledonia|Aruba|Zambia|Namibia|Australia|\u00d8sterrike|Amerikansk Samoa|Argentina|Antarktis|Mosambik|Angola|Malaysia|De nederlandske antiller|Mexico|Armenia|Malawi|Albania|Maldivene|S\u00f8r-Afrika|Mauritius|Malta|Anguilla|Montserrat|Mauritania|Antigua og Barbuda|Martinique|Afghanistan|Nord-Marianene|De forente arabiske emiratene|Macao S.A.R. (Kina)|Andorra|Mongolia|Myanmar|Mali|Makedonia, Republikken|Jugoslavia|Mayotte|Marshall\u00f8yene|Madagaskar|Moldova|Monaco|Marokko|Yemen|Libya|Latvia|Luxembourg|Litauen|Lesotho|Liberia|Sri Lanka|Liechtenstein|St. Lucia|Libanon|Laos, Den folkedemokratiske republikken|Kasakhstan|Cayman\u00f8yene|Kuwait|S\u00f8r-Korea|Nord-Korea|St. Christopher og Nevis|Komorene|Kiribati|Samoa|Kambodsja|Kirgisistan|Kenya|Wallis og Futuna|Japan|Jordan|Jamaica|Vanuatu|Vietnam|Jomfru\u00f8yene (USA)|Jomfru\u00f8yene (britisk)|Venezuela|St. Vincent og Grenadinene|Vatikanstaten|Italia|Island|Iran|Irak|Usbekistan|Britiske omr\u00e5der i det indiske hav|Uruguay|India|Israel|USA|Irland|Indonesia|USAs mindre \u00f8yer|Uganda|Ukraina|Ungarn|Haiti|Kroatia|Tanzania|Honduras|Heard- og McDonalds\u00f8yene|Taiwan|Tuvalu|Hong Kong S.A.R. (Kina)|Trinidad og Tobago|Tyrkia|Tonga|Tunisia|Turkmenistan";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "gwi|akk|eka|ijo|xh|sux|sus|mis|loz|tog|pon|min|suk|wo|lol|kut|mic|wa|kum|zap|cus|jbo|doi|vo|oto|vi|vai|rar|ve|rap|raj|ota|nzi|nap|uz|uga|tmh|nai|nah|ur|fat|uk|egy|ug|fan|ssa|mga|bat|nyo|bas|nyn|nym|hmn|ban|osa|bal|ty|bai|tw|srr|tli|tt|ts|bad|tr|to|tn|tl|tk|ti|th|kru|tg|byn|te|kro|csb|ta|tkl|efi|sw|sv|su|krc|st|ss|sr|sq|men|crp|so|afh|sn|sm|sl|grc|sk|grb|si|sh|crh|afa|sg|se|sd|udm|sc|sa|rw|ru|mdr|ro|rn|rm|mdf|tiv|ady|zun|kpe|qu|tig|son|cpp|sog|ada|kos|hit|cpf|cpe|him|kok|hil|got|gor|gon|din|nub|pt|ps|fur|phn|goh|snk|cop|yap|ach|yao|phi|pl|ace|pi|pa|bug|iba|sms|bua|mas|smn|os|map|or|man|smj|smi|mak|om|mai|oj|mag|mad|sma|oc|nso|btk|myv|dgr|ny|myn|nv|kmb|nr|gmh|no|nn|nl|ng|sla|ne|nd|cmc|tet|nb|na|ter|tem|my|lez|mt|peo|ms|mr|fro|mo|frm|mn|jrb|ml|mk|mi|mh|mg|mwr|bra|den|lv|lu|del|lt|lo|ln|li|ewo|lg|lb|la|jpr|vot|sit|ky|kw|kv|ku|sio|ks|kr|awa|ko|kn|km|kl|kk|rom|kj|sid|ki|kg|non|ka|mus|roa|nog|mun|mul|jv|gil|znd|shn|fon|xal|aus|kho|ja|khi|pau|chy|tai|iu|pap|it|sgn|is|kha|chr|pam|pal|chp|io|cho|chn|chm|tyv|bnt|pag|ik|chk|ii|haw|lam|ig|chg|sga|paa|ie|id|lah|day|chb|ia|lad|hz|hai|dar|hy|ath|hu|ht|dak|hr|ho|hi|dyu|he|ast|wen|gv|gu|sem|sel|iro|gn|gl|arw|gez|art|gd|ira|ga|arp|arn|fy|bla|gem|ypk|arc|fr|fo|cel|fj|fi|ff|tvl|ceb|fa|eu|sco|et|es|eo|en|el|tut|niu|tup|ee|tum|mos|dz|nic|lus|fiu|dv|nia|moh|luo|lun|apa|lui|hup|bin|de|lua|bik|was|und|war|da|dum|wal|mno|wak|sat|cy|sas|kbd|cv|cu|mni|cs|sam|cr|sal|dua|co|sai|mnc|sah|kaw|inh|gba|sad|ch|ine|bho|enm|kar|inc|ce|gay|ca|umb|syr|kam|tsi|ang|kac|cau|kab|kaa|bs|car|br|bo|bn|bm|gaa|cai|bi|bh|bg|be|cad|ba|zu|zen|pro|hsb|az|ay|av|as|dsb|ar|ilo|elx|zh|an|pra|am|new|ak|za|af|ae|ab|aa|yo|alg|ale|mkh|yi|dra|ber|nds|bem|bej|tpi";

  private static final String languagesValues = "gwich\u02bbin|akkadisk|ekajuk|ijo|xhosa|sumerisk|susu|ulike spr\u00e5k|lozi|tonga (Nyasa)|ponapisk|minangkabau|sukuma|wolof|mongo|kutenai|micmac|vallonsk|kumyk|zapotec|kusjitisk (annet)|lojban|dogri|volapyk|otomisk spr\u00e5k|vietnamesisk|vai|rarotongan|venda|rapanui|rajasthani|tyrkisk, ottomansk (1500-1928)|nzima|napolitansk|usbekisk|ugaritisk|tamashek|nordamerikansk indiansk (annet)|nahuatl|urdu|fanti|ukrainsk|egyptisk (historisk)|uigurisk|fang|nilo-saharam (annet)|mellomirsk (900-1200)|baltisk (annet)|nyoro|basa|nyankole|nyamwezi|hmong|balinesisk|osage|baluchi|tahitisk|bamilekisk spr\u00e5k|twi|serer|tlingit|tatarisk|tsonga|banda|tyrkisk|tonga (Tonga-\u00f8yene)|tswana|tagalog|turkmensk|tigrinja|thai|kurukh|tatsjikisk|blin|telugu|kru|kasjubisk|tamil|tokelau|efik|swahili|svensk|sundanesisk|karachay-balkar|sotho (s\u00f8rlig)|swati|serbisk|albansk|mende|kreolsk og pidgin (annet)|somalisk|afrihili|shona|samoansk|slovensk|gammelgresk (til 1453)|slovakisk|grebo|singalesisk|serbokroatisk|krimtyrkisk, krimtatarisk|afroasiatisk (annet)|sango|nordsamisk|sindhi|udmurt|sardinsk|sanskrit|kinjarwanda|russisk|mandar|rumensk|rundi|retoromansk|moksha|tiv|adyghe|zuni|kpelle|quechua|tigr\u00e9|songhai|kreolsk og pidgin, portugisiskbasert (annet)|sogdisk|adangme|kosraeansk|hettittisk|kreolsk og pidgin, franskbasert (annet)|kreolsk og pidgin, engelskbasert (annet)|himachali|konkani|hiligaynon|gotisk|gorontalo|gondi|dinka|nubisk spr\u00e5k|portugisisk|pashto|friuliansk|f\u00f8nikisk|gammelh\u00f8ytysk (ca.750-1050)|soninke|koptisk|yapesisk|acoli|yao|filippinsk (annet)|polsk|akinesisk|pali|panjabi|buginesisk|iban|skoltesamisk|buriat|masai|enaresamisk|ossetisk|austronesisk|oriya|mandingo|lulesamisk|samisk spr\u00e5k (annet)|makasar|oromo|maithili|ojibwa|magahi|maduresisk|s\u00f8rsamisk|oksitansk (etter 1500)|sotho, nord|batak|erzya|dogrib|nyanja|maya|navajo|kimbundu|ndebele, s\u00f8r|mellomh\u00f8ytysk (ca.1050-1500)|norsk|norsk nynorsk|nederlandsk|ndonga|slavisk (annet)|nepalsk|ndebele (nord)|kamisk spr\u00e5k|tetum|norsk bokm\u00e5l|nauru|tereno|temne|burmesisk|lezghian|maltesisk|gammelpersisk (ca. 600-400 f. kr.)|malayisk|marathi|gammelfransk (842 til ca.1400)|moldavisk|mellomfransk (ca.1400-1600)|mongolsk|j\u00f8dearabisk|malayalam|makedonsk|maori|marshallesisk|madagassisk|marwari|braj|slavisk|latvisk|luba-katanga|delaware|litauisk|laotisk|lingala|limburgisk|ewondo|ganda|luxemburgsk|latin|j\u00f8depersisk|votisk|sino-tibetansk (annet)|kirgisisk|kornisk|komi|kurdisk|sioux-spr\u00e5k|kasjmiri|kanuri|awadhi|koreansk|kannada|khmer|kalaallisut|kasakhisk|romani|kuanyama|sidamo|kikuyu|kikongo|gammelnorsk|georgisk|creek|romansk (annet)|nogai|munda-spr\u00e5k|flere spr\u00e5k|javanesisk|kiribatisk; gilbertesisk|zande|shan|fon|kalmyk|australsk spr\u00e5k|khotanesisk|japansk|khoisan (annet)|palauisk|cheyenne|tai (annet)|inuktitut|papiamento|italiensk|tegnspr\u00e5k|islandsk|khasi|cherokee|pampanga|pahlavi|chipewiansk|ido|choctaw|chinook|mari|tuvinisk|bantu|pangasinan|unupiak|chuukesisk|sichuan-yi|hawaiisk|lamba|ibo|chagatai|gammelirsk (til 900)|papuisk (annet)|interlingue|indonesisk|lahnda|dayak|chibcha|interlingua|ladinsk|herero|haida|dargwa|armensk|athapaskansk spr\u00e5k|ungarsk|haitisk|dakota|kroatisk|hiri motu|hindi|dyula|hebraisk|asturisk|sorbisk spr\u00e5k|manx|gujarati|semittisk (annet)|selkupisk|irokansk spr\u00e5k|guarani|galicisk|arawak|ges|kunstig (annet)|skotsk g\u00e6lisk|iransk|irsk|arapaho|araukansk|frisisk|siksika|germansk (annet)|jupisk spr\u00e5k|arameisk|fransk|f\u00e6r\u00f8ysk|keltisk (annet)|fijiansk|finsk|fulani|tuvalu|cebuansk|persisk|baskisk|skotsk|estisk|spansk|esperanto|engelsk|gresk|altaisk (annet)|niueansk|tupi-spr\u00e5k|ewe|tumbuka|mossi|dzongkha|niger - kordofaniansk (annet)|lushai|finsk-ugrisk (annet)|divehi|nias|mohawk|luo|lunda|apache-spr\u00e5k|luiseno|hupa|bini|tysk|luba-lulua|bikol|washo|ikke angitt|waray|dansk|mellomnederlandsk (ca. 1050-1350)|walamo|manobo-spr\u00e5k|wakasjansk spr\u00e5k|santali|walisisk|sasak|kabardisk|tsjuvansk|kirkeslavisk|manipuri|tsjekkisk|samaritansk arameisk|cree|salishansk spr\u00e5k|duala|korsikansk|s\u00f8ramerikansk indiansk (annet)|mandsju|jakutsk|kawi|ingusjisk|gbaya|sandawe|chamorro|indoeuropeisk (annet)|bhojpuri|mellomengelsk (1100-1500)|karensk|indisk (annet)|tsjetsjensk|gayo|katalansk|umbundu|syrisk|kamba|tsimshian|gammelengelsk (ca. 450-1100)|kachin|kaukasisk (annet)|kabylsk|karakalpakisk|bosnisk|karibisk|bretonsk|tibetansk|bengali|bambara|ga|sentralamerikansk indiansk (annet)|bislama|bihari|bulgarsk|hviterussisk|caddo|basjkirsk|zulu|zenaga|gammelproven\u00e7alsk (til 1500)|h\u00f8ysorbisk|aserbajdsjansk|aymara|avarisk|assamisk|lavsorbisk|arabisk|iloko|elamittisk|kinesisk|aragonsk|prakrit-spr\u00e5k|amharisk|newari|akan|zhuang|afrikaans|avestisk|abkhasisk|afar|joruba|algonkin|aleutisk|mon-khmer (Other)|jiddisk|dravidisk (annet)|berbisk|lavtysk; lavsaksisk|bemba|beja|tok pisin";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final String variantsKeys = "REVISED";

  private static final String variantsValues = "Revidert";

  private static final Hashtable variants;
  static
  {
    variants = new Hashtable();
    Enumeration keys = new StringTokenizer(variantsKeys, "|");
    Enumeration values = new StringTokenizer(variantsValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         variants.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "\u00a0" },
    { "percentFormat", "#,##0 %" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "shortDateFormat", "dd.MM.yy" },
    { "mediumDateFormat", "d. MMM. yyyy" },
    { "longDateFormat", "d. MMMM yyyy" },
    { "fullDateFormat", "EEEE d. MMMM yyyy" },
    { "shortTimeFormat", "HH.mm" },
    { "mediumTimeFormat", "HH.mm.ss" },
    { "longTimeFormat", "HH.mm.ss z" },
    { "fullTimeFormat", "'kl. 'HH.mm.ss z" },
    { "zoneStrings", zoneStrings },
    { "territories", territories },
    { "languages", languages },
    { "variants", variants },
  };

  public Object[][] getContents() { return contents; }
}
