/* LocaleInformation_ca.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_ca extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "ESP";

  private static final String currenciesDisplayNameValues = "ESP";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "\u00A6");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "ESP";

  private static final String currenciesSymbolValues = "\u20a7";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "\u00A6");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "gen.",
    "febr.",
    "mar\u00e7",
    "abr.",
    "maig",
    "juny",
    "jul.",
    "ag.",
    "set.",
    "oct.",
    "nov.",
    "des.",
    null,
  };

  private static final String[] months = {
    "gener",
    "febrer",
    "mar\u00e7",
    "abril",
    "maig",
    "juny",
    "juliol",
    "agost",
    "setembre",
    "octubre",
    "novembre",
    "desembre",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "dg.",
    "dl.",
    "dt.",
    "dc.",
    "dj.",
    "dv.",
    "ds.",
  };

  private static final String[] weekdays = {
    null,
    "diumenge",
    "dilluns",
    "dimarts",
    "dimecres",
    "dijous",
    "divendres",
    "dissabte",
  };

  private static final String territoriesKeys = "TL\u00A6TK\u00A6TJ\u00A6TH\u00A6TG\u00A6TF\u00A6GY\u00A6TD\u00A6GW\u00A6GT\u00A6GR\u00A6GQ\u00A6GP\u00A6SZ\u00A6SY\u00A6GN\u00A6GM\u00A6SV\u00A6GH\u00A6SR\u00A6GF\u00A6GE\u00A6SO\u00A6SN\u00A6GB\u00A6SL\u00A6GA\u00A6SK\u00A6SI\u00A6SG\u00A6SE\u00A6SD\u00A6SC\u00A6SA\u00A6FR\u00A6FM\u00A6RW\u00A6RU\u00A6FJ\u00A6FI\u00A6RO\u00A6ET\u00A6ES\u00A6ER\u00A6EH\u00A6EG\u00A6EE\u00A6EC\u00A6DZ\u00A6QA\u00A6DO\u00A6PY\u00A6DM\u00A6DK\u00A6DJ\u00A6PT\u00A6PR\u00A6DE\u00A6PL\u00A6PK\u00A6PH\u00A6PG\u00A6PF\u00A6CZ\u00A6PE\u00A6CY\u00A6CV\u00A6PA\u00A6CU\u00A6CR\u00A6CO\u00A6CN\u00A6CM\u00A6CL\u00A6CI\u00A6CH\u00A6CG\u00A6CF\u00A6OM\u00A6CA\u00A6BZ\u00A6BY\u00A6BW\u00A6BT\u00A6BS\u00A6BR\u00A6NZ\u00A6BO\u00A6BN\u00A6BM\u00A6NU\u00A6BJ\u00A6BI\u00A6BH\u00A6BG\u00A6BF\u00A6NP\u00A6BE\u00A6NO\u00A6BD\u00A6BB\u00A6ZW\u00A6NL\u00A6BA\u00A6NI\u00A6NG\u00A6AZ\u00A6NE\u00A6NC\u00A6AW\u00A6ZM\u00A6AU\u00A6NA\u00A6AT\u00A6AR\u00A6MZ\u00A6AO\u00A6MY\u00A6AN\u00A6MX\u00A6AM\u00A6AL\u00A6ZA\u00A6MU\u00A6MT\u00A6AI\u00A6MS\u00A6MR\u00A6MQ\u00A6AF\u00A6AE\u00A6AD\u00A6MN\u00A6MM\u00A6ML\u00A6MK\u00A6YU\u00A6YT\u00A6MG\u00A6MD\u00A6MC\u00A6MA\u00A6YE\u00A6LY\u00A6LV\u00A6LU\u00A6LT\u00A6LS\u00A6LR\u00A6LK\u00A6LI\u00A6LB\u00A6LA\u00A6KZ\u00A6KW\u00A6KR\u00A6KP\u00A6KM\u00A6KI\u00A6KH\u00A6KG\u00A6KE\u00A6JP\u00A6JO\u00A6JM\u00A6VU\u00A6VN\u00A6VI\u00A6VG\u00A6VE\u00A6VA\u00A6IT\u00A6IS\u00A6IR\u00A6IQ\u00A6UZ\u00A6UY\u00A6IN\u00A6IL\u00A6US\u00A6IE\u00A6ID\u00A6UG\u00A6UA\u00A6HU\u00A6HT\u00A6HR\u00A6TZ\u00A6HN\u00A6TW\u00A6HK\u00A6TT\u00A6TR\u00A6TO\u00A6TN\u00A6TM";

  private static final String territoriesValues = "Timor\u00A6Tokelau\u00A6Tadjikistan\u00A6Tail\u00e0ndia\u00A6Togo\u00A6Territoris Meridionals Francesos\u00A6Guyana\u00A6Txad\u00A6Guinea Bissau\u00A6Guatemala\u00A6Gr\u00e8cia\u00A6Guinea Equatorial\u00A6Guadeloupe\u00A6Swazil\u00e0ndia\u00A6S\u00edria\u00A6Guinea\u00A6G\u00e0mbia\u00A6El Salvador\u00A6Ghana\u00A6Surinam\u00A6Guaiana Francesa\u00A6Ge\u00f2rgia\u00A6Som\u00e0lia\u00A6Senegal\u00A6Regne Unit\u00A6Sierra Leone\u00A6Gabon\u00A6Eslov\u00e0quia\u00A6Eslov\u00e8nia\u00A6Singapur\u00A6Su\u00e8cia\u00A6Sudan\u00A6Seychelles\u00A6Ar\u00e0bia Saud\u00ed\u00A6Fran\u00e7a\u00A6Micron\u00e8sia\u00A6Rwanda\u00A6R\u00fassia\u00A6Fiji\u00A6Finl\u00e0ndia\u00A6Romania\u00A6Eti\u00f2pia\u00A6Espanya\u00A6Eritrea\u00A6S\u00e0hara Occidental\u00A6Egipte\u00A6Est\u00f2nia\u00A6Equador\u00A6Alg\u00e8ria\u00A6Qatar\u00A6Rep\u00fablica Dominicana\u00A6Paraguai\u00A6Dominica\u00A6Dinamarca\u00A6Djibouti\u00A6Portugal\u00A6Puerto Rico\u00A6Alemanya\u00A6Pol\u00f2nia\u00A6Pakistan\u00A6Filipines\u00A6Papua Nova Guinea\u00A6Polin\u00e8sia Francesa\u00A6Rep\u00fablica Txeca\u00A6Per\u00fa\u00A6Xipre\u00A6Cap Verd\u00A6Panam\u00e0\u00A6Cuba\u00A6Costa Rica\u00A6Col\u00f2mbia\u00A6Xina\u00A6Camerun\u00A6Xile\u00A6Costa d\u2019Ivori\u00A6Switzerland\u00A6Congo\u00A6Rep\u00fablica Centrafricana\u00A6Oman\u00A6Canad\u00e0\u00A6Belize\u00A6Bielor\u00fassia\u00A6Botswana\u00A6Bhutan\u00A6Bahames\u00A6Brasil\u00A6Nova Zelanda\u00A6Bol\u00edvia\u00A6Brunei\u00A6Bermudes\u00A6Niue\u00A6Benin\u00A6Burundi\u00A6Bahrain\u00A6Bulg\u00e0ria\u00A6Burkina Faso\u00A6Nepal\u00A6B\u00e8lgica\u00A6Noruega\u00A6Bangla Desh\u00A6Barbados\u00A6Zimbabwe\u00A6Pa\u00efsos Baixos\u00A6B\u00f2snia i Hercegovina\u00A6Nicaragua\u00A6Nig\u00e8ria\u00A6Azerbaidjan\u00A6N\u00edger\u00A6Nova Caled\u00f2nia\u00A6Aruba\u00A6Z\u00e0mbia\u00A6Austr\u00e0lia\u00A6Nam\u00edbia\u00A6\u00c2ustria\u00A6Argentina\u00A6Mo\u00e7ambic\u00A6Angola\u00A6Mal\u00e0isia\u00A6Antilles Holandeses\u00A6M\u00e8xic\u00A6Arm\u00e8nia\u00A6Alb\u00e0nia\u00A6Sud-\u00e0frica\u00A6Maurici\u00A6Malta\u00A6Anguilla\u00A6Montserrat\u00A6Maurit\u00e0nia\u00A6Martinica\u00A6Afganistan\u00A6Uni\u00f3 dels Emirats \u00c0rabs\u00A6Andorra\u00A6Mong\u00f2lia\u00A6Myanmar\u00A6Mali\u00A6Maced\u00f2nia\u00A6Iugosl\u00e0via\u00A6Mayotte\u00A6Madagascar\u00A6Mold\u00e0via\u00A6M\u00f2naco\u00A6Marroc\u00A6Iemen\u00A6L\u00edbia\u00A6Let\u00f2nia\u00A6Luxemburg\u00A6Litu\u00e0nia\u00A6Lesotho\u00A6Lib\u00e8ria\u00A6Sri Lanka\u00A6Liechtenstein\u00A6L\u00edban\u00A6Laos\u00A6Kazakhstan\u00A6Kuwait\u00A6Corea del Sud\u00A6Corea del Nord\u00A6Comores\u00A6Kiribati\u00A6Cambodja\u00A6Kirgizistan\u00A6Kenya\u00A6Jap\u00f3\u00A6Jord\u00e0nia\u00A6Jamaica\u00A6Vanuatu\u00A6Vietnam\u00A6Illes Verges dels USA\u00A6Illes Verges Brit\u00e0niques\u00A6Vene\u00e7uela\u00A6Vatic\u00e0\u00A6It\u00e0lia\u00A6Isl\u00e0ndia\u00A6Iran\u00A6Iraq\u00A6Uzbekistan\u00A6Uruguai\u00A6\u00cdndia\u00A6Israel\u00A6Estats Units\u00A6Irlanda\u00A6Indon\u00e8sia\u00A6Uganda\u00A6Ucra\u00efna\u00A6Hongria\u00A6Hait\u00ed\u00A6Cro\u00e0cia\u00A6Tanz\u00e0nia\u00A6Hondures\u00A6Taiwan\u00A6Hong Kong\u00A6Trinitat i Tobago\u00A6Turquia\u00A6Tonga\u00A6Tun\u00edsia\u00A6Turkmenistan";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(territoriesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "es\u00A6ku\u00A6eo\u00A6ks\u00A6en\u00A6el\u00A6qu\u00A6ko\u00A6kn\u00A6km\u00A6kl\u00A6kk\u00A6wo\u00A6ka\u00A6dz\u00A6jv\u00A6pt\u00A6ps\u00A6de\u00A6pl\u00A6da\u00A6vo\u00A6ja\u00A6vi\u00A6cy\u00A6pa\u00A6cs\u00A6iu\u00A6it\u00A6co\u00A6is\u00A6uz\u00A6or\u00A6ik\u00A6ur\u00A6om\u00A6ca\u00A6ie\u00A6id\u00A6uk\u00A6ia\u00A6oc\u00A6ug\u00A6hy\u00A6br\u00A6hu\u00A6bo\u00A6bn\u00A6hr\u00A6bi\u00A6tw\u00A6bh\u00A6bg\u00A6tt\u00A6no\u00A6be\u00A6ts\u00A6hi\u00A6tr\u00A6nl\u00A6zu\u00A6ba\u00A6to\u00A6he\u00A6tn\u00A6tl\u00A6tk\u00A6ha\u00A6ne\u00A6az\u00A6ti\u00A6ay\u00A6th\u00A6tg\u00A6na\u00A6te\u00A6zh\u00A6as\u00A6ar\u00A6ta\u00A6gu\u00A6my\u00A6am\u00A6za\u00A6mt\u00A6ms\u00A6gn\u00A6sw\u00A6mr\u00A6sv\u00A6gl\u00A6su\u00A6af\u00A6st\u00A6mo\u00A6ss\u00A6mn\u00A6sr\u00A6sq\u00A6ml\u00A6ab\u00A6mk\u00A6aa\u00A6so\u00A6sn\u00A6mi\u00A6gd\u00A6sm\u00A6sl\u00A6mg\u00A6sk\u00A6ga\u00A6yo\u00A6si\u00A6sh\u00A6sg\u00A6yi\u00A6sd\u00A6fy\u00A6sa\u00A6fr\u00A6lv\u00A6lt\u00A6fo\u00A6rw\u00A6ru\u00A6lo\u00A6fj\u00A6ln\u00A6fi\u00A6ro\u00A6rn\u00A6rm\u00A6fa\u00A6la\u00A6xh\u00A6eu\u00A6ky\u00A6et";

  private static final String languagesValues = "espanyol\u00A6kurd\u00A6esperanto\u00A6caixmiri\u00A6angl\u00e8s\u00A6grec\u00A6qu\u00e8txua\u00A6core\u00e0\u00A6kannada\u00A6cambodj\u00e0\u00A6greenland\u00e8s\u00A6kazakh\u00A6w\u00f2lof\u00A6georgi\u00e0\u00A6bhutan\u00e8s\u00A6javan\u00e8s\u00A6portugu\u00e8s\u00A6paixto\u00A6alemany\u00A6polon\u00e8s\u00A6dan\u00e8s\u00A6volapuk\u00A6japon\u00e8s\u00A6vietnamita\u00A6gal\u00b7l\u00e8s\u00A6panjabi\u00A6txec\u00A6inuktitut\u00A6itali\u00e0\u00A6cors\u00A6island\u00e8s\u00A6uzbek\u00A6oriya\u00A6inupiak\u00A6urd\u00fa\u00A6oromo (afan)\u00A6catal\u00e0\u00A6interlingue\u00A6indonesi\u00A6ucra\u00efn\u00e8s\u00A6interlingua\u00A6occit\u00e0\u00A6uigur\u00A6armeni\u00A6bret\u00f3\u00A6hongar\u00e8s\u00A6tibet\u00e0\u00A6bengal\u00ed\u00A6croat\u00A6bislama\u00A6twi\u00A6bihari\u00A6b\u00falgar\u00A6t\u00e0tar\u00A6noruec\u00A6bielor\u00fas\u00A6tsonga\u00A6hindi\u00A6turc\u00A6neerland\u00e8s\u00A6zulu\u00A6baixkir\u00A6tonga\u00A6hebreu\u00A6tswana\u00A6tag\u00e0log\u00A6turcman\u00A6hausa\u00A6nepal\u00e8s\u00A6\u00e0zeri\u00A6tigrinya\u00A6aimara\u00A6thai\u00A6tadjik\u00A6nauru\u00e0\u00A6telugu\u00A6xin\u00e9s\u00A6assam\u00e8s\u00A6\u00e2rab\u00A6t\u00e0mil\u00A6gujarati\u00A6birm\u00e0\u00A6amh\u00e0ric\u00A6zhuang\u00A6malt\u00e8s\u00A6malai\u00A6guaran\u00ed\u00A6swahili\u00A6marathi\u00A6suec\u00A6gallec\u00A6sundan\u00e8s\u00A6afrikaans\u00A6sotho\u00A6moldau\u00A6siswati\u00A6mongol\u00A6serbi\u00A6alban\u00e8s\u00A6malaialam\u00A6abkhaz\u00A6macedoni\u00A6\u00e0far\u00A6somali\u00A6shona\u00A6maori\u00A6escoc\u00e8s\u00A6samo\u00e0\u00A6eslov\u00e8\u00A6malgaix\u00A6eslovac\u00A6irland\u00e8s\u00A6ioruba\u00A6sinhal\u00e8s\u00A6serbo-croat\u00A6sango\u00A6jiddish\u00A6sindhi\u00A6fris\u00f3\u00A6s\u00e0nscrit\u00A6franc\u00e8s\u00A6let\u00f3\u00A6litu\u00e0\u00A6fero\u00e8s\u00A6kinyarwanda\u00A6rus\u00A6laosi\u00e0\u00A6fiji\u00e0\u00A6lingala\u00A6fin\u00e8s\u00A6roman\u00e8s\u00A6kirundi\u00A6retorom\u00e0nic\u00A6persa\u00A6llat\u00ed\u00A6xosa\u00A6basc\u00A6kirgu\u00eds\u00A6estoni\u00e0";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(languagesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "localPatternChars", "GuMtkHmsSEDFwWahKzUeygAZ" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "shortDateFormat", "dd/MM/yy" },
    { "mediumDateFormat", "dd/MM/yyyy" },
    { "longDateFormat", "d 'd\u2019'MMMM 'de' yyyy" },
    { "fullDateFormat", "EEEE d 'd\u2019'MMMM 'de' yyyy" },
    { "shortTimeFormat", "H:mm" },
    { "mediumTimeFormat", "H:mm:ss" },
    { "longTimeFormat", "H:mm:ss z" },
    { "fullTimeFormat", "H:mm:ss z" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
