.\" -*- nroff -*-
.\" ---------------------------------------------------------------------------
.\"    man page for send-pr (by Heinz G. Seidl, hgs@cygnus.com)
.\"    updated Feb 1993 for GNATS 3.00 by Jeffrey Osier, jeffrey@cygnus.com
.\"
.\"    This file is part of the Problem Report Management System (GNATS)
.\"    Copyright 1992 Cygnus Support
.\"
.\"    This program is free software; you can redistribute it and/or
.\"    modify it under the terms of the GNU General Public
.\"    License as published by the Free Software Foundation; either
.\"    version 2 of the License, or (at your option) any later version.
.\"
.\"    This program is distributed in the hope that it will be useful,
.\"    but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
.\"    General Public License for more details.
.\"
.\"    You should have received a copy of the GNU Library General Public
.\"    License along with this program; if not, write to the Free
.\"    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
.\"
.\" ---------------------------------------------------------------------------
.nh
.TH SEND-PR 1 xVERSIONx "November 2002"
.SH NAME
send-pr \- submit a GNATS Problem Report (PR) to a support site
.SH SYNOPSIS
.B send-pr
.RS
[\ \fB\-\-batch\ \fR|\fB\ \-b\fR\ ]
.br
[\ \fB\-\-database\fR\=\fIdatabase\fR\ |\ \fB\-d\fR\ \fIdatabase\fR\ ]
.br
[\ \fB\-\-file\fR\=\fIfile\fR\ |\ \fB\-f\fR\ \fIfile\fR\ ]
.br
[\ \fB\-\-print\fR\ |\ \fB\-p\fR\ ]
.br
[\ \fB\-\-request-id\fR\ ]
.br
[\ \fB\-\-severity\fR\=\fIseverity\fR\ |\ \fB\-s\fR\ \fIseverity\fR\ ]
.br
[\ \fB\-\-help\fR\ |\ \fB\-h\fR\ ]
[\ \fB\-\-version\fR\ |\ \fB\-V\fR\ ]
.ad b
.hy 1
.SH DESCRIPTION

\fBsend-pr\fR invokes an editor on a problem report template (after
trying to fill in some fields with reasonable default values).  When
you exit the editor, \fBsend-pr\fR submits the completed form to the
GNATS system at a central support site, either directly over the
network to the GNATS server or by e-mail.  At the support site, the PR
is assigned a unique number and is stored in the GNATS database
according to its category and submitter-id.  GNATS automatically
replies with an acknowledgement, citing the category and the PR
number.
.LP
To ensure that a PR is handled promptly, it should contain your (unique)
\fIsubmitter-id\fR and one of the available \fIcategories\fR to identify the
problem area.
.LP
The more precise your problem description and the more complete your
information, the faster your support team can solve your problems.
.LP
Note: use \fBsend-pr\fR to submit problem reports rather than mailing
them directly.  Using both the template and \fBsend-pr\fR itself will
help ensure that all necessary information will reach the support site.
.SH OPTIONS
.TP
\fB\-b\fR,\ \fB\-\-batch
Suppresses printing of most of the messages that \fBsend-pr\fR usually
prints while running.
.TP
\fB\-d \fIdatabase\fR,\ \fB\-\-database=\fIdatabase\fR 
Specifies the database to which the PR is to be submitted; if no
database is specified, the local database named \fBdefault\fR is
assumed.  This option overrides the database specified in the
\fBGNATSDB\fR environment variable.
.TP
\fB\-f\ \fIfile\fR,\ \fB\-\-file=\fIfile\fR
Specifies a file where a completed Problem Report or a PR template
exists.  \fBsend-pr\fR verifies that the contents of the file
constitute a valid PR and asks the user whether the PR should be
submitted directly or edited first.  If the PR text is invalid, the
user will be notified and given the option to edit it.  If \fIfile\fR
is set to `-', \fBsend-pr\fR reads from standard input.
.TP
\fB\-p\fR,\ \fB\-\-print
Displays the PR template for the specified \fBdatabase\fR, or if the
\fB-d\fR or \fB--database\fR options are not specified, print the
template for the local database \fBdefault\fR.  No PR is submitted
when this option is used.
.TP
\fB\-\-request-id\fR
Sends a request for a Submitter Id to the support site.
.TP
\fB\-s\ \fIseverity\fR,\ \fB\-\-severity=\fIseverity\fR
Sets the initial value of the \fBSeverity\fR field to \fIseverity\fR.
.TP
\fB\-\-version\fR,\ \fB\-V\fR
Displays the version number of the program.
.TP
\fB\-\-help\fR,\ \fB\-h\fR
Prints a brief usage message.
.SH ENVIRONMENT
The environment variable 
.B EDITOR
specifies the editor to invoke on the template.
.br
default:
.B vi
.SH "HOW TO FILL OUT A PROBLEM REPORT"
Problem reports have to be in a particular form so that a program can
easily manage them.  Please remember the following guidelines:
.IP \(bu 3m 
describe only 
.B one problem
with each problem report.
.IP \(bu 3m
For follow-up mail, use the same subject line as the one in the automatic
acknowledgent. It consists of category, PR number and the original synopsis
line.  This allows the support site to relate several mail messages to a
particular PR and to record them automatically.
.IP \(bu 3m 
Please try to be as accurate as possible in the subject and/or synopsis line.
.IP \(bu 3m 
The subject and the synopsis line are not confidential.  This is
because open-bugs lists are compiled from them.  Avoid confidential
information there.
.LP
See the GNU 
.B Info 
file
.B gnats.info
or the document \fIKeeping Track: Managing Messages With GNATS\fR\ for detailed
information on reporting problems.
.SH FILES
xPREFIXx/etc/gnats/send-pr.conf  The \fBsend-pr\fR configuration file
.br
.ta \w'/tmp/pbad$$  'u
/tmp/p$$	copy of PR used in editing session
.br
/tmp/pf$$	copy of empty PR form, for testing purposes
.br
/tmp/pbad$$	file for rejected PRs
.SH EMACS USER INTERFACE
An Emacs user interface for 
.B send-pr
with completion of field values is part of the 
.B send-pr
distribution (invoked with
.BR "M-x send-pr" ).
See the file
.B gnats.info
in the doc subdirectory of the distribution for configuration,
installation and usage information, or see
.I Keeping Track: Managing Messages With GNATS
.SH INSTALLATION AND CONFIGURATION
See 
.B gnats.info
or
.B INSTALL
for installation instructions.
.SH "SEE ALSO"
.I Keeping Track: Managing Messages With GNATS
(also installed as the GNU Info file
.BR gnats.info )
.LP
.BR databases (5),
.BR dbconfig (5),
.BR delete-pr (8),
.BR edit-pr (1)
.BR file-pr (8),
.BR gen-index (8),
.BR gnats (7),
.BR gnatsd (8),
.BR mkcat (8),
.BR mkdb (8),
.BR pr-edit (8),
.BR query-pr (1),
.BR queue-pr (8),
.BR send-pr (1).
.SH AUTHORS
Jeffrey Osier, Brendan Kehoe, Jason Merrill, Heinz G. Seidl (Cygnus
Support), Yngve Svendsen.
.SH COPYING
Copyright (c) 1992, 1993, 2002, Free Software Foundation, Inc.
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.

