package hwapi

import (
	"strings"
)

type brandNameMetaBl struct {
	xeon    bool
	pentium bool
	core    bool
	atom    bool
	celeron bool
	itanium bool
	name    string
}

var (
	//TXTUnSupportedCPUs is a lookup table for CPUs not supporting TXT
	TXTUnSupportedCPUs = []brandNameMetaBl{
		{false, false, false, false, true, false, "310 "},
		{false, false, false, false, true, false, "315 "},
		{false, false, false, false, true, false, "315J "},
		{false, false, false, false, true, false, "320 "},
		{false, false, false, false, true, false, "325 "},
		{false, false, false, false, true, false, "325J "},
		{false, false, false, false, true, false, "326 "},
		{false, false, false, false, true, false, "330 "},
		{false, false, false, false, true, false, "330J "},
		{false, false, false, false, true, false, "331 "},
		{false, false, false, false, true, false, "335 "},
		{false, false, false, false, true, false, "335J "},
		{false, false, false, false, true, false, "336 "},
		{false, false, false, false, true, false, "340 "},
		{false, false, false, false, true, false, "340J "},
		{false, false, false, false, true, false, "341 "},
		{false, false, false, false, true, false, "345 "},
		{false, false, false, false, true, false, "345J "},
		{false, false, false, false, true, false, "346 "},
		{false, false, false, false, true, false, "350 "},
		{false, false, false, false, true, false, "350J "},
		{false, false, false, false, true, false, "351 "},
		{false, false, false, false, true, false, "352 "},
		{false, false, false, false, true, false, "355 "},
		{false, false, false, false, true, false, "356 "},
		{false, false, false, false, true, false, "360 "},
		{false, false, false, false, true, false, "310 "},
		{false, false, false, false, true, false, "320 "},
		{false, false, false, false, true, false, "330 "},
		{false, false, false, false, true, false, "340 "},
		{false, false, false, false, true, false, "350 "},
		{false, false, false, false, true, false, "360 "},
		{false, false, false, false, true, false, "370 "},
		{false, false, false, false, true, false, "380 "},
		{false, false, false, false, true, false, "390 "},
		{false, false, false, false, true, false, "410 "},
		{false, false, false, false, true, false, "420 "},
		{false, false, false, false, true, false, "430 "},
		{false, false, false, false, true, false, "440 "},
		{false, false, false, false, true, false, "450 "},
		{false, false, false, false, true, false, "333 "},
		{false, false, false, false, true, false, "353 "},
		{false, false, false, false, true, false, "373 "},
		{false, false, false, false, true, false, "383 "},
		{false, false, false, false, true, false, "423 "},
		{true, false, false, false, false, false, "3040 "},
		{true, false, false, false, false, false, "3050 "},
		{true, false, false, false, false, false, "3060 "},
		{true, false, false, false, false, false, "3070 "},
		{true, false, false, false, false, false, "5030 "},
		{true, false, false, false, false, false, "5040 "},
		{true, false, false, false, false, false, "5050 "},
		{true, false, false, false, false, false, "5060 "},
		{true, false, false, false, false, false, "5070 "},
		{true, false, false, false, false, false, "5080 "},
		{true, false, false, false, false, false, "5110 "},
		{true, false, false, false, false, false, "5120 "},
		{true, false, false, false, false, false, "5130 "},
		{true, false, false, false, false, false, "5140 "},
		{true, false, false, false, false, false, "5150 "},
		{true, false, false, false, false, false, "5160 "},
		{true, false, false, false, false, false, "5148 "},
		{true, false, false, false, false, false, "7020 "},
		{true, false, false, false, false, false, "7030 "},
		{true, false, false, false, false, false, "7040 "},
		{true, false, false, false, false, false, "7041 "},
		{false, false, true, false, false, false, "L2300 "},
		{false, false, true, false, false, false, "L2400 "},
		{false, false, true, false, false, false, "L2500 "},
		{false, false, true, false, false, false, "T2050 "},
		{false, false, true, false, false, false, "T2250 "},
		{false, false, true, false, false, false, "T2300 "},
		{false, false, true, false, false, false, "T2300E "},
		{false, false, true, false, false, false, "T2400 "},
		{false, false, true, false, false, false, "T2500 "},
		{false, false, true, false, false, false, "T2600 "},
		{false, false, true, false, false, false, "T2700 "},
		{false, false, true, false, false, false, "U2400 "},
		{false, false, true, false, false, false, "U2500 "},
		{false, false, true, false, false, false, "T1300 "},
		{false, false, true, false, false, false, "T1350 "},
		{false, false, true, false, false, false, "T1400 "},
		{false, false, true, false, false, false, "U1300 "},
		{false, false, true, false, false, false, "U1400 "},
		{false, false, true, false, false, false, "E6300 "},
		{false, false, true, false, false, false, "E6400 "},
		{false, false, true, false, false, false, "E6600 "},
		{false, false, true, false, false, false, "E6700 "},
		{false, false, true, false, false, false, "T5200 "},
		{false, false, true, false, false, false, "T5500 "},
		{false, false, true, false, false, false, "T5600 "},
		{false, false, true, false, false, false, "T7200 "},
		{false, false, true, false, false, false, "T7400 "},
		{false, false, true, false, false, false, "T7600 "},
		{false, false, true, false, false, false, "X6800 "},
		{true, false, false, false, false, false, "7110M "},
		{true, false, false, false, false, false, "7110N "},
		{true, false, false, false, false, false, "7120M "},
		{true, false, false, false, false, false, "7120N "},
		{true, false, false, false, false, false, "7130M "},
		{true, false, false, false, false, false, "7130N "},
		{true, false, false, false, false, false, "7140M "},
		{true, false, false, false, false, false, "7140N "},
		{false, true, false, false, false, false, "518 "},
		{false, true, false, false, false, false, "532 "},
		{false, true, false, false, false, false, "538 "},
		{false, true, false, false, false, false, "548 "},
		{false, true, false, false, false, false, "552 "},
		{false, true, false, false, false, false, "517 "},
		{false, true, false, false, false, false, "520 "},
		{false, true, false, false, false, false, "521 "},
		{false, true, false, false, false, false, "530 "},
		{false, true, false, false, false, false, "531 "},
		{false, true, false, false, false, false, "540 "},
		{false, true, false, false, false, false, "541 "},
		{false, true, false, false, false, false, "550 "},
		{false, true, false, false, false, false, "551 "},
		{false, true, false, false, false, false, "560 "},
		{false, true, false, false, false, false, "561 "},
		{false, true, false, false, false, false, "570 "},
		{false, true, false, false, false, false, "571 "},
		{false, true, false, false, false, false, "630 "},
		{false, true, false, false, false, false, "631 "},
		{false, true, false, false, false, false, "640 "},
		{false, true, false, false, false, false, "641 "},
		{false, true, false, false, false, false, "650 "},
		{false, true, false, false, false, false, "651 "},
		{false, true, false, false, false, false, "660 "},
		{false, true, false, false, false, false, "661 "},
		{false, true, false, false, false, false, "662 "},
		{false, true, false, false, false, false, "670 "},
		{false, true, false, false, false, false, "672 "},
		{false, true, false, false, false, false, "805 "},
		{false, true, false, false, false, false, "820 "},
		{false, true, false, false, false, false, "830 "},
		{false, true, false, false, false, false, "840 "},
		{false, true, false, false, false, false, "915 "},
		{false, true, false, false, false, false, "920 "},
		{false, true, false, false, false, false, "925 "},
		{false, true, false, false, false, false, "930 "},
		{false, true, false, false, false, false, "940 "},
		{false, true, false, false, false, false, "945 "},
		{false, true, false, false, false, false, "950 "},
		{false, true, false, false, false, false, "960 "},
		{false, true, false, false, false, false, "705 "},
		{false, true, false, false, false, false, "715 "},
		{false, true, false, false, false, false, "725 "},
		{false, true, false, false, false, false, "730 "},
		{false, true, false, false, false, false, "735 "},
		{false, true, false, false, false, false, "740 "},
		{false, true, false, false, false, false, "745 "},
		{false, true, false, false, false, false, "745A "},
		{false, true, false, false, false, false, "750 "},
		{false, true, false, false, false, false, "755 "},
		{false, true, false, false, false, false, "760 "},
		{false, true, false, false, false, false, "765 "},
		{false, true, false, false, false, false, "770 "},
		{false, true, false, false, false, false, "780 "},
		{false, true, false, false, false, false, "718 "},
		{false, true, false, false, false, false, "738 "},
		{false, true, false, false, false, false, "758 "},
		{false, true, false, false, false, false, "778 "},
		{false, true, false, false, false, false, "713 "},
		{false, true, false, false, false, false, "723 "},
		{false, true, false, false, false, false, "733 "},
		{false, true, false, false, false, false, "753 "},
		{false, true, false, false, false, false, "773 "},
		{false, true, false, false, false, false, "840 "},
		{false, true, false, false, false, false, "955 "},
		{false, true, false, false, false, false, "965 "},
		{false, false, false, false, true, false, "347 "},
		{false, false, false, false, true, false, "365 "},
		{false, false, false, false, true, false, "520 "},
		{false, false, false, false, true, false, "443 "},
		{false, false, false, false, false, true, "9010 "},
		{false, false, false, false, false, true, "9015 "},
		{false, false, false, false, false, true, "9020 "},
		{false, false, false, false, false, true, "9030 "},
		{false, false, false, false, false, true, "9040 "},
		{false, false, false, false, false, true, "9050 "},
		{false, true, false, false, false, false, "935 "},
		{true, false, false, false, false, false, "5063 "},
		{false, true, false, false, false, false, "T2060 "},
		{false, false, true, false, false, false, "U1500 "},
		{false, false, true, false, false, false, "E4300 "},
		{false, false, true, false, false, false, "L7200 "},
		{false, false, true, false, false, false, "L7400 "},
		{false, false, true, false, false, false, "QX6700 "},
		{true, false, false, false, false, false, "7150N "},
		{true, false, false, false, false, false, "E5310 "},
		{true, false, false, false, false, false, "E5320 "},
		{true, false, false, false, false, false, "E5345 "},
		{true, false, false, false, false, false, "X3210 "},
		{true, false, false, false, false, false, "X3220 "},
		{true, false, false, false, false, false, "X5355 "},
		{true, false, false, false, false, false, "E5335 "},
		{false, false, false, false, true, false, "530 "},
		{false, false, false, false, true, false, "420 "},
		{false, false, false, false, true, false, "430 "},
		{false, false, false, false, true, false, "440 "},
		{false, true, false, false, false, false, "E2140 "},
		{false, true, false, false, false, false, "E2160 "},
		{false, true, false, false, false, false, "T2080 "},
		{false, false, true, false, false, false, "T2350 "},
		{false, false, true, false, false, false, "T2450 "},
		{false, false, true, false, false, false, "E4400 "},
		{false, false, true, false, false, false, "E6320 "},
		{false, false, true, false, false, false, "E6420 "},
		{false, false, true, false, false, false, "L7300 "},
		{false, false, true, false, false, false, "L7500 "},
		{false, false, true, false, false, false, "T5300 "},
		{false, false, true, false, false, false, "T7100 "},
		{false, false, true, false, false, false, "T7300 "},
		{false, false, true, false, false, false, "T7500 "},
		{false, false, true, false, false, false, "T7700 "},
		{false, false, true, false, false, false, "U7500 "},
		{false, false, true, false, false, false, "U7600 "},
		{false, false, true, false, false, false, "Q6600 "},
		{true, false, false, false, false, false, "L5320 "},
		{true, false, false, false, false, false, "L5310 "},
		{true, false, false, false, false, false, "5128 "},
		{true, false, false, false, false, false, "5133 "},
		{true, false, false, false, false, false, "5138 "},
		{true, false, false, false, false, false, "X5365 "},
		{false, false, true, false, false, false, "QX6800 "},
		{false, true, false, false, false, false, "T2130 "},
		{false, false, false, false, true, false, "540 "},
		{true, false, false, false, false, false, "5113 "},
		{true, false, false, false, false, false, "E7210 "},
		{true, false, false, false, false, false, "E7220 "},
		{false, false, true, false, false, false, "E4500 "},
		{false, false, true, false, false, false, "E6540 "},
		{false, false, true, false, false, false, "T5250 "},
		{false, false, true, false, false, false, "T5450 "},
		{false, false, true, false, false, false, "X7800 "},
		{false, false, true, false, false, false, "QX6850 "},
		{false, false, true, false, false, false, "Q6700 "},
		{true, false, false, false, false, false, "E7310 "},
		{true, false, false, false, false, false, "E7320 "},
		{true, false, false, false, false, false, "E7330 "},
		{true, false, false, false, false, false, "E7340 "},
		{true, false, false, false, false, false, "X7350 "},
		{true, false, false, false, false, false, "X3230 "},
		{false, false, false, false, true, false, "550 "},
		{false, false, true, false, false, false, "T7250 "},
		{false, false, true, false, false, false, "T7800 "},
		{false, false, true, false, false, false, "X7900 "},
		{false, false, false, false, false, true, "9150M "},
		{false, true, false, false, false, false, "E2180 "},
		{false, false, true, false, false, false, "T5470 "},
		{false, false, true, false, false, false, "U2100 "},
		{false, false, true, false, false, false, "U2200 "},
		{false, false, false, false, false, true, "9110N "},
		{false, false, false, false, false, true, "9120N "},
		{false, false, false, false, false, true, "9130M "},
		{false, false, false, false, false, true, "9140M "},
		{false, false, false, false, false, true, "9140N "},
		{false, false, false, false, false, true, "9150N "},
		{true, false, false, false, false, false, "L7345 "},
		{false, false, false, false, true, false, "523 "},
		{false, false, true, false, false, false, "E4600 "},
		{false, false, true, false, false, false, "L7700 "},
		{false, false, true, false, false, false, "T5550 "},
		{false, true, false, false, false, false, "E2220 "},
		{false, true, false, false, false, false, "T2310 "},
		{false, true, false, false, false, false, "T2330 "},
		{true, false, false, false, false, false, "E5405 "},
		{true, false, false, false, false, false, "E5410 "},
		{true, false, false, false, false, false, "E5430 "},
		{true, false, false, false, false, false, "E5440 "},
		{true, false, false, false, false, false, "E5450 "},
		{true, false, false, false, false, false, "E5462 "},
		{true, false, false, false, false, false, "E5472 "},
		{true, false, false, false, false, false, "X5460 "},
		{true, false, false, false, false, false, "X5482 "},
		{true, false, false, false, false, false, "L5410 "},
		{true, false, false, false, false, false, "L5430 "},
		{true, false, false, false, false, false, "E5205 "},
		{false, false, true, false, false, false, "T5270 "},
		{false, false, true, false, false, false, "T8300 "},
		{false, false, false, false, true, false, "530 "},
		{false, false, false, false, true, false, "220 "},
		{true, false, false, false, false, false, "X5260 "},
		{true, false, false, false, false, false, "X5272 "},
		{false, false, true, false, false, false, "T5750 "},
		{false, false, true, false, false, false, "T8100 "},
		{false, false, true, false, false, false, "T9300 "},
		{false, false, true, false, false, false, "T9500 "},
		{false, false, true, false, false, false, "U7700 "},
		{false, false, true, false, false, false, "QX9650 "},
		{false, true, false, false, false, false, "E2200 "},
		{true, false, false, false, false, false, "E5420 "},
		{true, false, false, false, false, false, "L5420 "},
		{true, false, false, false, false, false, "X3320 "},
		{true, false, false, false, false, false, "X3350 "},
		{true, false, false, false, false, false, "X3360 "},
		{false, false, false, false, true, false, "560 "},
		{false, false, false, false, true, false, "E1200 "},
		{false, false, true, false, false, false, "E4700 "},
		{false, false, true, false, false, false, "X9000 "},
		{false, false, true, false, false, false, "QX9770 "},
		{false, true, false, false, false, false, "T2370 "},
		{true, false, false, false, false, false, "X5450 "},
		{true, false, false, false, false, false, "X5472 "},
		{false, false, false, false, false, true, "9152M "},
		{false, false, true, false, false, false, "QX9775 "},
		{true, false, false, false, false, false, "E3110 "},
		{true, false, false, false, false, false, "L5408 "},
		{true, false, false, false, false, false, "L5238 "},
		{true, false, false, false, false, false, "E5240 "},
		{false, false, false, false, true, false, "E1600 "},
		{false, false, true, false, false, false, "E6405 "},
		{false, false, false, false, true, false, "E1500 "},
		{false, false, false, false, true, false, "E1400 "},
		{true, false, false, false, false, false, "L5318 "},
		{true, false, false, false, false, false, "L5240 "},
		{false, true, false, false, false, false, "T2390 "},
		{false, false, true, false, false, false, "T5670 "},
		{false, false, false, false, true, false, "450 "},
		{false, false, true, false, false, false, "E6305 "},
		{false, false, false, false, true, false, "445 "},
		{true, false, false, false, false, false, "X3353 "},
		{true, false, false, false, false, false, "X3363 "},
		{false, true, false, false, false, false, "E5300 "},
		{true, false, false, false, false, false, "E3113 "},
		{true, false, false, false, false, false, "X3323 "},
		{false, false, true, false, false, false, "E7200 "},
		{true, false, false, false, false, false, "E3120 "},
		{true, false, false, false, false, false, "X5470 "},
		{false, false, true, false, false, false, "X9100 "},
		{true, false, false, false, false, false, "X3330 "},
		{true, false, false, false, false, false, "X3370 "},
		{false, false, false, true, false, false, "Z540 "},
		{false, false, false, true, false, false, "Z530 "},
		{false, false, false, true, false, false, "Z520 "},
		{false, false, false, true, false, false, "Z510 "},
		{false, false, false, true, false, false, "Z500 "},
		{false, false, true, false, false, false, "T5800 "},
		{false, true, false, false, false, false, "T3400 "},
		{false, false, false, true, false, false, "230 "},
		{false, false, false, true, false, false, "330 "},
		{false, false, false, true, false, false, "N270 "},
		{false, false, true, false, false, false, "E7300 "},
		{false, true, false, false, false, false, "E2210 "},
		{false, false, true, false, false, false, "E7400 "},
		{false, false, true, false, false, false, "E7500 "},
		{false, false, true, false, false, false, "Q8200 "},
		{true, false, false, false, false, false, "E5220 "},
		{true, false, false, false, false, false, "X5270 "},
		{false, false, false, false, true, false, "570 "},
		{false, false, false, false, true, false, "575 "},
		{false, false, false, false, true, false, "585 "},
		{true, false, false, false, false, false, "L5215 "},
		{false, false, false, false, true, false, "723 "},
		{false, false, true, false, false, false, "QX9300 "},
		{false, false, false, false, true, false, "722 "},
		{false, false, true, false, false, false, "P7350 "},
		{true, false, false, false, false, false, "L3014 "},
		{true, false, false, false, false, false, "X5492 "},
		{true, false, false, false, false, false, "L7445 "},
		{true, false, false, false, false, false, "L7455 "},
		{true, false, false, false, false, false, "E7430 "},
		{true, false, false, false, false, false, "E7450 "},
		{true, false, false, false, false, false, "E7440 "},
		{true, false, false, false, false, false, "E7420 "},
		{true, false, false, false, false, false, "X7460 "},
		{false, false, true, false, false, false, "T5870 "},
		{true, false, false, false, false, false, "E5502 "},
		{true, false, false, false, false, false, "E5503 "},
		{true, false, false, false, false, false, "E5506 "},
		{true, false, false, false, false, false, "E5507 "},
		{true, false, false, false, false, false, "E5530 "},
		{true, false, false, false, false, false, "E5540 "},
		{true, false, false, false, false, false, "X5550 "},
		{true, false, false, false, false, false, "X5560 "},
		{true, false, false, false, false, false, "X5570 "},
		{true, false, false, false, false, false, "W5580 "},
		{false, false, true, false, false, false, "P7370 "},
		{false, false, false, false, true, false, "T1700 "},
		{false, false, false, false, true, false, "743 "},
		{false, false, true, false, false, false, "i7-920 "},
		{false, false, true, false, false, false, "i7-940 "},
		{false, false, true, false, false, false, "i7-965 "},
		{false, false, true, false, false, false, "i7-950 "},
		{false, false, true, false, false, false, "i7-960 "},
		{false, false, true, false, false, false, "i7-975 "},
		{false, false, true, false, false, false, "Q9500 "},
		{false, true, false, false, false, false, "T3200 "},
		{false, true, false, false, false, false, "E5200 "},
		{false, false, true, false, false, false, "T1250 "},
		{false, true, false, false, false, false, "T4200 "},
		{false, true, false, false, false, false, "T4300 "},
		{false, false, true, false, false, false, "T6600 "},
		{false, false, false, false, true, false, "T3100 "},
		{false, false, true, false, false, false, "Q8400 "},
		{false, false, false, false, true, false, "T1600 "},
		{false, false, true, false, false, false, "Q8300 "},
		{true, false, false, false, false, false, "W3520 "},
		{true, false, false, false, false, false, "W3540 "},
		{true, false, false, false, false, false, "W3550 "},
		{true, false, false, false, false, false, "W3565 "},
		{true, false, false, false, false, false, "W3570 "},
		{true, false, false, false, false, false, "W3580 "},
		{true, false, false, false, false, false, "E5520 "},
		{true, false, false, false, false, false, "L5520 "},
		{false, true, false, false, false, false, "E5400 "},
		{false, false, true, false, false, false, "T6400 "},
		{true, false, false, false, false, false, "E5504 "},
		{true, false, false, false, false, false, "L5506 "},
		{true, false, false, false, false, false, "L5508 "},
		{true, false, false, false, false, false, "L5518 "},
		{false, false, false, false, true, false, "T3000 "},
		{false, true, false, false, false, false, "T4400 "},
		{false, false, false, true, false, false, "Z515 "},
		{false, false, false, true, false, false, "Z550 "},
		{true, false, false, false, false, false, "W3503 "},
		{true, false, false, false, false, false, "W3505 "},
		{false, false, true, false, false, false, "Q8200S "},
		{true, false, false, false, false, false, "X3380 "},
		{false, false, false, true, false, false, "Z530P "},
		{false, false, false, true, false, false, "Z520PT "},
		{false, false, false, true, false, false, "Z510P "},
		{false, false, false, true, false, false, "Z510PT "},
		{true, false, false, false, false, false, "W3530 "},
		{false, false, false, false, true, false, "573 "},
		{false, false, false, true, false, false, "N280 "},
		{false, false, true, false, false, false, "i7-930 "},
		{false, true, false, false, false, false, "E6300 "},
		{false, false, true, false, false, false, "E7600 "},
		{false, false, false, false, true, false, "900 "},
		{true, false, false, false, false, false, "W5590 "},
		{true, false, false, false, false, false, "L5530 "},
		{false, true, false, false, false, false, "SU2700 "},
		{false, false, true, false, false, false, "Q8400S "},
		{false, true, false, false, false, false, "920 "},
		{false, false, true, false, false, false, "P7570 "},
		{false, false, false, true, false, false, "N450 "},
		{false, false, false, false, true, false, "E3200 "},
		{false, false, false, false, true, false, "E3300 "},
		{false, false, false, false, true, false, "E3400 "},
		{false, false, false, false, true, false, "E3500 "},
		{false, false, false, false, true, false, "SU2300 "},
		{false, false, true, false, false, false, "SU7300 "},
		{false, true, false, false, false, false, "E5500 "},
		{false, true, false, false, false, false, "E5700 "},
		{false, true, false, false, false, false, "E5800 "},
		{false, true, false, false, false, false, "E6500 "},
		{false, true, false, false, false, false, "E6500K "},
		{false, true, false, false, false, false, "E6600 "},
		{false, true, false, false, false, false, "E6700 "},
		{false, true, false, false, false, false, "E6800 "},
		{false, false, true, false, false, false, "i5-750 "},
		{false, false, true, false, false, false, "i5-750S "},
		{false, true, false, false, false, false, "T4500 "},
		{false, false, false, true, false, false, "D510 "},
		{false, true, false, false, false, false, "G6950 "},
		{false, false, false, true, false, false, "D410 "},
		{false, false, false, false, true, false, "G1101 "},
		{false, false, true, false, false, false, "i3-350M "},
		{false, false, true, false, false, false, "i5-430M "},
		{false, false, true, false, false, false, "i5-661 "},
		{false, true, false, false, false, false, "G6951 "},
		{false, true, false, false, false, false, "SU4100 "},
		{false, false, false, true, false, false, "N470 "},
		{false, false, true, false, false, false, "i3-530 "},
		{false, false, true, false, false, false, "i3-540 "},
		{false, true, false, false, false, false, "G6960 "},
		{false, false, false, false, true, false, "T3300 "},
		{false, false, false, false, true, false, "P4500 "},
		{false, false, true, false, false, false, "i3-330M "},
		{false, false, true, false, false, false, "i7-980X "},
		{false, false, true, false, false, false, "i7-970 "},
		{false, false, true, false, false, false, "i3-330E "},
		{false, false, false, false, true, false, "P4505 "},
		{false, false, true, false, false, false, "i5-760 "},
		{false, false, true, false, false, false, "i7-875K "},
		{false, false, true, false, false, false, "i3-550 "},
		{false, false, true, false, false, false, "i5-655K "},
		{false, false, true, false, false, false, "i3-370M "},
		{false, false, true, false, false, false, "i3-330UM "},
		{false, false, true, false, false, false, "i5-450M "},
		{false, false, true, false, false, false, "i5-430UM "},
		{false, true, false, false, false, false, "P6000 "},
		{false, true, false, false, false, false, "U5400 "},
		{false, false, false, false, true, false, "U3400 "},
		{false, false, false, true, false, false, "D425 "},
		{false, false, false, true, false, false, "D525 "},
		{false, false, false, true, false, false, "N455 "},
		{false, false, false, true, false, false, "N475 "},
		{false, false, false, true, false, false, "Z600 "},
		{false, false, false, true, false, false, "Z615 "},
		{false, false, false, true, false, false, "Z625 "},
		{false, false, false, true, false, false, "Z560 "},
		{false, false, true, false, false, false, "i5-470UM "},
		{false, false, true, false, false, false, "i3-380UM "},
		{false, true, false, false, false, false, "U5600 "},
		{false, false, false, false, true, false, "U3600 "},
		{false, false, false, true, false, false, "N550 "},
		{false, false, false, false, true, false, "U3405 "},
		{false, true, false, false, false, false, "P6100 "},
		{false, true, false, false, false, false, "P6200 "},
		{false, false, true, false, false, false, "i3-560 "},
		{false, false, true, false, false, false, "i3-380M "},
		{false, false, true, false, false, false, "i5-460M "},
		{false, true, false, false, false, false, "P6300 "},
		{false, false, true, false, false, false, "i5-2300 "},
		{false, false, true, false, false, false, "i5-2500K "},
		{false, false, true, false, false, false, "i7-2600K "},
		{false, false, true, false, false, false, "i7-2630QM "},
		{false, false, true, false, false, false, "i3-2310M "},
		{false, false, true, false, false, false, "i5-2410M "},
		{false, false, false, false, true, false, "P4600 "},
		{false, false, false, true, false, false, "E620 "},
		{false, false, false, true, false, false, "E620T "},
		{false, false, false, true, false, false, "E640 "},
		{false, false, false, true, false, false, "E640T "},
		{false, false, false, true, false, false, "E660 "},
		{false, false, false, true, false, false, "E660T "},
		{false, false, false, true, false, false, "E680 "},
		{false, false, false, true, false, false, "E680T "},
		{false, false, true, false, false, false, "i7-990X "},
		{false, false, true, false, false, false, "i5-480M "},
		{false, false, true, false, false, false, "i3-390M "},
		{false, false, false, false, true, false, "G530 "},
		{false, false, false, false, true, false, "G530T "},
		{false, false, false, false, true, false, "G540 "},
		{false, false, false, false, true, false, "G540T "},
		{false, false, false, false, true, false, "G550 "},
		{false, false, false, false, true, false, "G550T "},
		{false, false, true, false, false, false, "i3-2100 "},
		{false, false, true, false, false, false, "i3-2100T "},
		{false, false, true, false, false, false, "i3-2102 "},
		{false, false, true, false, false, false, "i3-2120 "},
		{false, false, true, false, false, false, "i3-2120T "},
		{false, false, true, false, false, false, "i3-2130 "},
		{false, false, true, false, false, false, "i3-2312M "},
		{false, false, true, false, false, false, "i3-2330E "},
		{false, false, true, false, false, false, "i3-2330M "},
		{false, false, true, false, false, false, "i3-2350M "},
		{false, false, true, false, false, false, "i3-2370M "},
		{false, false, true, false, false, false, "i5-2310 "},
		{false, false, true, false, false, false, "i5-2320 "},
		{false, false, true, false, false, false, "i5-2415M "},
		{false, false, true, false, false, false, "i5-2430M "},
		{false, false, true, false, false, false, "i5-2450M "},
		{false, false, true, false, false, false, "i7-2635QM "},
		{false, false, true, false, false, false, "i7-2670QM "},
		{false, false, true, false, false, false, "i7-2675QM "},
		{false, true, false, false, false, false, "G620 "},
		{false, true, false, false, false, false, "G620T "},
		{false, true, false, false, false, false, "G622 "},
		{false, true, false, false, false, false, "G630 "},
		{false, true, false, false, false, false, "G630T "},
		{false, true, false, false, false, false, "G632 "},
		{false, true, false, false, false, false, "G640 "},
		{false, true, false, false, false, false, "G640T "},
		{false, true, false, false, false, false, "G840 "},
		{false, true, false, false, false, false, "G850 "},
		{false, true, false, false, false, false, "G860 "},
		{false, true, false, false, false, false, "G870 "},
		{false, false, false, false, true, false, "763 "},
		{false, false, false, false, true, false, "925 "},
		{false, false, true, false, false, false, "i3-2357M "},
		{false, false, true, false, false, false, "i3-2310E "},
		{false, false, true, false, false, false, "i3-2340UE "},
		{false, false, true, false, false, false, "i3-2377M "},
		{false, false, true, false, false, false, "i5-2405S "},
		{false, false, true, false, false, false, "i3-2105 "},
		{false, true, false, false, false, false, "B940 "},
		{false, true, false, false, false, false, "B950 "},
		{false, true, false, false, false, false, "957 "},
		{false, false, false, true, false, false, "N570 "},
		{false, false, false, false, true, false, "B810 "},
		{false, false, false, false, true, false, "B810E "},
		{false, false, false, false, true, false, "847E "},
		{false, false, false, false, true, false, "827E "},
		{false, false, false, false, true, false, "847 "},
		{false, false, true, false, false, false, "i5-2467M "},
		{false, false, true, false, false, false, "i7-980 "},
		{false, false, false, false, true, false, "G440 "},
		{false, false, false, true, false, false, "N2600 "},
		{false, false, false, true, false, false, "N2800 "},
		{false, false, true, false, false, false, "i3-2125 "},
		{false, false, false, false, true, false, "B710 "},
		{false, false, false, false, true, false, "B800 "},
		{false, false, false, false, true, false, "787 "},
		{false, false, false, false, true, false, "857 "},
		{false, false, true, false, false, false, "i3-2367M "},
		{false, false, false, false, true, false, "B840 "},
		{false, true, false, false, false, false, "967 "},
		{false, true, false, false, false, false, "B960 "},
		{false, false, true, false, false, false, "i5-2435M "},
		{false, true, false, false, false, false, "350 "},
		{false, false, true, false, false, false, "i7-2700K "},
		{false, false, false, false, true, false, "807UE "},
		{false, false, true, false, false, false, "i7-3960X "},
		{false, false, true, false, false, false, "i7-3930K "},
		{false, false, true, false, false, false, "i7-3820 "},
		{false, false, false, false, true, false, "G460 "},
		{false, true, false, false, false, false, "B970 "},
		{false, true, false, false, false, false, "977 "},
		{false, false, false, false, true, false, "797 "},
		{false, false, false, false, true, false, "867 "},
		{false, false, false, false, true, false, "B815 "},
		{false, false, false, false, true, false, "B720 "},
		{false, false, true, false, false, false, "i5-2450P "},
		{false, false, true, false, false, false, "i5-2380P "},
		{false, false, true, false, false, false, "i7-3610QM "},
		{false, false, true, false, false, false, "i7-3615QM "},
		{false, false, true, false, false, false, "i7-3612QM "},
		{false, false, true, false, false, false, "i5-3330 "},
		{false, false, true, false, false, false, "i5-3330S "},
		{false, false, true, false, false, false, "i5-3450 "},
		{false, false, true, false, false, false, "i5-3450S "},
		{false, false, true, false, false, false, "i5-3570K "},
		{false, false, true, false, false, false, "i7-3770K "},
		{false, true, false, false, false, false, "G2120 "},
		{false, false, true, false, false, false, "i5-2550K "},
		{false, false, true, false, false, false, "i3-3240 "},
		{false, false, true, false, false, false, "i3-3225 "},
		{false, false, true, false, false, false, "i3-3220 "},
		{false, false, true, false, false, false, "i3-3220T "},
		{false, false, true, false, false, false, "i3-3217UE "},
		{false, false, true, false, false, false, "i3-3217U "},
		{false, false, true, false, false, false, "i3-3120ME "},
		{false, false, true, false, false, false, "i3-3110M "},
		{false, false, true, false, false, false, "i5-3317U "},
		{false, false, true, false, false, false, "i5-3210M "},
		{false, false, true, false, false, false, "i7-3517U "},
		{false, true, false, false, false, false, "G2100T "},
		{false, false, true, false, false, false, "i3-3240T "},
		{false, true, false, false, false, false, "G860T "},
		{false, false, false, false, true, false, "877 "},
		{false, false, false, false, true, false, "B820 "},
		{false, true, false, false, false, false, "987 "},
		{false, false, true, false, false, false, "i5-3210M "},
		{false, false, true, false, false, false, "i7-3612QM "},
		{false, false, false, false, true, false, "807 "},
		{false, false, true, false, false, false, "i5-3350P "},
		{false, false, false, false, true, false, "G555 "},
		{false, true, false, false, false, false, "G645 "},
		{false, true, false, false, false, false, "997 "},
		{false, false, false, false, true, false, "887 "},
		{false, false, false, false, true, false, "G465 "},
		{false, true, false, false, false, false, "G645T "},
		{false, true, false, false, false, false, "B980 "},
		{false, false, true, false, false, false, "i3-2365M "},
		{false, false, true, false, false, false, "i7-3970X "},
		{false, false, true, false, false, false, "i3-2328M "},
		{false, true, false, false, false, false, "G2130 "},
		{false, false, true, false, false, false, "i3-3210 "},
		{false, true, false, false, false, false, "G2020T "},
		{false, true, false, false, false, false, "G2020 "},
		{false, true, false, false, false, false, "G2010 "},
		{false, false, false, false, true, false, "G1610 "},
		{false, false, false, false, true, false, "G1620 "},
		{false, false, false, false, true, false, "G1610T "},
		{false, true, false, false, false, false, "G2120T "},
		{false, false, false, false, true, false, "B830 "},
		{false, true, false, false, false, false, "2020M "},
		{false, false, true, false, false, false, "i7-3632QM "},
		{false, false, true, false, false, false, "i7-3630QM "},
		{false, false, true, false, false, false, "i7-3635QM "},
		{false, false, true, false, false, false, "i3-3120M "},
		{false, true, false, false, false, false, "2117U "},
		{false, false, true, false, false, false, "i7-3632QM "},
		{false, false, false, false, true, false, "1020M "},
		{false, false, false, false, true, false, "1037U "},
		{false, false, true, false, false, false, "i3-3229Y "},
		{false, false, true, false, false, false, "i5-3339Y "},
		{false, true, false, false, false, false, "2129Y "},
		{false, false, true, false, false, false, "i7-3537U "},
		{false, false, true, false, false, false, "i5-3337U "},
		{false, false, true, false, false, false, "i5-3230M "},
		{false, false, true, false, false, false, "i3-3227U "},
		{false, false, true, false, false, false, "i3-3130M "},
		{false, true, false, false, false, false, "2030M "},
		{false, false, false, false, true, false, "1000M "},
		{false, false, false, false, true, false, "1007U "},
		{false, false, true, false, false, false, "i5-3230M "},
		{false, false, true, false, false, false, "i3-2375M "},
		{false, false, false, false, true, false, "1020E "},
		{false, false, false, false, true, false, "1047UE "},
		{false, false, false, false, true, false, "927UE "},
		{false, false, false, false, true, false, "G470 "},
		{false, false, true, false, false, false, "i3-2348M "},
		{false, false, true, false, false, false, "i3-3250 "},
		{false, false, true, false, false, false, "i3-3250T "},
		{false, false, true, false, false, false, "i3-3245 "},
		{false, true, false, false, false, false, "G2140 "},
		{false, true, false, false, false, false, "G2030T "},
		{false, true, false, false, false, false, "G2030 "},
		{false, false, true, false, false, false, "i5-4200H "},
		{false, false, true, false, false, false, "i5-4250U "},
		{false, false, true, false, false, false, "i5-4260U "},
		{false, false, true, false, false, false, "i5-4430 "},
		{false, false, true, false, false, false, "i5-4430S "},
		{false, false, true, false, false, false, "i5-4440 "},
		{false, false, true, false, false, false, "i5-4440S "},
		{false, false, true, false, false, false, "i5-4670K "},
		{false, false, false, false, true, false, "1019Y "},
		{false, false, true, false, false, false, "i3-4000M "},
		{false, false, true, false, false, false, "i3-4005U "},
		{false, false, true, false, false, false, "i3-4010U "},
		{false, false, true, false, false, false, "i3-4100U "},
		{false, false, true, false, false, false, "i7-4550U "},
		{false, false, true, false, false, false, "i7-4700HQ "},
		{false, false, true, false, false, false, "i7-4700MQ "},
		{false, false, true, false, false, false, "i7-4702HQ "},
		{false, false, true, false, false, false, "i7-4702MQ "},
		{false, false, true, false, false, false, "i7-4770K "},
		{false, true, false, false, false, false, "2127U "},
		{false, false, false, false, true, false, "1017U "},
		{false, false, false, false, true, false, "1005M "},
		{false, false, true, false, false, false, "i5-4200U "},
		{false, false, true, false, false, false, "i7-4500U "},
		{false, false, false, false, true, false, "2955U "},
		{false, false, true, false, false, false, "i5-4200Y "},
		{false, false, true, false, false, false, "i3-4010Y "},
		{false, false, true, false, false, false, "i3-4158U "},
		{false, false, true, false, false, false, "i5-4258U "},
		{false, false, true, false, false, false, "i5-4288U "},
		{false, false, true, false, false, false, "i7-4558U "},
		{false, false, true, false, false, false, "i3-4100E "},
		{false, false, true, false, false, false, "i3-4102E "},
		{false, false, false, false, true, false, "2000E "},
		{false, false, false, false, true, false, "2002E "},
		{false, false, true, false, false, false, "i5-3340 "},
		{false, false, true, false, false, false, "i5-3340S "},
		{false, false, false, false, true, false, "G1630 "},
		{false, false, false, false, true, false, "G1620T "},
		{false, false, true, false, false, false, "i3-4100M "},
		{false, false, true, false, false, false, "i5-4200M "},
		{false, false, true, false, false, false, "i3-4012Y "},
		{false, false, true, false, false, false, "i3-4020Y "},
		{false, false, true, false, false, false, "i5-4202Y "},
		{false, false, true, false, false, false, "i5-4210Y "},
		{false, false, false, false, true, false, "2980U "},
		{false, true, false, false, false, false, "3556U "},
		{false, true, false, false, false, false, "3560Y "},
		{false, false, true, false, false, false, "i5-4570R "},
		{false, false, true, false, false, false, "i5-4670R "},
		{false, false, true, false, false, false, "i7-4770R "},
		{false, false, false, false, true, false, "2950M "},
		{false, true, false, false, false, false, "3550M "},
		{false, false, true, false, false, false, "i3-4130 "},
		{false, false, true, false, false, false, "i3-4130T "},
		{false, false, true, false, false, false, "i3-4110M "},
		{false, false, true, false, false, false, "i3-4150 "},
		{false, false, true, false, false, false, "i3-4150T "},
		{false, false, true, false, false, false, "i3-4160 "},
		{false, false, true, false, false, false, "i3-4160T "},
		{false, false, true, false, false, false, "i3-4170 "},
		{false, false, true, false, false, false, "i3-4350 "},
		{false, false, true, false, false, false, "i3-4350T "},
		{false, false, true, false, false, false, "i3-4360 "},
		{false, false, true, false, false, false, "i3-4360T "},
		{false, false, true, false, false, false, "i3-4370 "},
		{false, false, true, false, false, false, "i3-4330 "},
		{false, false, true, false, false, false, "i3-4330T "},
		{false, false, true, false, false, false, "i3-4340 "},
		{false, true, false, false, false, false, "G3220 "},
		{false, true, false, false, false, false, "G3220T "},
		{false, true, false, false, false, false, "G3420 "},
		{false, true, false, false, false, false, "G3420T "},
		{false, true, false, false, false, false, "G3430 "},
		{false, false, true, false, false, false, "i3-4330TE "},
		{false, false, true, false, false, false, "i7-4960X "},
		{false, false, true, false, false, false, "i7-4930K "},
		{false, false, true, false, false, false, "i7-4820K "},
		{false, true, false, false, false, false, "G3320TE "},
		{false, true, false, false, false, false, "A1018 "},
		{false, false, false, true, false, false, "E3825 "},
		{false, false, false, true, false, false, "E3845 "},
		{false, false, false, true, false, false, "E3815 "},
		{false, false, false, true, false, false, "E3826 "},
		{false, false, false, true, false, false, "E3827 "},
		{false, false, true, false, false, false, "i5-4460T "},
		{false, false, true, false, false, false, "i5-4210H "},
		{false, false, true, false, false, false, "i7-4710HQ "},
		{false, false, true, false, false, false, "i7-4710MQ "},
		{false, false, true, false, false, false, "i7-4712HQ "},
		{false, false, true, false, false, false, "i7-4712MQ "},
		{false, false, true, false, false, false, "i7-4720HQ "},
		{false, false, true, false, false, false, "i7-4722HQ "},
		{false, false, false, false, true, false, "2957U "},
		{false, false, false, false, true, false, "2961Y "},
		{false, false, false, false, true, false, "2981U "},
		{false, true, false, false, false, false, "3558U "},
		{false, true, false, false, false, false, "3561Y "},
		{false, false, false, false, true, false, "G1830 "},
		{false, false, false, false, true, false, "G1820 "},
		{false, false, false, false, true, false, "G1820T "},
		{false, false, false, false, true, false, "G1820TE "},
		{false, false, true, false, false, false, "i3-4110E "},
		{false, false, true, false, false, false, "i3-4112E "},
		{false, true, false, false, false, false, "G3450 "},
		{false, true, false, false, false, false, "G3450T "},
		{false, true, false, false, false, false, "G3440 "},
		{false, true, false, false, false, false, "G3440T "},
		{false, true, false, false, false, false, "G3240 "},
		{false, true, false, false, false, false, "G3240T "},
		{false, false, false, false, true, false, "G1850 "},
		{false, false, false, false, true, false, "G1840 "},
		{false, false, false, false, true, false, "G1840T "},
		{false, false, true, false, false, false, "i7-4790K "},
		{false, false, true, false, false, false, "i5-4690K "},
		{false, false, true, false, false, false, "i5-4460 "},
		{false, false, true, false, false, false, "i5-4460S "},
		{false, false, true, false, false, false, "i3-4340TE "},
		{false, false, true, false, false, false, "i5-4210M "},
		{false, true, false, false, false, false, "3560M "},
		{false, false, false, false, true, false, "2970M "},
		{false, false, true, false, false, false, "i7-4510U "},
		{false, false, true, false, false, false, "i5-4210U "},
		{false, false, true, false, false, false, "i3-4120U "},
		{false, false, true, false, false, false, "i3-4030U "},
		{false, false, true, false, false, false, "i3-4025U "},
		{false, false, true, false, false, false, "i5-4220Y "},
		{false, false, true, false, false, false, "i3-4030Y "},
		{false, false, true, false, false, false, "i3-4370T "},
		{false, false, true, false, false, false, "i3-4170T "},
		{true, false, false, false, false, false, "E5-2685V3 "},
		{false, true, false, false, false, false, "G3258 "},
		{false, false, true, false, false, false, "i7-5960X "},
		{false, false, true, false, false, false, "i7-5930K "},
		{false, false, true, false, false, false, "i7-5820K "},
		{false, true, false, false, false, false, "G3460 "},
		{false, true, false, false, false, false, "G3460T "},
		{false, false, true, false, false, false, "i7-4578U "},
		{false, false, true, false, false, false, "i5-4308U "},
		{false, false, true, false, false, false, "i5-4278U "},
		{false, true, false, false, false, false, "G3250 "},
		{false, true, false, false, false, false, "G3250T "},
		{false, false, true, false, false, false, "5Y10 "},
		{false, false, true, false, false, false, "5Y10a "},
		{false, false, false, true, false, false, "E3805 "},
		{false, false, true, false, false, false, "5Y31 "},
		{false, false, true, false, false, false, "5Y51 "},
		{false, false, true, false, false, false, "i3-5005U "},
		{false, false, true, false, false, false, "i3-5010U "},
		{false, false, true, false, false, false, "i3-5015U "},
		{false, false, true, false, false, false, "i3-5020U "},
		{false, false, false, false, true, false, "3205U "},
		{false, false, false, false, true, false, "3215U "},
		{false, false, false, false, true, false, "3755U "},
		{false, false, false, false, true, false, "3765U "},
		{false, true, false, false, false, false, "3805U "},
		{false, false, true, false, false, false, "i3-5157U "},
		{false, false, true, false, false, false, "i5-5250U "},
		{false, false, true, false, false, false, "i5-5257U "},
		{false, false, true, false, false, false, "i5-5287U "},
		{false, false, true, false, false, false, "i7-5550U "},
		{false, false, true, false, false, false, "i7-5557U "},
		{false, false, true, false, false, false, "i7-5500U "},
		{false, false, true, false, false, false, "5Y10c "},
		{false, true, false, false, false, false, "3825U "},
		{false, false, false, false, true, false, "N3050 "},
		{false, false, false, false, true, false, "N3150 "},
		{false, false, false, false, true, false, "N3000 "},
		{false, true, false, false, false, false, "N3700 "},
		{false, true, false, false, false, false, "G3260 "},
		{false, true, false, false, false, false, "G3260T "},
		{false, true, false, false, false, false, "G3470 "},
		{false, false, true, false, false, false, "i5-5350H "},
		{false, false, true, false, false, false, "i5-5575R "},
		{false, false, true, false, false, false, "i5-5675R "},
		{false, false, true, false, false, false, "i7-5700HQ "},
		{false, false, true, false, false, false, "i7-5750HQ "},
		{false, false, true, false, false, false, "i7-5775R "},
		{false, false, true, false, false, false, "i7-5850HQ "},
		{false, false, true, false, false, false, "i7-5950HQ "},
		{false, false, true, false, false, false, "i7-5775C "},
		{false, false, true, false, false, false, "i5-5675C "},
		{false, true, false, false, false, false, "G4400 "},
		{false, false, true, false, false, false, "i3-6100U "},
		{false, false, true, false, false, false, "i3-6100TE "},
		{false, false, true, false, false, false, "i5-6400 "},
		{false, false, true, false, false, false, "i5-6400T "},
		{false, false, true, false, false, false, "i5-6600K "},
		{false, false, true, false, false, false, "i5-6200U "},
		{false, false, true, false, false, false, "i7-6500U "},
		{false, false, true, false, false, false, "i7-6700K "},
		{false, false, true, false, false, false, "M3-6Y30 "},
		{false, false, true, false, false, false, "M5-6Y54 "},
		{false, false, true, false, false, false, "i5-6300HQ "},
		{false, false, true, false, false, false, "i7-6700HQ "},
		{false, false, true, false, false, false, "i7-6820HK "},
		{false, false, true, false, false, false, "i3-6100H "},
		{false, true, false, false, false, false, "4405U "},
		{false, true, false, false, false, false, "4405Y "},
		{false, true, false, false, false, false, "G4400TE "},
		{false, false, true, false, false, false, "i3-6100E "},
		{false, false, true, false, false, false, "i3-6102E "},
		{false, true, false, false, false, false, "G4400T "},
		{false, false, false, false, true, false, "G3902E "},
		{false, false, false, false, true, false, "G3900TE "},
		{false, false, false, false, true, false, "G3900E "},
		{false, true, false, false, false, false, "G4500T "},
		{false, false, true, false, false, false, "i3-6300T "},
		{false, false, true, false, false, false, "i3-6100 "},
		{false, true, false, false, false, false, "G4500 "},
		{false, false, true, false, false, false, "i3-6300 "},
		{false, true, false, false, false, false, "G4520 "},
		{false, false, true, false, false, false, "i3-6320 "},
		{false, false, true, false, false, false, "i3-6100T "},
		{false, false, false, false, true, false, "G3920 "},
		{false, false, false, false, true, false, "G3900T "},
		{false, false, false, false, true, false, "G3900 "},
		{false, false, true, false, false, false, "i3-6167U "},
		{false, false, true, false, false, false, "i3-6006U "},
		{false, false, true, false, false, false, "i5-6260U "},
		{false, false, true, false, false, false, "i7-6560U "},
		{false, false, true, false, false, false, "i5-6287U "},
		{false, false, true, false, false, false, "i5-6267U "},
		{false, false, true, false, false, false, "i7-6567U "},
		{false, true, false, false, false, false, "J3710 "},
		{false, false, false, false, true, false, "J3160 "},
		{false, false, false, false, true, false, "J3060 "},
		{false, false, false, false, true, false, "N3010 "},
		{false, true, false, false, false, false, "N3710 "},
		{false, false, false, false, true, false, "N3160 "},
		{false, false, false, false, true, false, "N3060 "},
		{false, false, false, false, true, false, "3855U "},
		{false, false, false, false, true, false, "3955U "},
		{false, false, true, false, false, false, "i5-6402P "},
		{false, false, true, false, false, false, "i5-6350HQ "},
		{false, false, true, false, false, false, "i7-6970HQ "},
		{false, false, true, false, false, false, "i7-6870HQ "},
		{false, false, true, false, false, false, "i7-6770HQ "},
		{false, false, true, false, false, false, "i3-6098P "},
		{false, false, true, false, false, false, "i7-6498DU "},
		{false, false, true, false, false, false, "i5-6198DU "},
		{false, false, true, false, false, false, "i7-6850K "},
		{false, false, true, false, false, false, "i7-6800K "},
		{false, false, true, false, false, false, "i7-6900K "},
		{false, false, true, false, false, false, "i7-6950X "},
		{false, false, true, false, false, false, "i3-7100U "},
		{false, false, true, false, false, false, "i5-7200U "},
		{false, false, true, false, false, false, "M3-7Y30 "},
		{false, false, true, false, false, false, "i7-7500U "},
		{false, false, true, false, false, false, "i5-7Y54 "},
		{false, true, false, false, false, false, "J4205 "},
		{false, true, false, false, false, false, "N4200 "},
		{false, false, false, false, true, false, "J3455 "},
		{false, false, false, false, true, false, "N3450 "},
		{false, false, false, false, true, false, "J3355 "},
		{false, false, false, false, true, false, "N3350 "},
		{false, false, true, false, false, false, "i3-6157U "},
		{false, false, false, true, false, false, "E3940 "},
		{false, false, false, true, false, false, "E3930 "},
		{false, false, false, true, false, false, "E3950 "},
		{false, false, false, false, true, false, "3965U "},
		{false, false, false, false, true, false, "3865U "},
		{false, true, false, false, false, false, "4415U "},
		{false, false, true, false, false, false, "i3-7102E "},
		{false, false, true, false, false, false, "i3-7101TE "},
		{false, false, true, false, false, false, "i3-7100H "},
		{false, false, true, false, false, false, "i3-7101E "},
		{false, false, true, false, false, false, "i3-7100E "},
		{false, true, false, false, false, false, "4410Y "},
		{false, true, false, false, false, false, "G4560 "},
		{false, false, true, false, false, false, "i5-7400 "},
		{false, false, true, false, false, false, "i5-7400T "},
		{false, false, true, false, false, false, "i7-7700HQ "},
		{false, false, false, false, true, false, "G3950 "},
		{false, false, false, false, true, false, "G3930 "},
		{false, true, false, false, false, false, "G4600 "},
		{false, false, true, false, false, false, "i3-7100 "},
		{false, false, true, false, false, false, "i5-7300HQ "},
		{false, false, true, false, false, false, "i3-7300T "},
		{false, false, true, false, false, false, "i3-7300 "},
		{false, true, false, false, false, false, "G4620 "},
		{false, false, true, false, false, false, "i7-7820HK "},
		{false, true, false, false, false, false, "G4560T "},
		{false, false, false, false, true, false, "G3930T "},
		{false, false, true, false, false, false, "i3-7320 "},
		{false, false, true, false, false, false, "i3-7100T "},
		{false, true, false, false, false, false, "G4600T "},
		{false, false, true, false, false, false, "i3-7350K "},
		{false, false, true, false, false, false, "i5-7267U "},
		{false, false, true, false, false, false, "i5-7287U "},
		{false, false, true, false, false, false, "M3-7Y32 "},
		{false, false, true, false, false, false, "i5-7260U "},
		{false, false, true, false, false, false, "i7-7560U "},
		{false, false, true, false, false, false, "i7-7567U "},
		{false, false, true, false, false, false, "i3-7167U "},
		{false, false, true, false, false, false, "i7-8550U "},
		{false, true, false, false, false, false, "4415Y "},
		{false, false, false, false, true, false, "3965Y "},
		{false, false, false, false, true, false, "G3930E "},
		{false, false, false, false, true, false, "G3930TE "},
		{false, false, true, false, false, false, "i5-8250U "},
		{false, false, true, false, false, false, "i3-7130U "},
		{false, false, true, false, false, false, "i5-8400 "},
		{false, false, true, false, false, false, "i3-8100 "},
		{false, false, true, false, false, false, "i3-8350K "},
		{false, false, true, false, false, false, "i7-8709G "},
		{false, false, true, false, false, false, "i5-8305G "},
		{false, false, true, false, false, false, "i7-8809G "},
		{false, false, true, false, false, false, "i7-8705G "},
	}
)

//CPUBlacklistTXTSupport - Returns true if the CPU is blacklisted
func (t TxtAPI) CPUBlacklistTXTSupport() bool {

	cpuName := t.ProcessorBrandName()

	for i := range TXTUnSupportedCPUs {
		if TXTUnSupportedCPUs[i].xeon && !strings.Contains(cpuName, "Xeon") {
			continue
		}
		if TXTUnSupportedCPUs[i].pentium && !strings.Contains(cpuName, "Pentium") {
			continue
		}
		if TXTUnSupportedCPUs[i].core && !strings.Contains(cpuName, "Core") {
			continue
		}
		if TXTUnSupportedCPUs[i].atom && !strings.Contains(cpuName, "Atom") {
			continue
		}
		if TXTUnSupportedCPUs[i].celeron && !strings.Contains(cpuName, "Celeron") {
			continue
		}
		if TXTUnSupportedCPUs[i].itanium && !strings.Contains(cpuName, "Itanium") {
			continue
		}

		if strings.Contains(cpuName, TXTUnSupportedCPUs[i].name) {
			return true
		}
	}
	return false
}
