/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.gns;

import org.gnunet.gns.LookupResultProcessor;
import org.gnunet.gns.messages.ClientLookupMessage;
import org.gnunet.gns.messages.ClientLookupResultMessage;
import org.gnunet.requests.FixedMessageRequest;
import org.gnunet.requests.MatchingRequestContainer;
import org.gnunet.requests.RequestIdentifier;
import org.gnunet.util.Cancelable;
import org.gnunet.util.Client;
import org.gnunet.util.Configuration;
import org.gnunet.util.RelativeTime;
import org.gnunet.util.RunaboutMessageReceiver;
import org.gnunet.util.Scheduler;
import org.gnunet.util.crypto.EcdsaPrivateKey;
import org.gnunet.util.crypto.EcdsaPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gns {
    private static final Logger logger = LoggerFactory.getLogger(Gns.class);
    public static final int LOOKUP_OPTION_DEFAULT = 0;
    public static final int LOOKUP_OPTION_NO_DHT = 1;
    public static final int LOOKUP_OPTION_LOCAL_MASTER = 2;
    private MatchingRequestContainer<Long, FixedMessageRequest<LookupResultProcessor>> lookupRequests;
    private long nextUID = 1L;
    private Client client;
    private RelativeTime reconnectBackoff = RelativeTime.STD_BACKOFF;

    public Gns(Configuration cfg) {
        this.client = new Client("gns", cfg);
        this.lookupRequests = new MatchingRequestContainer(this.client);
        this.client.installReceiver(new GNSMessageReceiver());
    }

    public Cancelable lookup(String name, EcdsaPublicKey zone, long type, int lookupOption, EcdsaPrivateKey shortenZoneKey, LookupResultProcessor proc) {
        ClientLookupMessage m = new ClientLookupMessage();
        if (null != shortenZoneKey) {
            m.haveKey = 1;
            m.shortenKey = shortenZoneKey;
        } else {
            m.haveKey = 0;
            m.shortenKey = EcdsaPrivateKey.zeroKey();
        }
        m.id = this.nextUID++;
        m.name = name;
        m.onlyCached = lookupOption;
        m.type = type;
        m.zone = zone;
        return this.lookupRequests.addRequest(m.id, new FixedMessageRequest<LookupResultProcessor>(m, proc));
    }

    public void disconnect() {
        this.client.disconnect();
        this.client = null;
    }

    public class GNSMessageReceiver
    extends RunaboutMessageReceiver {
        public void visit(ClientLookupResultMessage m) {
            RequestIdentifier r = Gns.this.lookupRequests.getRequestIdentifier(m.id);
            if (null == r) {
                logger.warn("no matching getRequestIdentifier for lookup result");
                return;
            }
            ((LookupResultProcessor)((FixedMessageRequest)r.getRequest()).getContext()).process(m.records);
        }

        @Override
        public void handleError() {
            logger.warn("Error receiving from GNS service, reconnecting.");
            Scheduler.addDelayed(Gns.this.reconnectBackoff, new Scheduler.Task(){

                @Override
                public void run(Scheduler.RunContext ctx) {
                    Gns.this.client.reconnect();
                    Gns.this.lookupRequests.restart();
                }
            });
            Gns.this.reconnectBackoff = Gns.this.reconnectBackoff.backoff();
        }
    }
}

