/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.statistics;

import org.gnunet.requests.MatchingRequestContainer;
import org.gnunet.requests.RequestIdentifier;
import org.gnunet.requests.SequentialRequestContainer;
import org.gnunet.requests.TimeoutHandler;
import org.gnunet.statistics.GetRequest;
import org.gnunet.statistics.StatisticsReceiver;
import org.gnunet.statistics.StatisticsWatcher;
import org.gnunet.statistics.WatchRequest;
import org.gnunet.statistics.messages.GetResponseEndMessage;
import org.gnunet.statistics.messages.GetResponseMessage;
import org.gnunet.statistics.messages.SetMessage;
import org.gnunet.statistics.messages.WatchResponseMessage;
import org.gnunet.util.Cancelable;
import org.gnunet.util.Client;
import org.gnunet.util.Configuration;
import org.gnunet.util.RelativeTime;
import org.gnunet.util.RunaboutMessageReceiver;
import org.gnunet.util.Scheduler;
import org.gnunet.util.TestMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Statistics {
    private static final Logger logger = LoggerFactory.getLogger(Statistics.class);
    private Client client;
    private final SequentialRequestContainer<GetRequest> getRequests;
    private final MatchingRequestContainer<Long, WatchRequest> watchRequests;
    private boolean destroyRequested;
    private long nextWatchId = 0L;
    private Scheduler.TaskIdentifier destroyTimeout;

    public Statistics(Configuration cfg) {
        this.client = new Client("statistics", cfg);
        this.client.installReceiver(new StatisticsMessageReceiver());
        this.getRequests = new SequentialRequestContainer(this.client);
        this.watchRequests = new MatchingRequestContainer(this.client);
    }

    public Cancelable get(RelativeTime timeout, String subsystem, String name, final StatisticsReceiver receiver) {
        if (this.destroyRequested || this.client == null) {
            throw new AssertionError((Object)"already destroyed");
        }
        RequestIdentifier<GetRequest> identifier = this.getRequests.addRequest(new GetRequest(subsystem, name, receiver));
        identifier.setTimeout(timeout, new TimeoutHandler(){

            @Override
            public void onTimeout() {
                receiver.onTimeout();
            }
        });
        return identifier;
    }

    public Cancelable get(RelativeTime timeout, String subsystem, StatisticsReceiver receiver) {
        return this.get(timeout, subsystem, "", receiver);
    }

    public void set(String subsystem, String name, long value, boolean persist) {
        if (this.destroyRequested || this.client == null) {
            throw new AssertionError((Object)"already destroyed");
        }
        SetMessage m = new SetMessage();
        m.statisticName = name;
        m.subsystemName = subsystem;
        m.value = value;
        if (persist) {
            m.flags |= 2;
        }
        this.client.send(m);
    }

    public void update(String subsystem, String name, long delta, boolean persist) {
        if (this.destroyRequested || null == this.client) {
            throw new AssertionError((Object)"already destroyed");
        }
        SetMessage m = new SetMessage();
        m.statisticName = name;
        m.subsystemName = subsystem;
        m.value = delta;
        if (persist) {
            m.flags |= 2;
        }
        m.flags |= 1;
        this.client.send(m);
    }

    public Cancelable watch(String subsystem, String name, StatisticsWatcher watcher) {
        if (this.destroyRequested || null == this.client) {
            throw new AssertionError((Object)"already destroyed");
        }
        WatchRequest r = new WatchRequest(subsystem, name, watcher);
        return this.watchRequests.addRequest(this.nextWatchId++, r);
    }

    public void destroy() {
        this.destroy(true);
    }

    public void destroy(boolean syncFirst) {
        if (this.destroyRequested) {
            throw new AssertionError((Object)"already destroyed");
        }
        this.destroyRequested = true;
        logger.debug("destroying statistics");
        if (!syncFirst || !this.client.isConnected()) {
            this.client.disconnect();
            this.client = null;
            return;
        }
        this.client.send(new TestMessage());
        this.destroyTimeout = Scheduler.addDelayed(RelativeTime.fromSeconds(5L), new Scheduler.Task(){

            @Override
            public void run(Scheduler.RunContext ctx) {
                if (null == Statistics.this.client) {
                    return;
                }
                Statistics.this.client.disconnect();
                Statistics.this.client = null;
            }
        });
    }

    public class StatisticsMessageReceiver
    extends RunaboutMessageReceiver {
        public void visit(GetResponseMessage m) {
            RequestIdentifier r = Statistics.this.getRequests.getRequestIdentifier();
            if (r != null) {
                ((GetRequest)r.getRequest()).receiver.onReceive(m.subsystemName, m.statisticName, m.value);
            }
        }

        public void visit(GetResponseEndMessage m) {
            RequestIdentifier r = Statistics.this.getRequests.getRequestIdentifier();
            if (r != null) {
                r.retire();
                ((GetRequest)r.getRequest()).receiver.onDone();
            }
        }

        public void visit(TestMessage m) {
            if (null != Statistics.this.destroyTimeout) {
                Statistics.this.destroyTimeout.cancel();
                Statistics.this.destroyTimeout = null;
            } else {
                logger.error("protocol violation: destroy timeout is 'null' but got test message");
            }
            Statistics.this.client.disconnect();
        }

        public void visit(WatchResponseMessage wrm) {
            RequestIdentifier ri = Statistics.this.watchRequests.getRequestIdentifier(Long.valueOf(wrm.wid));
            WatchRequest r = (WatchRequest)ri.getRequest();
            if (r != null) {
                r.watcher.onReceive(r.subsystem, r.name, wrm.value);
            }
        }

        @Override
        public void handleError() {
            if (null == Statistics.this.client) {
                throw new AssertionError();
            }
            if (!Statistics.this.destroyRequested) {
                Statistics.this.client.reconnect();
                Statistics.this.getRequests.restart();
                Statistics.this.watchRequests.restart();
            }
            if (null != Statistics.this.destroyTimeout) {
                Statistics.this.destroyTimeout.cancel();
                Statistics.this.destroyTimeout = null;
            }
        }
    }
}

