/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.statistics;

import org.gnunet.statistics.Statistics;
import org.gnunet.statistics.StatisticsReceiver;
import org.gnunet.statistics.StatisticsWatcher;
import org.gnunet.util.Program;
import org.gnunet.util.RelativeTime;
import org.gnunet.util.getopt.Argument;
import org.gnunet.util.getopt.ArgumentAction;

public class StatisticsTool
extends Program {
    @Argument(shortname="x", longname="set", action=ArgumentAction.SET, description="set a value")
    boolean set;
    @Argument(shortname="w", longname="watch", action=ArgumentAction.SET, description="watch a value")
    boolean watch;
    @Argument(shortname="n", longname="name", action=ArgumentAction.STORE_STRING, argumentName="NAME", description="statistics name")
    String statisticsName = "";
    @Argument(shortname="s", longname="subsystem", argumentName="SUBSYS", action=ArgumentAction.STORE_STRING, description="subsystem name")
    String subsystemName = "";
    @Argument(shortname="p", longname="persistent", action=ArgumentAction.SET, description="set value persistently (used with -x)")
    boolean persistent = false;
    @Argument(shortname="r", longname="relative", action=ArgumentAction.SET, description="set value relative to old value (used with -x)")
    boolean relative = false;
    Statistics statistics;

    public static void main(String[] args) {
        StatisticsTool statisticsTool = new StatisticsTool();
        int ret = statisticsTool.start(args);
        System.exit(ret);
    }

    @Override
    protected String makeHelpText() {
        return "Get, set and watch GNUnet's statistics.";
    }

    @Override
    public void run() {
        if (this.set && this.watch) {
            System.err.println("--watch/-w and --set/-s cannot be used together");
            return;
        }
        if (this.set) {
            long value;
            if (this.subsystemName.isEmpty() || this.statisticsName.isEmpty()) {
                System.err.println("both subsystem and name must be given for --set/-x");
                return;
            }
            if (this.unprocessedArgs.length != 1) {
                System.err.println("must specify exactly one value to set");
                return;
            }
            try {
                value = Long.parseLong(this.unprocessedArgs[0]);
            }
            catch (NumberFormatException e) {
                System.err.println("invalid value (not a long)");
                return;
            }
            this.statistics = new Statistics(this.cfg);
            if (this.relative) {
                this.statistics.update(this.subsystemName, this.statisticsName, value, this.persistent);
            } else {
                this.statistics.set(this.subsystemName, this.statisticsName, value, this.persistent);
            }
            this.statistics.destroy();
            return;
        }
        if (this.unprocessedArgs.length != 0) {
            System.err.println("watching or reading statistics does not take any positional parameters");
            return;
        }
        if (this.watch) {
            if (this.subsystemName.isEmpty() || this.statisticsName.isEmpty()) {
                System.err.println("both subsystem and name must be given for --watch/-w");
                return;
            }
            this.statistics = new Statistics(this.cfg);
            this.statistics.watch(this.subsystemName, this.statisticsName, new StatisticsWatcher(){

                @Override
                public void onReceive(String subsystem, String name, long value) {
                    System.out.println(subsystem + "(" + name + ") = " + value);
                }
            });
        } else {
            this.statistics = new Statistics(this.cfg);
            this.statistics.get(RelativeTime.fromSeconds(5L), this.subsystemName, this.statisticsName, new StatisticsReceiver(){

                @Override
                public void onReceive(String subsystem, String name, long value) {
                    System.out.println(subsystem + "(" + name + ") = " + value);
                }

                @Override
                public void onTimeout() {
                    System.err.println("Statistics 'get' request timed out.");
                    StatisticsTool.this.statistics.destroy();
                }

                @Override
                public void onDone() {
                    StatisticsTool.this.statistics.destroy();
                }
            });
        }
    }
}

