/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.transport;

import org.gnunet.transport.BlacklistCallback;
import org.gnunet.transport.messages.BlacklistInitMessage;
import org.gnunet.transport.messages.BlacklistQueryMessage;
import org.gnunet.transport.messages.BlacklistReplyMessage;
import org.gnunet.util.Client;
import org.gnunet.util.Configuration;
import org.gnunet.util.RunaboutMessageReceiver;

public class Blacklist {
    private final BlacklistCallback blacklistCallback;
    private Client client;

    public Blacklist(Configuration configuration, BlacklistCallback blacklistCallback) {
        this.blacklistCallback = blacklistCallback;
        this.client = new Client("transport", configuration);
        this.client.send(new BlacklistInitMessage());
        this.client.installReceiver(new TransportBlacklistReceiver());
    }

    public void destroy() {
        this.client.disconnect();
        this.client = null;
    }

    private final class TransportBlacklistReceiver
    extends RunaboutMessageReceiver {
        private TransportBlacklistReceiver() {
        }

        void visit(BlacklistQueryMessage m) {
            boolean allowed = Blacklist.this.blacklistCallback.checkAllowed(m.peer);
            BlacklistReplyMessage mr = new BlacklistReplyMessage();
            mr.isAllowed = allowed;
            mr.peer = m.peer;
            Blacklist.this.client.send(mr);
        }

        @Override
        public void handleError() {
            Blacklist.this.client.reconnect();
            Blacklist.this.client.send(new BlacklistInitMessage());
        }
    }
}

