/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.gnunet.construct.Construct;
import org.gnunet.construct.MessageLoader;
import org.gnunet.construct.MessageUnion;
import org.gnunet.construct.ProtocolViolationException;
import org.gnunet.util.GnunetMessage;
import org.gnunet.util.MstCalllback;
import org.gnunet.util.UnknownMessageBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageStreamTokenizer {
    private static final Logger logger = LoggerFactory.getLogger(MessageStreamTokenizer.class);
    private MstCalllback mstCalllback;
    private ByteBuffer buffer;
    GnunetMessage.Header msgh;

    public MessageStreamTokenizer(MstCalllback mstCalllback) {
        this.mstCalllback = mstCalllback;
        this.buffer = ByteBuffer.allocate(4);
    }

    public void readAndDispatch() {
        Class<? extends MessageUnion> unionClass = null;
        boolean found = true;
        try {
            unionClass = MessageLoader.getUnionClass(GnunetMessage.Body.class, this.msgh.messageType);
        }
        catch (ProtocolViolationException e) {
            found = false;
        }
        logger.debug("dispatching message");
        if (found) {
            GnunetMessage msg;
            int oldPos = this.buffer.position();
            try {
                msg = Construct.parseAs(this.buffer, GnunetMessage.class);
            }
            catch (OutOfMemoryError e) {
                throw new OutOfMemoryError("oom while parsing " + unionClass);
            }
            int parsedSize = this.buffer.position() - oldPos;
            if (parsedSize != msg.header.messageSize) {
                throw new AssertionError((Object)String.format("mismatch between parsed message and header for %s: parsed size %s, header size %s", msg.body.getClass(), parsedSize, msg.header.messageSize));
            }
            this.mstCalllback.onKnownMessage(msg);
        } else {
            UnknownMessageBody b = new UnknownMessageBody();
            b.id = this.msgh.messageType;
            this.mstCalllback.onUnknownMessage(b);
        }
    }

    public boolean extractOne() {
        if (this.msgh == null && this.buffer.position() >= 4) {
            this.buffer.flip();
            this.msgh = Construct.parseAs(this.buffer, GnunetMessage.Header.class);
            this.buffer.position(0);
            logger.debug("got header in mst (t: " + this.msgh.messageType + ", s: " + this.msgh.messageSize + " (" + this.buffer.limit() + "/" + this.msgh.messageSize + " read)");
            if (this.buffer.capacity() < this.msgh.messageSize) {
                ByteBuffer newBuf = ByteBuffer.allocate(this.msgh.messageSize);
                newBuf.put(this.buffer);
                this.buffer = newBuf;
            } else {
                this.buffer.compact();
            }
            logger.debug("buffer pos is now " + this.buffer.position());
        }
        if (this.msgh != null && this.buffer.position() >= this.msgh.messageSize) {
            this.buffer.flip();
            this.readAndDispatch();
            this.msgh = null;
            this.buffer.compact();
            return true;
        }
        return false;
    }

    public int readFrom(ReadableByteChannel source, boolean oneShot) throws IOException {
        logger.debug("reading in mst from channel");
        int n = source.read(this.buffer);
        logger.debug("read {} bytes from channel", (Object)n);
        if (oneShot) {
            this.extractOne();
        } else {
            while (this.extractOne()) {
            }
        }
        return n;
    }
}

