/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util.crypto;

import java.security.SecureRandom;
import java.util.Arrays;
import org.gnunet.construct.FixedSizeIntegerArray;
import org.gnunet.construct.Message;
import org.gnunet.util.Strings;
import org.gnunet.util.crypto.EcdhePublicKey;
import org.gnunet.util.crypto.EcdsaPublicKey;
import org.gnunet.util.crypto.Ed25519;

public class EddsaPublicKey
implements Message {
    @FixedSizeIntegerArray(bitSize=8, signed=false, length=32)
    public byte[] y;

    public EddsaPublicKey() {
    }

    public EddsaPublicKey(Ed25519 a) {
        this.y = a.encode();
    }

    Ed25519 asPoint() {
        return Ed25519.decode(this.y);
    }

    public EcdhePublicKey fromString(String s) {
        EcdhePublicKey publicKey = new EcdhePublicKey();
        Strings.stringToData(s, publicKey.y);
        return publicKey;
    }

    public static EcdsaPublicKey random() {
        SecureRandom sr = new SecureRandom();
        EcdsaPublicKey publicKey = new EcdsaPublicKey();
        sr.nextBytes(publicKey.y);
        return publicKey;
    }

    public String toString() {
        return Strings.dataToString(this.y);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EcdsaPublicKey publicKey = (EcdsaPublicKey)o;
        return Arrays.equals(this.y, publicKey.y);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.y);
        return result;
    }
}

