/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util.getopt;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gnunet.construct.ReflectUtil;
import org.gnunet.util.getopt.Argument;

public class Parser {
    private Map<String, OptionField> longOpt = new HashMap<String, OptionField>();
    private Map<String, OptionField> shortOpt = new HashMap<String, OptionField>();
    private Collection<Argument> arguments = new LinkedList<Argument>();
    private Object targetObject;

    private List<Field> getFields(Class c) {
        LinkedList<Field> fields = new LinkedList<Field>(Arrays.asList(c.getDeclaredFields()));
        while ((c = c.getSuperclass()) != null) {
            fields.addAll(0, Arrays.asList(c.getDeclaredFields()));
        }
        return fields;
    }

    public Parser(Object targetObject) {
        this.targetObject = targetObject;
        for (Field f : this.getFields(targetObject.getClass())) {
            Argument opt = f.getAnnotation(Argument.class);
            if (opt == null) continue;
            if (opt.shortname().length() != 1) {
                throw new AssertionError((Object)"short name must be of length 1");
            }
            f.setAccessible(true);
            if (this.shortOpt.containsKey(opt.shortname())) {
                throw new AssertionError((Object)String.format("short option '%s' specified multiple times (fields %s and %s)", opt.shortname(), f, this.shortOpt.get((Object)opt.shortname()).f));
            }
            if (this.longOpt.containsKey(opt.longname())) {
                throw new AssertionError((Object)String.format("long option '%s' specified multiple times (fields %s and %s)", opt.longname(), f, this.longOpt.get((Object)opt.longname()).f));
            }
            this.longOpt.put(opt.longname(), new OptionField(opt, f));
            this.shortOpt.put(opt.shortname(), new OptionField(opt, f));
            this.arguments.add(opt);
        }
    }

    public String getHelp() {
        StringBuilder helpString = new StringBuilder();
        for (Argument opt : this.arguments) {
            StringBuilder line = new StringBuilder();
            line.append("  -");
            line.append(opt.shortname());
            line.append(" --");
            line.append(opt.longname());
            if (!opt.argumentName().isEmpty()) {
                line.append("=");
                line.append(opt.argumentName());
            }
            while (line.length() < 30) {
                line.append(" ");
            }
            helpString.append((CharSequence)line);
            helpString.append(" ");
            helpString.append(opt.description());
            helpString.append("\n");
        }
        return helpString.toString();
    }

    private void doLongOpt(LinkedList<String> argsList, Field targetField, Argument argument, String right) {
        try {
            Class<?> targetFieldType = targetField.getType();
            switch (argument.action()) {
                case SET: {
                    if (!targetFieldType.equals(Boolean.TYPE)) {
                        throw new AssertionError((Object)"action SET only valid on boolean member");
                    }
                    targetField.set(this.targetObject, true);
                    break;
                }
                case RESET: {
                    if (!targetFieldType.equals(Boolean.TYPE)) {
                        throw new AssertionError((Object)"action RESET only valid on boolean member");
                    }
                    targetField.set(this.targetObject, false);
                    break;
                }
                case STORE_STRING: {
                    if (!targetFieldType.equals(String.class)) {
                        throw new AssertionError((Object)"action STORE_STRING only valid on boolean member");
                    }
                    if (right == null) {
                        argsList.removeFirst();
                        if (argsList.isEmpty()) {
                            throw new ArgumentError("missing string argument to option " + argument.longname());
                        }
                        targetField.set(this.targetObject, argsList.getFirst());
                        break;
                    }
                    targetField.set(this.targetObject, right);
                    break;
                }
                case STORE_NUMBER: {
                    String numString;
                    ReflectUtil.NumField nf = new ReflectUtil.NumField(targetField);
                    if (right == null) {
                        argsList.removeFirst();
                        if (argsList.isEmpty()) {
                            throw new ArgumentError("missing number argument to option " + argument.longname());
                        }
                        numString = argsList.getFirst();
                    } else {
                        numString = right;
                    }
                    try {
                        nf.set(this.targetObject, Long.parseLong(numString));
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new ArgumentError("error in number format to option " + argument.longname());
                    }
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)String.format("cannot acces member %s with @Option annotation", targetField.getName()));
        }
    }

    private boolean doShortOpt(LinkedList<String> argsList, Field targetField, Argument argument, String shortName) {
        try {
            switch (argument.action()) {
                case SET: {
                    if (!targetField.getType().equals(Boolean.TYPE)) {
                        throw new AssertionError((Object)"action SET only valid on boolean member");
                    }
                    targetField.set(this.targetObject, true);
                    break;
                }
                case RESET: {
                    if (!targetField.getType().equals(Boolean.TYPE)) {
                        throw new AssertionError((Object)"action RESET only valid on boolean field");
                    }
                    targetField.set(this.targetObject, false);
                    break;
                }
                case STORE_STRING: {
                    if (!targetField.getType().equals(String.class)) {
                        throw new AssertionError((Object)"action STORE_STRING only valid on 'String' field");
                    }
                    if (argsList.getFirst().length() == 2) {
                        argsList.removeFirst();
                        if (argsList.isEmpty()) {
                            throw new ArgumentError(String.format("no argument for short option '%s'", shortName));
                        }
                        targetField.set(this.targetObject, argsList.getFirst());
                    } else {
                        targetField.set(this.targetObject, argsList.getFirst().substring(2));
                    }
                    return true;
                }
                case STORE_NUMBER: {
                    String numString;
                    ReflectUtil.NumField nf = new ReflectUtil.NumField(targetField);
                    if (argsList.getFirst().length() == 2) {
                        argsList.removeFirst();
                        if (argsList.isEmpty()) {
                            throw new ArgumentError("missing number argument to option " + argument.longname());
                        }
                        numString = argsList.getFirst();
                    } else {
                        numString = argsList.getFirst().substring(2);
                    }
                    try {
                        nf.set(this.targetObject, Long.parseLong(numString));
                    }
                    catch (NumberFormatException e) {
                        throw new ArgumentError("error in number format to option " + argument.longname());
                    }
                    return true;
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new ArgumentError(String.format("cannot acces member %s with @Option annotation", targetField.getName()));
        }
        return false;
    }

    public String[] parse(String[] args) {
        LinkedList<String> positionalArgs = new LinkedList<String>();
        LinkedList<String> argsList = new LinkedList<String>(Arrays.asList(args));
        while (!argsList.isEmpty()) {
            OptionField of;
            if (argsList.getFirst().equals("--")) {
                argsList.removeFirst();
                positionalArgs.addAll(argsList);
                break;
            }
            if (argsList.getFirst().startsWith("--")) {
                String longOptionString = argsList.getFirst().substring(2);
                String[] components = longOptionString.split("=", 2);
                of = this.longOpt.get(components[0]);
                if (of == null) {
                    throw new ArgumentError(String.format("unknown long option: '%s'", components[0]));
                }
                String right = components.length == 2 ? components[1] : null;
                this.doLongOpt(argsList, of.f, of.opt, right);
            } else if (argsList.getFirst().length() > 1 && argsList.getFirst().startsWith("-")) {
                for (int i = 1; i < argsList.getFirst().length(); ++i) {
                    String optShortName = argsList.getFirst().substring(i, i + 1);
                    of = this.shortOpt.get(optShortName);
                    if (of == null) {
                        throw new ArgumentError(String.format("unknown short option: -%s", Character.valueOf(argsList.getFirst().charAt(i))));
                    }
                    boolean discard = this.doShortOpt(argsList, of.f, of.opt, optShortName);
                    if (discard && i != 1) {
                        throw new ArgumentError("short options with argument must be seperate");
                    }
                    if (!discard) {
                        continue;
                    }
                    break;
                }
            } else {
                positionalArgs.add(argsList.getFirst());
            }
            argsList.removeFirst();
        }
        return positionalArgs.toArray(new String[positionalArgs.size()]);
    }

    static class OptionField {
        Argument opt;
        Field f;

        public OptionField(Argument opt, Field f) {
            this.opt = opt;
            this.f = f;
        }
    }

    public static class ArgumentError
    extends RuntimeException {
        public ArgumentError(String s) {
            super(s);
        }
    }
}

