/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.voting;

import java.math.BigInteger;
import org.gnunet.construct.FixedSizeIntegerArray;
import org.gnunet.construct.Message;
import org.gnunet.secretsharing.Parameters;

public class ChaumPedersenZkp
implements Message {
    @FixedSizeIntegerArray(signed=true, bitSize=8, length=128)
    public byte[] commit_a;
    @FixedSizeIntegerArray(signed=true, bitSize=8, length=128)
    public byte[] commit_b;
    @FixedSizeIntegerArray(signed=true, bitSize=8, length=128)
    public byte[] challenge_d;
    @FixedSizeIntegerArray(signed=true, bitSize=8, length=128)
    public byte[] response_r;

    public boolean verifySim(BigInteger x, BigInteger y, BigInteger coeffG, BigInteger h) {
        BigInteger a = new BigInteger(1, this.commit_a);
        BigInteger b = new BigInteger(1, this.commit_b);
        BigInteger d = new BigInteger(1, this.challenge_d);
        BigInteger r = new BigInteger(1, this.response_r);
        BigInteger g = Parameters.elgamalG;
        BigInteger p = Parameters.elgamalP;
        if (!b.equals(h.modPow(r, p).multiply(y.multiply(coeffG.modInverse(p)).modPow(d, p)).mod(p))) {
            System.out.println("b not equal");
            return false;
        }
        if (!a.equals(g.modPow(r, p).multiply(x.modPow(d, p)).mod(p))) {
            System.out.println("a not equal");
            return false;
        }
        return true;
    }
}

