/* -*- c++ -*- */
/*
 * Copyright 2003,2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */

/*
 * WARNING: This file is automatically generated by
 * generate_gr_fir_util.py.
 *
 * Any changes made to this file will be overwritten.
 */

#ifndef INCLUDED_GR_FIR_UTIL_H
#define INCLUDED_GR_FIR_UTIL_H

/*!
 * \brief routines to create gr_fir_XXX's
 *
 * This class handles selecting the fastest version of the finite
 * implulse response filter available for your platform.  This
 * interface should be used by the rest of the system for creating
 * gr_fir_XXX's.
 *
 * The trailing suffix has the form _IOT where I codes the input type,
 * O codes the output type, and T codes the tap type.
 * I,O,T are elements of the set 's' (short), 'f' (float), 'c' (gr_complex), 
 * 'i' (short)
 */

#include <gr_types.h>

class gr_fir_ccf;
class gr_fir_fcc;
class gr_fir_ccc;
class gr_fir_fff;
class gr_fir_scc;
class gr_fir_fsf;

// structures returned by get_gr_fir_XXX_info methods


struct gr_fir_ccf_info {
  const char    *name;             // implementation name, e.g., "generic", "SSE", "3DNow!"
  gr_fir_ccf	*(*create)(const std::vector<float> &taps);
};

struct gr_fir_fcc_info {
  const char    *name;             // implementation name, e.g., "generic", "SSE", "3DNow!"
  gr_fir_fcc	*(*create)(const std::vector<gr_complex> &taps);
};

struct gr_fir_ccc_info {
  const char    *name;             // implementation name, e.g., "generic", "SSE", "3DNow!"
  gr_fir_ccc	*(*create)(const std::vector<gr_complex> &taps);
};

struct gr_fir_fff_info {
  const char    *name;             // implementation name, e.g., "generic", "SSE", "3DNow!"
  gr_fir_fff	*(*create)(const std::vector<float> &taps);
};

struct gr_fir_scc_info {
  const char    *name;             // implementation name, e.g., "generic", "SSE", "3DNow!"
  gr_fir_scc	*(*create)(const std::vector<gr_complex> &taps);
};

struct gr_fir_fsf_info {
  const char    *name;             // implementation name, e.g., "generic", "SSE", "3DNow!"
  gr_fir_fsf	*(*create)(const std::vector<float> &taps);
};

struct gr_fir_util {

  // create a fast version of gr_fir_XXX.

  static gr_fir_ccf *create_gr_fir_ccf (const std::vector<float> &taps);
  static gr_fir_fcc *create_gr_fir_fcc (const std::vector<gr_complex> &taps);
  static gr_fir_ccc *create_gr_fir_ccc (const std::vector<gr_complex> &taps);
  static gr_fir_fff *create_gr_fir_fff (const std::vector<float> &taps);
  static gr_fir_scc *create_gr_fir_scc (const std::vector<gr_complex> &taps);
  static gr_fir_fsf *create_gr_fir_fsf (const std::vector<float> &taps);

  // Get information about all gr_fir_XXX implementations.
  // This is useful for benchmarking, testing, etc without having to
  // know a priori what's linked into this image
  //
  // The caller must pass in a valid pointer to a vector.
  // The vector will be filled with structs describing the
  // available implementations.

  static void get_gr_fir_ccf_info (std::vector<gr_fir_ccf_info> *info);
  static void get_gr_fir_fcc_info (std::vector<gr_fir_fcc_info> *info);
  static void get_gr_fir_ccc_info (std::vector<gr_fir_ccc_info> *info);
  static void get_gr_fir_fff_info (std::vector<gr_fir_fff_info> *info);
  static void get_gr_fir_scc_info (std::vector<gr_fir_scc_info> *info);
  static void get_gr_fir_fsf_info (std::vector<gr_fir_fsf_info> *info);

};

#endif /* INCLUDED_GR_FIR_UTIL_H */
