
;;; fssadf                asdfasd                    asdfsad
;;; eddfs                 sdadfsc sadsd
;;; (setq str (save-excursion (forward-line -1) (d-current-line-as-string)))
;;; (setq cur (current-column))
(defun d-shift-tab ()
  (interactive)
  (let ((str (save-excursion
               (forward-line -1)
               (d-current-line-as-string)))
        (old (current-column))
        (cur (current-column))
        (n   -1)
        (done nil))
    (if (save-excursion
          (d-goto-column cur)
          (skip-chars-backward " \t")
          (bolp))
        (indent-for-tab-command)
      (while (not done)
        (if (> cur (length str))
            (setq str (save-excursion
                        (forward-line n)
                        (d-current-line-as-string)))
          (setq done t))
        (decf n))
      (while (and (< cur (length str)) (/= ? (aref str cur)))
        (incf cur))
      (while (and (< cur (length str)) (= ? (aref str cur)))
        (incf cur))
      (d-goto-column-force old cur)
      )))

;;; (setq col 20)
;;; (setq old 10)
(defun d-goto-column-force (old col)
  (d-goto-column old)
  (insert (make-string (- col old) ? ))
  (d-goto-column col))

(progn
  (global-set-key [(backtab)] 'd-shift-tab)
  (define-key lisp-mode-map [(shift tab)] 'd-shift-tab)
  (define-key java-mode-map [(shift tab)] 'd-shift-tab)
  (define-key text-mode-map [(shift tab)] 'd-shift-tab))

;;;
;;;
;;; das                 askdjasd           asdsd
;;; daskld              dasdasd            asds
;;; sddd                asdsf              sfdf
;;; dsaasd              asdasdasdasd       dfasdf
;;; asdd                dasdasd            adsasd
;;; adasd               asdads             sdas
;;; asdds               adasda             adasdf
;;; asdsd               dsasd              sddf
;;;
;;; dasds               asdaf              afsdaf
;;;
;;; asdds               sdaf               aafad

(provide 'd-shift-tab)
;;; d-shift-tab.el ends here
