/* Test rint.
   Copyright (C) 1997-2017 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <http://www.gnu.org/licenses/>.  */

#include "libm-test-driver.c"

static const struct test_f_f_data rint_test_data[] =
  {
    TEST_f_f (rint, qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_f_f (rint, -snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_f_f (rint, plus_infty, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, minus_infty, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),

    TEST_f_f (rint, 4.5, 4.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 5.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 3.5, 3.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 3.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 2.5, 2.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 2.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 2.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 3.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 2.0, 2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 1.5, 1.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 2.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 1.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 2.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 1.0, 1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 0.5, 0.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 0.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 0.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 1.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 0.0, 0.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, minus_zero, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -0.5, -1.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -0.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -0.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -0.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -1.0, -1.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -1.5, -2.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -2.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -1.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -1.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -2.0, -2.0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -2.5, -3.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -2.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -2.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -2.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -3.5, -4.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -3.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -3.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -4.5, -5.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 0.1, 0.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 0.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 0.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 1.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 0.25, 0.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 0.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 0.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 1.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 0.625, 0.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 1.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 0.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 1.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -0.1, -1.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -0.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -0.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -0.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -0.25, -1.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -0.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -0.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -0.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -0.625, -1.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -1.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -0.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -0.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 262144.75, 262144.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 262145.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 262144.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 262145.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 262142.75, 262142.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 262143.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 262142.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 262143.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 524286.75, 524286.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 524287.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 524286.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 524287.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 524288.75, 524288.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 524289.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 524288.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 524289.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 1048576.75, 1048576.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 1048577.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 1048576.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 1048577.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 2097152.75, 2097152.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 2097153.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 2097152.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 2097153.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 2492472.75, 2492472.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 2492473.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 2492472.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 2492473.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 2886220.75, 2886220.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 2886221.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 2886220.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 2886221.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 3058792.75, 3058792.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 3058793.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 3058792.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 3058793.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -1048576.75, -1048577.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -1048577.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -1048576.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -1048576.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -2097152.75, -2097153.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -2097153.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -2097152.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -2097152.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -2492472.75, -2492473.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -2492473.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -2492472.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -2492472.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -2886220.75, -2886221.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -2886221.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -2886220.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -2886220.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -3058792.75, -3058793.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -3058793.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -3058792.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -3058792.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if !TEST_COND_binary32
    TEST_f_f (rint, 70368744177664.75, 70368744177664.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 70368744177665.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 70368744177664.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 70368744177665.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 140737488355328.75, 140737488355328.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 140737488355329.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 140737488355328.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 140737488355329.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 281474976710656.75, 281474976710656.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 281474976710657.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 281474976710656.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 281474976710657.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 562949953421312.75, 562949953421312.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 562949953421313.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 562949953421312.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 562949953421313.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 1125899906842624.75, 1125899906842624.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 1125899906842625.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 1125899906842624.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 1125899906842625.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -70368744177664.75, -70368744177665.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -70368744177665.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -70368744177664.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -70368744177664.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -140737488355328.75, -140737488355329.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -140737488355329.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -140737488355328.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -140737488355328.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -281474976710656.75, -281474976710657.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -281474976710657.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -281474976710656.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -281474976710656.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -562949953421312.75, -562949953421313.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -562949953421313.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -562949953421312.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -562949953421312.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -1125899906842624.75, -1125899906842625.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -1125899906842625.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -1125899906842624.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -1125899906842624.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 64
    /* The result can only be represented in long double.  */
    TEST_f_f (rint, 4503599627370495.5L, 4503599627370495.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370495.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 4503599627370496.25L, 4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370497.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 4503599627370496.5L, 4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370497.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 4503599627370496.75L, 4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370497.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370497.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 4503599627370497.5L, 4503599627370497.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370498.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370497.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370498.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
# if MANT_DIG > 100
    TEST_f_f (rint, 1024.5000000000001L, 1024.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 1025.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 1024.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 1025.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 1025.5000000000001L, 1025.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 1026.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 1025.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 1026.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -1024.5000000000001L, -1025.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -1025.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -1024.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -1024.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -1025.5000000000001L, -1026.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -1026.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -1025.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -1025.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 4503599627370494.5000000000001L, 4503599627370494.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370495.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370494.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370495.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 4503599627370495.5000000000001L, 4503599627370495.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370495.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 4503599627370496.5000000000001L, 4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370497.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 4503599627370497.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
# endif
    TEST_f_f (rint, -4503599627370495.5L, -4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370495.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370495.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -4503599627370496.25L, -4503599627370497.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -4503599627370496.5L, -4503599627370497.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -4503599627370496.75L, -4503599627370497.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370497.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -4503599627370497.5L, -4503599627370498.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370498.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370497.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370497.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
# if MANT_DIG > 100
    TEST_f_f (rint, -4503599627370494.5000000000001L, -4503599627370495.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370495.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370494.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370494.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -4503599627370495.5000000000001L, -4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370495.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370495.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -4503599627370496.5000000000001L, -4503599627370497.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370497.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -4503599627370496.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),

    TEST_f_f (rint, 9007199254740991.0000000000001L, 9007199254740991.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740991.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740991.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 9007199254740992.0000000000001L, 9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 9007199254740993.0000000000001L, 9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740994.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 9007199254740991.5000000000001L, 9007199254740991.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740991.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 9007199254740992.5000000000001L, 9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 9007199254740993.5000000000001L, 9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740994.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740994.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),

    TEST_f_f (rint, -9007199254740991.0000000000001L, -9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740991.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740991.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740991.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -9007199254740992.0000000000001L, -9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -9007199254740993.0000000000001L, -9007199254740994.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -9007199254740991.5000000000001L, -9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740991.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740991.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -9007199254740992.5000000000001L, -9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -9007199254740993.5000000000001L, -9007199254740994.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740994.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
# endif

    TEST_f_f (rint, 9007199254740991.5L, 9007199254740991.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740991.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 9007199254740992.25L, 9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 9007199254740992.5L, 9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 9007199254740992.75L, 9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 9007199254740993.5L, 9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740994.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 9007199254740994.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),

    TEST_f_f (rint, -9007199254740991.5L, -9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740991.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740991.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -9007199254740992.25L, -9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -9007199254740992.5L, -9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -9007199254740992.75L, -9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740992.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -9007199254740993.5L, -9007199254740994.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740994.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -9007199254740993.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),

    TEST_f_f (rint, 72057594037927935.5L, 72057594037927935.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 72057594037927936.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 72057594037927935.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 72057594037927936.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 72057594037927936.25L, 72057594037927936.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 72057594037927936.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 72057594037927936.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 72057594037927937.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 72057594037927936.5L, 72057594037927936.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 72057594037927936.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 72057594037927936.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 72057594037927937.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 72057594037927936.75L, 72057594037927936.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 72057594037927937.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 72057594037927936.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 72057594037927937.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 72057594037927937.5L, 72057594037927937.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 72057594037927938.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 72057594037927937.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 72057594037927938.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),

    TEST_f_f (rint, -72057594037927935.5L, -72057594037927936.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -72057594037927936.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -72057594037927935.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -72057594037927935.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -72057594037927936.25L, -72057594037927937.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -72057594037927936.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -72057594037927936.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -72057594037927936.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -72057594037927936.5L, -72057594037927937.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -72057594037927936.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -72057594037927936.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -72057594037927936.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -72057594037927936.75L, -72057594037927937.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -72057594037927937.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -72057594037927936.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -72057594037927936.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -72057594037927937.5L, -72057594037927938.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -72057594037927938.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -72057594037927937.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -72057594037927937.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),

# if MANT_DIG > 100
    TEST_f_f (rint, 10141204801825835211973625643007.5L, 10141204801825835211973625643007.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 10141204801825835211973625643008.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 10141204801825835211973625643007.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 10141204801825835211973625643008.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 10141204801825835211973625643008.25L, 10141204801825835211973625643008.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 10141204801825835211973625643008.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 10141204801825835211973625643008.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 10141204801825835211973625643009.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 10141204801825835211973625643008.5L, 10141204801825835211973625643008.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 10141204801825835211973625643008.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 10141204801825835211973625643008.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 10141204801825835211973625643009.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 10141204801825835211973625643008.75L, 10141204801825835211973625643008.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 10141204801825835211973625643009.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 10141204801825835211973625643008.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 10141204801825835211973625643009.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, 10141204801825835211973625643009.5L, 10141204801825835211973625643009.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 10141204801825835211973625643010.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 10141204801825835211973625643009.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 10141204801825835211973625643010.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
# endif

    /* Check cases where first double is a exact integer higher than
       2^52 and the precision is determined by second long double for
       IBM long double.  */
    TEST_f_f (rint,  34503599627370498.515625L, 34503599627370498.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 34503599627370499.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 34503599627370498.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 34503599627370499.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -34503599627370498.515625L, -34503599627370499.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -34503599627370499.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -34503599627370498.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -34503599627370498.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
# if MANT_DIG >= 106
    TEST_f_f (rint,  1192568192774434123539907640624.484375L, 1192568192774434123539907640624.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 1192568192774434123539907640624.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 1192568192774434123539907640624.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, 1192568192774434123539907640625.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -1192568192774434123539907640624.484375L, -1192568192774434123539907640625.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -1192568192774434123539907640624.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -1192568192774434123539907640624.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED, -1192568192774434123539907640624.0L, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
# endif
#endif

#if !TEST_COND_binary32
    TEST_f_f (rint, -8.98847e+307, -8.98847e+307, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_f (rint, -4.45015e-308, -1.0, INEXACT_EXCEPTION|ERRNO_UNCHANGED, minus_zero, INEXACT_EXCEPTION|ERRNO_UNCHANGED, minus_zero, INEXACT_EXCEPTION|ERRNO_UNCHANGED, minus_zero, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
  };

static void
rint_test (void)
{
  ALL_RM_TEST (rint, 1, rint_test_data, RUN_TEST_LOOP_f_f, END);
}

static void
do_test (void)
{
  rint_test ();
}

/*
 * Local Variables:
 * mode:c
 * End:
 */
